/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.items;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import org.apache.commons.lang3.ArrayUtils;
import xreliquary.Reliquary;
import xreliquary.items.ItemToggleable;
import xreliquary.reference.Settings;
import xreliquary.util.InventoryHelper;
import xreliquary.util.LanguageHelper;
import xreliquary.util.NBTHelper;
import xreliquary.util.RegistryHelper;

public class ItemDestructionCatalyst
extends ItemToggleable {
    public ItemDestructionCatalyst() {
        super("destruction_catalyst");
        this.func_77625_d(1);
        this.canRepair = false;
        this.func_77637_a(Reliquary.CREATIVE_TAB);
    }

    @Override
    protected void addMoreInformation(ItemStack catalyst, @Nullable World world, List<String> tooltip) {
        LanguageHelper.formatTooltip(this.func_77657_g(catalyst) + ".tooltip2", (ImmutableMap<String, String>)ImmutableMap.of((Object)"charge", (Object)String.valueOf(NBTHelper.getInteger("gunpowder", catalyst))), tooltip);
        if (this.isEnabled(catalyst)) {
            LanguageHelper.formatTooltip("tooltip.absorb_active", (ImmutableMap<String, String>)ImmutableMap.of((Object)"item", (Object)(TextFormatting.GRAY + Items.field_151016_H.func_77653_i(new ItemStack(Items.field_151016_H)))), tooltip);
        } else {
            LanguageHelper.formatTooltip("tooltip.absorb", tooltip);
        }
    }

    @Nonnull
    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        if (NBTHelper.getInteger("gunpowder", stack) > this.gunpowderCost() || player.field_71075_bZ.field_75098_d) {
            this.doExplosion(world, pos, side, player, stack);
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.FAIL;
    }

    public void func_77663_a(ItemStack ist, World world, Entity e, int i, boolean b) {
        if (world.field_72995_K) {
            return;
        }
        EntityPlayer player = null;
        if (e instanceof EntityPlayer) {
            player = (EntityPlayer)e;
        }
        if (player == null) {
            return;
        }
        if (this.isEnabled(ist) && NBTHelper.getInteger("gunpowder", ist) + this.gunpowderWorth() < this.gunpowderLimit() && InventoryHelper.consumeItem(new ItemStack(Items.field_151016_H), player)) {
            NBTHelper.setInteger("gunpowder", ist, NBTHelper.getInteger("gunpowder", ist) + this.gunpowderWorth());
        }
    }

    private int getExplosionRadius() {
        return Settings.Items.DestructionCatalyst.explosionRadius;
    }

    private boolean centeredExplosion() {
        return Settings.Items.DestructionCatalyst.centeredExplosion;
    }

    private boolean perfectCube() {
        return Settings.Items.DestructionCatalyst.perfectCube;
    }

    private void doExplosion(World world, BlockPos pos, EnumFacing side, EntityPlayer player, @Nonnull ItemStack stack) {
        boolean destroyedSomething = false;
        boolean playOnce = true;
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        if (!this.centeredExplosion()) {
            y = pos.func_177956_o() + (side == EnumFacing.DOWN ? this.getExplosionRadius() : (side == EnumFacing.UP ? -this.getExplosionRadius() : 0));
            z = pos.func_177952_p() + (side == EnumFacing.NORTH ? this.getExplosionRadius() : (side == EnumFacing.SOUTH ? -this.getExplosionRadius() : 0));
            x = pos.func_177958_n() + (side == EnumFacing.WEST ? this.getExplosionRadius() : (side == EnumFacing.EAST ? -this.getExplosionRadius() : 0));
        }
        for (int xD = -this.getExplosionRadius(); xD <= this.getExplosionRadius(); ++xD) {
            for (int yD = -this.getExplosionRadius(); yD <= this.getExplosionRadius(); ++yD) {
                for (int zD = -this.getExplosionRadius(); zD <= this.getExplosionRadius(); ++zD) {
                    BlockPos target;
                    BlockPos origin;
                    double distance;
                    if (!this.perfectCube() && (distance = (origin = new BlockPos(x, y, z)).func_177951_i((Vec3i)(target = new BlockPos(x + xD, y + yD, z + zD)))) >= (double)this.getExplosionRadius() || !this.isBreakable(RegistryHelper.getBlockRegistryName(world.func_180495_p(new BlockPos(x + xD, y + yD, z + zD)).func_177230_c()))) continue;
                    world.func_175656_a(new BlockPos(x + xD, y + yD, z + zD), Blocks.field_150350_a.func_176223_P());
                    if (world.field_73012_v.nextInt(2) == 0) {
                        world.func_175688_a(EnumParticleTypes.EXPLOSION_LARGE, (double)((float)(x + xD) + (world.field_73012_v.nextFloat() - 0.5f)), (double)((float)(y + yD) + (world.field_73012_v.nextFloat() - 0.5f)), (double)((float)(z + zD) + (world.field_73012_v.nextFloat() - 0.5f)), 0.0, 0.0, 0.0, new int[0]);
                    }
                    destroyedSomething = true;
                    if (!playOnce) continue;
                    world.func_184134_a((double)x, (double)y, (double)z, SoundEvents.field_187539_bB, SoundCategory.BLOCKS, 4.0f, (1.0f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.2f) * 0.7f, false);
                    playOnce = false;
                }
            }
        }
        if (destroyedSomething && !player.field_71075_bZ.field_75098_d) {
            NBTHelper.setInteger("gunpowder", stack, NBTHelper.getInteger("gunpowder", stack) - this.gunpowderCost());
        }
    }

    private boolean isBreakable(String id) {
        return ArrayUtils.contains((Object[])Settings.Items.DestructionCatalyst.mundaneBlocks, (Object)id);
    }

    private int gunpowderCost() {
        return Settings.Items.DestructionCatalyst.gunpowderCost;
    }

    private int gunpowderWorth() {
        return Settings.Items.DestructionCatalyst.gunpowderWorth;
    }

    private int gunpowderLimit() {
        return Settings.Items.DestructionCatalyst.gunpowderLimit;
    }
}

