/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.blocks;

import com.google.common.base.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import xreliquary.blocks.BlockBase;
import xreliquary.blocks.tile.TileEntityPedestalPassive;
import xreliquary.util.InventoryHelper;

public class BlockPedestalPassive
extends BlockBase {
    static final PropertyEnum<EnumDyeColor> COLOR = PropertyEnum.func_177709_a((String)"color", EnumDyeColor.class);
    static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);
    private static final AxisAlignedBB PEDESTAL_AABB = new AxisAlignedBB(0.125, 0.0, 0.125, 0.875, 0.6875, 0.875);

    public BlockPedestalPassive() {
        this("pedestal_passive");
    }

    public BlockPedestalPassive(String name) {
        super(Material.field_151576_e, name);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        for (int i = 0; i < 16; ++i) {
            list.add((Object)new ItemStack((Block)this, 1, i));
        }
    }

    @Nonnull
    public IBlockState func_176221_a(@Nonnull IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        EnumDyeColor color = EnumDyeColor.RED;
        if (worldIn.func_175625_s(pos) instanceof TileEntityPedestalPassive) {
            TileEntityPedestalPassive pedestal = (TileEntityPedestalPassive)worldIn.func_175625_s(pos);
            color = pedestal.getClothColor();
        }
        return state.func_177226_a(COLOR, (Comparable)color);
    }

    @Nonnull
    public ItemStack getPickBlock(@Nonnull IBlockState state, RayTraceResult target, @Nonnull World world, @Nonnull BlockPos pos, EntityPlayer player) {
        int meta = 0;
        if (world.func_175625_s(pos) instanceof TileEntityPedestalPassive) {
            TileEntityPedestalPassive pedestal = (TileEntityPedestalPassive)world.func_175625_s(pos);
            meta = pedestal.getClothColor().func_176765_a();
        }
        return new ItemStack(Item.func_150898_a((Block)this), 1, meta);
    }

    public void getDrops(@Nonnull NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, @Nonnull IBlockState state, int fortune) {
        Item item = Item.func_150898_a((Block)this);
        int meta = 0;
        if (world.func_175625_s(pos) instanceof TileEntityPedestalPassive) {
            TileEntityPedestalPassive pedestal = (TileEntityPedestalPassive)world.func_175625_s(pos);
            meta = pedestal.getClothColor().func_176765_a();
        }
        drops.add((Object)new ItemStack(item, 1, meta));
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        EnumFacing enumfacing = EnumFacing.func_176731_b((int)(meta & 3));
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumfacing);
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, COLOR});
    }

    @Nonnull
    public IBlockState getStateForPlacement(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull EnumFacing facing, float hitX, float hitY, float hitZ, int meta, @Nonnull EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO()).func_177226_a(COLOR, (Comparable)EnumDyeColor.func_176764_b((int)meta));
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.func_180633_a(worldIn, pos, state, placer, stack);
        if (worldIn.func_175625_s(pos) instanceof TileEntityPedestalPassive) {
            TileEntityPedestalPassive pedestal = (TileEntityPedestalPassive)worldIn.func_175625_s(pos);
            pedestal.setColor((EnumDyeColor)state.func_177229_b(COLOR));
        }
    }

    public String getHarvestTool(@Nonnull IBlockState state) {
        return "pickaxe";
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b();
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack heldItem = player.func_184586_b(hand);
        if (world.field_72995_K) {
            return !heldItem.func_190926_b() || player.func_70093_af();
        }
        if (!(world.func_175625_s(pos) instanceof TileEntityPedestalPassive)) {
            return false;
        }
        TileEntityPedestalPassive pedestal = (TileEntityPedestalPassive)world.func_175625_s(pos);
        if (heldItem.func_190926_b()) {
            if (player.func_70093_af()) {
                pedestal.removeLastPedestalStack();
                return true;
            }
            return false;
        }
        return InventoryHelper.getItemHandlerFrom(pedestal).map(itemHandler -> InventoryHelper.tryAddingPlayerCurrentItem(player, itemHandler, EnumHand.MAIN_HAND)).orElse(false);
    }

    public void func_180663_b(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        TileEntityPedestalPassive pedestal = (TileEntityPedestalPassive)world.func_175625_s(pos);
        if (pedestal != null) {
            pedestal.dropPedestalInventory();
        }
        super.func_180663_b(world, pos, state);
    }

    public boolean removedByPlayer(@Nonnull IBlockState state, World world, @Nonnull BlockPos pos, @Nonnull EntityPlayer player, boolean willHarvest) {
        return willHarvest || super.removedByPlayer(state, world, pos, player, false);
    }

    public void func_180657_a(@Nonnull World world, EntityPlayer player, @Nonnull BlockPos pos, @Nonnull IBlockState state, TileEntity te, ItemStack tool) {
        super.func_180657_a(world, player, pos, state, te, tool);
        world.func_175698_g(pos);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nonnull
    public TileEntity createTileEntity(@Nonnull World world, @Nonnull IBlockState state) {
        return new TileEntityPedestalPassive();
    }

    @Nonnull
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return PEDESTAL_AABB;
    }

    @SubscribeEvent
    public void onRightClicked(PlayerInteractEvent.RightClickBlock event) {
        EntityPlayer player = event.getEntityPlayer();
        if (!player.func_70093_af() || !player.func_184614_ca().func_190926_b() || player.func_184592_cb().func_190926_b()) {
            return;
        }
        Block block = player.field_70170_p.func_180495_p(event.getPos()).func_177230_c();
        if (block != this) {
            return;
        }
        TileEntityPedestalPassive pedestal = (TileEntityPedestalPassive)player.field_70170_p.func_175625_s(event.getPos());
        if (pedestal != null) {
            pedestal.removeLastPedestalStack();
        }
        event.setCanceled(true);
    }
}

