/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.libVulpes.tile;

import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import zmaster587.libVulpes.cap.FluidCapability;
import zmaster587.libVulpes.tile.TileInventoriedRFConsumer;

public abstract class TileInventoriedRFConsumerTank
extends TileInventoriedRFConsumer
implements IFluidHandler {
    protected FluidTank tank;

    protected TileInventoriedRFConsumerTank(int energy, int invSize, int tankSize) {
        super(energy, invSize);
        this.tank = new FluidTank(tankSize);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        NBTTagCompound tanks = new NBTTagCompound();
        this.tank.writeToNBT(tanks);
        nbt.func_74782_a("tank", (NBTBase)tanks);
        return nbt;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        if (nbt.func_74764_b("tank")) {
            this.tank.readFromNBT((NBTTagCompound)nbt.func_74781_a("tank"));
        }
    }

    public int fill(FluidStack resource, boolean doFill) {
        return this.canFill(resource.getFluid()) ? this.tank.fill(resource, doFill) : 0;
    }

    public boolean canFill(Fluid fluid) {
        return true;
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)new FluidCapability(this);
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public NBTTagCompound serializeNBT() {
        return new NBTTagCompound();
    }

    @Override
    public void deserializeNBT(NBTTagCompound nbt) {
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        return this.tank.drain(resource.amount, doDrain);
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        return this.tank.drain(maxDrain, doDrain);
    }

    public IFluidTankProperties[] getTankProperties() {
        return this.tank.getTankProperties();
    }
}

