/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.mysticalworld.world;

import epicsquid.mysticallib.world.IOreGenerator;
import epicsquid.mysticalworld.config.ConfigManager;
import epicsquid.mysticalworld.materials.Gem;
import epicsquid.mysticalworld.materials.Metal;
import epicsquid.mysticalworld.world.WorldGenMinableDebug;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;

public class OreGenerator
implements IOreGenerator {
    public Map<String, Config> configMap = new HashMap<String, Config>();

    private void generateOre(String oreName, @Nonnull IBlockState ore, @Nonnull World world, @Nonnull Random random, int x, int z, int minY, int maxY, int size, int numberToGenerate) {
        for (int i = 0; i < numberToGenerate; ++i) {
            BlockPos pos = new BlockPos(x * 16 + random.nextInt(16), random.nextInt(maxY - minY) + minY, z * 16 + random.nextInt(16));
            WorldGenMinableDebug generator = new WorldGenMinableDebug(oreName, ore, size);
            generator.func_180709_b(world, random, pos);
        }
    }

    public void generate(@Nonnull Random random, int chunkX, int chunkZ, @Nonnull World world, @Nonnull IChunkGenerator chunkGenerator, @Nonnull IChunkProvider chunkProvider) {
        Config conf;
        if (world.field_73011_w.getDimension() == 0 && ConfigManager.metals.enableOres) {
            for (Enum enum_ : Metal.values()) {
                if (enum_ == Metal.copper && !ConfigManager.metals.enableCopper || enum_ == Metal.silver && !ConfigManager.metals.enableSilver || !((Metal)enum_).hasOre() || !((Metal)enum_).isEnabled() || (conf = this.getConfig(enum_.name())) == null || conf.perChunk <= 0 || ((Metal)enum_).getOre() == null) continue;
                this.generateOre(((Metal)enum_).getOredictNameSuffix(), ((Metal)enum_).getOre().func_176223_P(), world, random, chunkX, chunkZ, conf.minY, conf.maxY, conf.veinSize, conf.perChunk);
            }
        }
        if (world.field_73011_w.getDimension() == 0 && ConfigManager.gems.enableOres) {
            for (Enum enum_ : Gem.values()) {
                if (enum_ == Gem.amethyst && !ConfigManager.gems.enableAmethyst || !((Gem)enum_).hasOre() || !((Gem)enum_).isEnabled() || (conf = this.getConfig(enum_.name())) == null || conf.perChunk <= 0 || ((Gem)enum_).getOre() == null) continue;
                this.generateOre(((Gem)enum_).getOredictNameSuffix(), ((Gem)enum_).getOre().func_176223_P(), world, random, chunkX, chunkZ, conf.minY, conf.maxY, conf.veinSize, conf.perChunk);
            }
        }
    }

    @Nullable
    private Config getConfig(String name) {
        if (this.configMap.containsKey(name = name.toLowerCase())) {
            return this.configMap.get(name);
        }
        Config conf = Config.fromConfig(name);
        this.configMap.put(name, conf);
        return this.configMap.get(name);
    }

    public static class Config {
        public int perChunk;
        public int veinSize;
        public int maxY;
        public int minY;

        public Config(int perChunk, int veinSize, int maxY, int minY) {
            this.perChunk = perChunk;
            this.veinSize = veinSize;
            this.maxY = maxY;
            this.minY = minY;
        }

        public static Config fromConfig(String name) {
            int minY;
            int maxY;
            int veinSize;
            int perChunk;
            try {
                perChunk = ConfigManager.oreGen.getClass().getField(name + "PerChunk").getInt(ConfigManager.oreGen);
                veinSize = ConfigManager.oreGen.getClass().getField(name + "VeinSize").getInt(ConfigManager.oreGen);
                maxY = ConfigManager.oreGen.getClass().getField(name + "MaxY").getInt(ConfigManager.oreGen);
                minY = ConfigManager.oreGen.getClass().getField(name + "MinY").getInt(ConfigManager.oreGen);
            }
            catch (Exception e) {
                return null;
            }
            return new Config(perChunk, veinSize, maxY, minY);
        }
    }
}

