/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.mysticalworld.materials;

import epicsquid.mysticallib.block.BlockBase;
import epicsquid.mysticallib.block.BlockOreBase;
import epicsquid.mysticallib.event.RegisterContentEvent;
import epicsquid.mysticallib.item.ItemBase;
import epicsquid.mysticallib.material.MaterialTypes;
import epicsquid.mysticalworld.MysticalWorld;
import epicsquid.mysticalworld.config.ConfigManager;
import epicsquid.mysticalworld.materials.IGem;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.item.Item;
import net.minecraftforge.oredict.OreDictionary;

public enum Gem implements IGem
{
    amethyst("Amethyst", 3.0f, 0.7f, 2, 3, 7, MaterialTypes.material((String)"mysticalworld:amethyst"), true);

    private Item gem;
    private Block block;
    private Block ore;
    private final int level;
    private final float hardness;
    private final String oredictNameSuffix;
    private final float experience;
    private final int minXP;
    private final int maxXP;
    private final Item.ToolMaterial material;
    private boolean hasTool;

    private Gem(String oredictNameSuffix, float hardness, float experience, int level, int minXP, int maxXP, Item.ToolMaterial toolMaterial, boolean hasTool) {
        this.oredictNameSuffix = oredictNameSuffix;
        this.hardness = hardness;
        this.experience = experience;
        this.level = level;
        this.minXP = minXP;
        this.maxXP = maxXP;
        this.material = toolMaterial;
        this.hasTool = hasTool;
    }

    @Override
    public boolean hasTool() {
        return this.hasTool;
    }

    @Override
    public Item.ToolMaterial getMaterial() {
        return this.material;
    }

    @Override
    public int getMinXP() {
        return this.minXP;
    }

    @Override
    public int getMaxXP() {
        return this.maxXP;
    }

    @Override
    @Nullable
    public Item getGem() {
        return this.gem;
    }

    @Override
    @Nonnull
    public Item setGem(@Nonnull Item item) {
        this.gem = item;
        return item;
    }

    @Override
    public float getHardness() {
        return this.hardness;
    }

    @Override
    public float getExperience() {
        return this.experience;
    }

    @Override
    @Nonnull
    public String getOredictNameSuffix() {
        return this.oredictNameSuffix;
    }

    @Override
    @Nullable
    public Block getBlock() {
        return this.block;
    }

    @Override
    @Nonnull
    public Block setBlock(@Nonnull Block block) {
        this.block = block;
        return block;
    }

    @Override
    @Nullable
    public Block getOre() {
        return this.ore;
    }

    @Override
    @Nonnull
    public Block setOre(@Nonnull Block ore) {
        this.ore = ore;
        return ore;
    }

    @Override
    public boolean isEnabled() {
        if (this == amethyst) {
            return ConfigManager.gems.enableAmethyst;
        }
        return false;
    }

    @Override
    public boolean hasGrindables() {
        return false;
    }

    @Override
    public boolean hasOre() {
        return this == amethyst;
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    public static void registerGems(@Nonnull RegisterContentEvent event) {
        for (Gem gem : Gem.values()) {
            if (!gem.isEnabled()) continue;
            if (ConfigManager.gems.enableGems) {
                event.addItem(gem.setGem(new ItemBase(gem.name() + "_gem").setModelCustom(true).func_77637_a(MysticalWorld.tab)));
            }
            if (ConfigManager.gems.enableBlocks) {
                event.addBlock(gem.setBlock(new BlockBase(Material.field_151573_f, SoundType.field_185852_e, gem.getHardness(), gem.name() + "_block").setModelCustom(true).func_149647_a(MysticalWorld.tab)));
            }
            if (!gem.hasOre() || !ConfigManager.gems.enableOres) continue;
            event.addBlock(gem.setOre(new BlockOreBase(Material.field_151576_e, SoundType.field_185851_d, gem.getHardness(), gem.name() + "_ore", gem.getGem(), gem.getLevel(), gem.getMinXP(), gem.getMaxXP()).setModelCustom(true).func_149647_a(MysticalWorld.tab)));
        }
    }

    public static void registerOreDict() {
        for (Gem gem : Gem.values()) {
            if (!gem.isEnabled()) continue;
            if (ConfigManager.gems.enableGems) {
                OreDictionary.registerOre((String)("gem" + gem.getOredictNameSuffix()), (Item)gem.getGem());
            }
            if (ConfigManager.gems.enableBlocks) {
                OreDictionary.registerOre((String)("block" + gem.getOredictNameSuffix()), (Block)gem.getBlock());
            }
            if (!gem.hasOre() || !ConfigManager.gems.enableOres) continue;
            OreDictionary.registerOre((String)("ore" + gem.getOredictNameSuffix()), (Block)gem.getOre());
        }
    }
}

