/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.evaluate.operator;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import net.minecraft.util.EnumFacing;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.commoncapabilities.api.capability.recipehandler.IRecipeHandler;
import org.cyclops.commoncapabilities.api.ingredient.IMixedIngredients;
import org.cyclops.cyclopscore.datastructure.DimPos;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.core.evaluate.operator.OperatorBase;
import org.cyclops.integrateddynamics.core.evaluate.operator.PositionedOperatorRecipeHandler;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeIngredients;

public class PositionedOperatorRecipeHandlerOutput<T extends IValueType<V>, V extends IValue>
extends PositionedOperatorRecipeHandler<T, V> {
    private static final Cache<Pair<Pair<DimPos, EnumFacing>, ValueObjectTypeIngredients.ValueIngredients>, ValueObjectTypeIngredients.ValueIngredients> CACHE = CacheBuilder.newBuilder().expireAfterAccess(20L, TimeUnit.SECONDS).build();

    public PositionedOperatorRecipeHandlerOutput(DimPos pos, EnumFacing side) {
        super("recipeoutputbyinput", new Function(), pos, side);
    }

    public PositionedOperatorRecipeHandlerOutput() {
        this(null, null);
    }

    public static class Function
    extends PositionedOperatorRecipeHandler.Function {
        @Override
        public IValue evaluate(OperatorBase.SafeVariablesGetter variables) throws EvaluationException {
            ValueObjectTypeIngredients.ValueIngredients ingredients = (ValueObjectTypeIngredients.ValueIngredients)variables.getValue(0);
            IRecipeHandler recipeHandler = this.getOperator().getRecipeHandler();
            if (recipeHandler != null && ingredients.getRawValue().isPresent()) {
                Pair key = Pair.of((Object)Pair.of((Object)this.getOperator().getPos(), (Object)this.getOperator().getSide()), (Object)ingredients);
                try {
                    return (IValue)CACHE.get((Object)key, () -> {
                        IMixedIngredients output = recipeHandler.simulate((IMixedIngredients)ingredients.getRawValue().get());
                        return ValueObjectTypeIngredients.ValueIngredients.of(output);
                    });
                }
                catch (ExecutionException executionException) {
                    // empty catch block
                }
            }
            return ValueObjectTypeIngredients.ValueIngredients.of(null);
        }
    }
}

