/*
 * Decompiled with CFR 0.152.
 */
package com.bafomdad.realfilingcabinet.utils;

import com.bafomdad.realfilingcabinet.blocks.tiles.TileFilingCabinet;
import com.bafomdad.realfilingcabinet.helpers.UpgradeHelper;
import com.bafomdad.realfilingcabinet.helpers.enums.FolderType;
import com.bafomdad.realfilingcabinet.init.RFCItems;
import com.bafomdad.realfilingcabinet.items.capabilities.CapabilityFolder;
import com.bafomdad.realfilingcabinet.network.VanillaPacketDispatcher;
import com.bafomdad.realfilingcabinet.utils.FolderUtils;
import com.bafomdad.realfilingcabinet.utils.NBTUtils;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class EnderUtils {
    private static LoadingCache<ItemStack, TileFilingCabinet> cache = CacheBuilder.newBuilder().concurrencyLevel(2).maximumSize(10L).expireAfterWrite(10L, TimeUnit.SECONDS).build((CacheLoader)new CacheLoader<ItemStack, TileFilingCabinet>(){

        public TileFilingCabinet load(ItemStack stack) throws Exception {
            EnderUtils.setTile(stack);
            return loadedTile;
        }
    });
    private static TileFilingCabinet loadedTile;

    public static void setTile(ItemStack stack) {
        TileFilingCabinet tile;
        if (!stack.func_190926_b() && stack.func_77973_b() == RFCItems.FOLDER && stack.func_77952_i() == FolderType.ENDER.ordinal() && (tile = EnderUtils.getTileLoc(stack)) != null) {
            loadedTile = tile;
        }
    }

    private static LoadingCache<ItemStack, TileFilingCabinet> getCache() {
        return cache;
    }

    public static TileFilingCabinet getCachedTile(ItemStack stack) {
        if (EnderUtils.getCache() == null || loadedTile == null) {
            return EnderUtils.getTileLoc(stack);
        }
        try {
            return (TileFilingCabinet)cache.get((Object)stack);
        }
        catch (ExecutionException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Deprecated
    public static void syncToFolder(TileFilingCabinet tile, ItemStack stack, int index) {
        CapabilityFolder cap = FolderUtils.get(tile.getInventory().getFolder(index)).getCap();
        if (cap == null || !cap.isItemStack() || !EnderUtils.hashMatches(stack, tile)) {
            FolderUtils.get(stack).setObject(ItemStack.field_190927_a);
            FolderUtils.get(stack).setFileSize(0L);
            return;
        }
        long folderSize = cap.getCount();
        if (EnderUtils.hashMatches(stack, tile)) {
            if (!(FolderUtils.get(stack).getObject() instanceof ItemStack)) {
                FolderUtils.get(stack).setObject(cap.getContents());
            }
            if (folderSize != FolderUtils.get(stack).getFileSize()) {
                FolderUtils.get(stack).setFileSize(folderSize);
            }
            return;
        }
    }

    public static void syncToFolder(ItemStack folder) {
        TileFilingCabinet tile = EnderUtils.getCachedTile(folder);
        int slotIndex = NBTUtils.getInt(folder, "RFC_slotindex", 0);
        CapabilityFolder cap = FolderUtils.get(tile.getInventory().getFolder(slotIndex)).getCap();
        if (cap == null || !cap.isItemStack() || !EnderUtils.hashMatches(folder, tile)) {
            FolderUtils.get(folder).setObject(ItemStack.field_190927_a);
            FolderUtils.get(folder).setFileSize(0L);
            return;
        }
        long folderSize = cap.getCount();
        if (FolderUtils.get(folder).getObject() instanceof ItemStack) {
            FolderUtils.get(folder).setObject(cap.getContents());
        }
        if (folderSize != FolderUtils.get(folder).getFileSize()) {
            FolderUtils.get(folder).setFileSize(folderSize);
        }
    }

    @Deprecated
    public static void syncToTile(TileFilingCabinet tile, int dim, int index, int amount) {
        if (tile == null || UpgradeHelper.getUpgrade(tile, "TAG_enderUpgrade").isEmpty()) {
            return;
        }
        ItemStack folder = tile.getInventory().getFolder(index);
        if (folder.func_77973_b() != RFCItems.FOLDER) {
            return;
        }
        FolderUtils.get(folder).add(amount);
        VanillaPacketDispatcher.dispatchTEToNearbyPlayers(tile);
    }

    public static void syncToTile(ItemStack folder) {
        TileFilingCabinet tile = EnderUtils.getCachedTile(folder);
        if (tile == null || UpgradeHelper.getUpgrade(tile, "TAG_enderUpgrade").isEmpty()) {
            return;
        }
        int index = NBTUtils.getInt(folder, "RFC_slotindex", 0);
        ItemStack tileFolder = tile.getInventory().getFolder(index);
        CapabilityFolder cap = FolderUtils.get(tileFolder).getCap();
        if (cap == null || !cap.isItemStack()) {
            return;
        }
        cap.setCount(cap.getCount() + (long)FolderUtils.get(folder).getExtractSize());
        FolderUtils.get(folder).setExtractSize(0);
        VanillaPacketDispatcher.dispatchTEToNearbyPlayers(tile);
    }

    public static ItemStack createEnderFolder(TileFilingCabinet tile, EntityPlayer player, ItemStack stack) {
        NBTTagCompound playerTag = player.getEntityData();
        if (!playerTag.func_74764_b("RFC_slotindex")) {
            playerTag.func_74768_a("RFC_slotindex", 0);
        }
        ItemStack enderFolder = stack.func_77946_l();
        enderFolder.func_77964_b(1);
        NBTUtils.setInt(enderFolder, "RFC_slotindex", playerTag.func_74762_e("RFC_slotindex"));
        NBTUtils.setInt(enderFolder, "RFC_enderhash", tile.getHash());
        EnderUtils.setTileLoc(tile, enderFolder);
        return enderFolder;
    }

    public static void setTileLoc(TileFilingCabinet tile, ItemStack stack) {
        BlockPos pos = tile.func_174877_v();
        int dim = tile.func_145831_w().field_73011_w.getDimension();
        NBTTagCompound posTag = NBTUtils.getCompound(stack, "RFC_tilepos", false);
        posTag.func_74768_a("X", pos.func_177958_n());
        posTag.func_74768_a("Y", pos.func_177956_o());
        posTag.func_74768_a("Z", pos.func_177952_p());
        NBTUtils.setCompound(stack, "RFC_tilepos", posTag);
        NBTUtils.setInt(stack, "RFC_dim", dim);
        EnderUtils.setTile(stack);
    }

    public static TileFilingCabinet getTileLoc(ItemStack stack) {
        NBTTagCompound posTag = NBTUtils.getCompound(stack, "RFC_tilepos", true);
        if (posTag != null) {
            int x = posTag.func_74762_e("X");
            int y = posTag.func_74762_e("Y");
            int z = posTag.func_74762_e("Z");
            int dim = NBTUtils.getInt(stack, "RFC_dim", 0);
            return EnderUtils.findLoadedTileEntityInWorld(new BlockPos(x, y, z), dim);
        }
        return null;
    }

    public static TileFilingCabinet findLoadedTileEntityInWorld(BlockPos pos, int dim) {
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        if (server == null) {
            return null;
        }
        if (pos.func_177956_o() == -1) {
            return null;
        }
        for (WorldServer world : server.field_71305_c) {
            for (Object obj : world.field_147482_g) {
                if (!(obj instanceof TileFilingCabinet) || world.field_73011_w.getDimension() != dim || !pos.equals((Object)((TileFilingCabinet)obj).func_174877_v()) || UpgradeHelper.getUpgrade((TileFilingCabinet)obj, "TAG_enderUpgrade").isEmpty() || !world.func_175667_e(pos)) continue;
                return (TileFilingCabinet)world.func_175625_s(pos);
            }
        }
        return null;
    }

    public static int createHash(TileFilingCabinet tile) {
        String str = new String("" + tile.func_174877_v().func_177986_g() + tile.func_145831_w().func_82737_E());
        return str.hashCode();
    }

    private static boolean hashMatches(ItemStack stack, TileFilingCabinet tile) {
        if (tile == null) {
            return false;
        }
        return NBTUtils.getInt(stack, "RFC_enderhash", -1) == tile.getHash();
    }

    public static boolean preValidateEnderFolder(ItemStack stack) {
        TileFilingCabinet tile = EnderUtils.getTileLoc(stack);
        if (tile == null) {
            return false;
        }
        return tile == null || EnderUtils.hashMatches(stack, tile);
    }
}

