/*
 * Decompiled with CFR 0.152.
 */
package com.bafomdad.realfilingcabinet.blocks.tiles;

import com.bafomdad.realfilingcabinet.blocks.tiles.TileEntityRFC;
import com.bafomdad.realfilingcabinet.items.ItemAspectFolder;
import com.bafomdad.realfilingcabinet.utils.AspectStorageUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.aspects.IAspectSource;
import thaumcraft.api.aspects.IEssentiaContainerItem;
import thaumcraft.api.aspects.IEssentiaTransport;

public class TileAspectCabinet
extends TileEntityRFC
implements IAspectSource,
IEssentiaTransport {
    @Override
    public ItemStack getFilter() {
        return super.getFilter().func_77973_b() instanceof IEssentiaContainerItem ? super.getFilter() : ItemStack.field_190927_a;
    }

    public ItemStack getAspectFolder(Aspect tag) {
        for (int i = 0; i < this.getInventory().getSlots(); ++i) {
            Aspect asp;
            ItemStack folder = this.getInventory().getFolder(i);
            if (folder.func_190926_b() || !(folder.func_77973_b() instanceof ItemAspectFolder) || (asp = ItemAspectFolder.getAspectFromFolder(folder)) != tag) continue;
            return folder;
        }
        return ItemStack.field_190927_a;
    }

    public int addToContainer(Aspect tag, int amount) {
        if (amount == 0) {
            return amount;
        }
        int internalCount = this.containerContains(tag);
        if (internalCount < ItemAspectFolder.getMaxAmount() || internalCount == 0) {
            int added = Math.max(amount, internalCount - ItemAspectFolder.getMaxAmount());
            ItemAspectFolder.incrementAspect(this.getAspectFolder(tag), added);
            amount -= added;
        }
        this.func_70296_d();
        return amount;
    }

    public int containerContains(Aspect tag) {
        if (!this.getAspectFolder(tag).func_190926_b()) {
            return ItemAspectFolder.getAspectCount(this.getAspectFolder(tag));
        }
        return -1;
    }

    public boolean doesContainerAccept(Aspect tag) {
        return !this.getAspectFolder(tag).func_190926_b();
    }

    @Deprecated
    public boolean doesContainerContain(AspectList aspects) {
        return false;
    }

    public boolean doesContainerContainAmount(Aspect tag, int amount) {
        ItemStack folder = this.getAspectFolder(tag);
        if (folder.func_190926_b()) {
            return false;
        }
        int internalCount = ItemAspectFolder.getAspectCount(folder);
        Aspect internalAsp = ItemAspectFolder.getAspectFromFolder(folder);
        return internalCount >= amount && tag == internalAsp;
    }

    public AspectList getAspects() {
        AspectList al = new AspectList();
        for (int i = 0; i < this.getInventory().getSlots(); ++i) {
            ItemStack folder = this.getInventory().getFolder(i);
            if (folder.func_190926_b() || !(folder.func_77973_b() instanceof ItemAspectFolder)) continue;
            Aspect asp = ItemAspectFolder.getAspectFromFolder(folder);
            int amount = ItemAspectFolder.getAspectCount(folder);
            al.add(asp, amount);
        }
        return al;
    }

    public void setAspects(AspectList aspects) {
        Aspect asp;
        ItemStack folder;
        if (aspects != null && aspects.size() > 0 && !(folder = this.getAspectFolder(asp = aspects.getAspectsSortedByAmount()[0])).func_190926_b()) {
            ItemAspectFolder.setAspect(folder, asp);
            ItemAspectFolder.setAspectCount(folder, aspects.getAmount(asp));
        }
    }

    @Deprecated
    public boolean takeFromContainer(AspectList aspects) {
        return false;
    }

    public boolean takeFromContainer(Aspect tag, int amount) {
        if (this.doesContainerContainAmount(tag, amount)) {
            ItemStack folder = this.getAspectFolder(tag);
            ItemAspectFolder.decrementAspect(folder, amount);
            this.func_70296_d();
            return true;
        }
        return false;
    }

    public boolean isConnectable(EnumFacing facing) {
        return facing != EnumFacing.DOWN;
    }

    public boolean canInputFrom(EnumFacing facing) {
        return facing != EnumFacing.DOWN;
    }

    public boolean canOutputTo(EnumFacing facing) {
        return facing == EnumFacing.DOWN;
    }

    public void setSuction(Aspect asp, int amount) {
    }

    public Aspect getSuctionType(EnumFacing facing) {
        return AspectStorageUtils.getFirstAspectStored(this, this.getFilter()).getAspects()[0];
    }

    public int getSuctionAmount(EnumFacing facing) {
        return 64;
    }

    public int takeEssentia(Aspect asp, int amount, EnumFacing facing) {
        return this.canOutputTo(facing) && this.takeFromContainer(asp, amount) ? amount : 0;
    }

    public int addEssentia(Aspect asp, int amount, EnumFacing facing) {
        return this.canInputFrom(facing) ? amount - this.addToContainer(asp, amount) : 0;
    }

    public Aspect getEssentiaType(EnumFacing facing) {
        return this.getSuctionType(facing);
    }

    public int getEssentiaAmount(EnumFacing facing) {
        return AspectStorageUtils.getFirstAspectStored(this, this.getFilter()).getAmount(this.getSuctionType(facing));
    }

    public int getMinimumSuction() {
        return 32;
    }

    public boolean isBlocked() {
        return false;
    }
}

