/*
 * Decompiled with CFR 0.152.
 */
package com.bafomdad.realfilingcabinet.blocks;

import com.bafomdad.realfilingcabinet.api.IBlockCabinet;
import com.bafomdad.realfilingcabinet.api.ILockableCabinet;
import com.bafomdad.realfilingcabinet.blocks.tiles.TileEntityRFC;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class BlockRFC
extends Block
implements IBlockCabinet {
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;

    public BlockRFC(Material mat) {
        super(mat);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
    }

    public abstract void leftClick(TileEntity var1, EntityPlayer var2);

    public abstract void rightClick(TileEntity var1, EntityPlayer var2, EnumFacing var3);

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    public boolean isSideSolid(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return side != EnumFacing.DOWN && side.func_176745_a() != ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
    }

    private boolean isLocked(TileEntity tile, EntityPlayer player) {
        if (!(tile instanceof ILockableCabinet)) {
            return false;
        }
        ILockableCabinet cabinet = (ILockableCabinet)tile;
        return cabinet.isCabinetLocked() && !cabinet.getOwner().equals(player.func_110124_au()) && !cabinet.hasKeyCopy(player, cabinet.getOwner());
    }

    public void func_180649_a(World world, BlockPos pos, EntityPlayer player) {
        TileEntity tile = world.func_175625_s(pos);
        if (!(this.isLocked(tile, player) || world.field_72995_K || player.field_71075_bZ.field_75098_d)) {
            this.leftClick(tile, player);
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntity tile = world.func_175625_s(pos);
        if (hand == EnumHand.MAIN_HAND && !this.isLocked(tile, player)) {
            this.rightClick(tile, player, facing);
            return true;
        }
        return false;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        NonNullList list = NonNullList.func_191196_a();
        this.getDrops((NonNullList<ItemStack>)list, (IBlockAccess)world, pos, state, 0);
        return (ItemStack)list.get(0);
    }

    public void func_176208_a(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        TileEntityRFC tile = (TileEntityRFC)world.func_175625_s(pos);
        if (this.isLocked(tile, player)) {
            return false;
        }
        if (willHarvest) {
            this.func_176208_a(world, pos, state, player);
            return true;
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest);
    }

    public void func_180657_a(World world, EntityPlayer player, BlockPos pos, IBlockState state, TileEntity tile, ItemStack stack) {
        super.func_180657_a(world, player, pos, state, tile, stack);
        world.func_175698_g(pos);
    }

    public void getDrops(NonNullList<ItemStack> list, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        super.getDrops(list, world, pos, state, fortune);
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null) {
            ((TileEntityRFC)tile).getDrops(list);
        }
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase entity, ItemStack stack) {
        world.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)entity.func_174811_aO().func_176734_d()), 2);
        ((TileEntityRFC)world.func_175625_s(pos)).onPlaced(world, pos, state, stack);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)meta));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b();
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return false;
    }

    public boolean func_149637_q(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.ENTITYBLOCK_ANIMATED;
    }
}

