/*
 * Decompiled with CFR 0.152.
 */
package binnie.genetics.item;

import binnie.core.ModId;
import binnie.core.api.genetics.IGene;
import binnie.core.api.genetics.IItemAnalysable;
import binnie.core.genetics.Gene;
import binnie.core.item.ItemCore;
import binnie.core.util.I18N;
import binnie.genetics.CreativeTabGenetics;
import binnie.genetics.api.IItemChargeable;
import binnie.genetics.genetics.GeneItem;
import binnie.genetics.genetics.SequencerItem;
import binnie.genetics.modules.ModuleCore;
import com.google.common.base.Preconditions;
import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.EnumBeeChromosome;
import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.api.arboriculture.EnumTreeChromosome;
import forestry.api.arboriculture.IAlleleTreeSpecies;
import forestry.api.arboriculture.TreeManager;
import forestry.api.core.ForestryAPI;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IChromosomeType;
import forestry.api.genetics.ISpeciesRoot;
import forestry.api.lepidopterology.ButterflyManager;
import forestry.api.lepidopterology.EnumButterflyChromosome;
import forestry.api.lepidopterology.IAlleleButterflySpecies;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemSequence
extends ItemCore
implements IItemAnalysable,
IItemChargeable {
    public ItemSequence() {
        super("sequence");
        this.func_77625_d(1);
        this.func_77656_e(5);
        this.func_77637_a(CreativeTabGenetics.INSTANCE);
    }

    public static ItemStack create(IGene gene) {
        return ItemSequence.create(gene, false);
    }

    public static ItemStack create(IGene gene, boolean sequenced) {
        ItemStack item = new ItemStack((Item)ModuleCore.itemSequencer);
        item.func_77964_b(sequenced ? 0 : item.func_77958_k());
        SequencerItem seq = new SequencerItem(gene);
        seq.writeToItem(item);
        return item;
    }

    public String func_77653_i(ItemStack itemstack) {
        GeneItem gene = GeneItem.create(itemstack);
        if (gene == null) {
            return I18N.localise("genetics.item.sequence.corrupted.name");
        }
        return gene.getBreedingSystem().getDescriptor() + ' ' + I18N.localise("genetics.item.sequence.name");
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.add(I18N.localise("genetics.item.sequence." + (5 - itemStack.func_77952_i() % 6)));
        SequencerItem gene = SequencerItem.create(itemStack);
        if (gene != null) {
            if (gene.isAnalysed()) {
                gene.getInfo(tooltip);
            } else {
                tooltip.add('<' + I18N.localise(ModId.GENETICS, "item.sequence.unknown", new Object[0]) + '>');
            }
            int seq = gene.getSequenced();
            if (seq == 0) {
                tooltip.add(I18N.localise(ModId.GENETICS, "item.sequence.unsequenced", new Object[0]));
            } else if (seq < 100) {
                tooltip.add(I18N.localise(ModId.GENETICS, "item.sequence.partially", I18N.getPercentFormat().format((double)seq / 100.0)));
            } else {
                tooltip.add(I18N.localise(ModId.GENETICS, "item.sequence.sequenced", new Object[0]));
            }
        }
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            if (ForestryAPI.moduleManager.isModuleEnabled("forestry", "apiculture")) {
                IAlleleBeeSpecies species = (IAlleleBeeSpecies)AlleleManager.alleleRegistry.getAllele("forestry.speciesMeadows");
                Preconditions.checkNotNull((Object)species);
                items.add((Object)ItemSequence.create(new Gene((IAllele)species, (IChromosomeType)EnumBeeChromosome.SPECIES, (ISpeciesRoot)BeeManager.beeRoot), false));
            } else if (ForestryAPI.moduleManager.isModuleEnabled("forestry", "arboriculture")) {
                IAlleleTreeSpecies species = (IAlleleTreeSpecies)AlleleManager.alleleRegistry.getAllele("forestry.treeOak");
                Preconditions.checkNotNull((Object)species);
                items.add((Object)ItemSequence.create(new Gene((IAllele)species, (IChromosomeType)EnumTreeChromosome.SPECIES, (ISpeciesRoot)TreeManager.treeRoot), false));
            } else if (ForestryAPI.moduleManager.isModuleEnabled("forestry", "lepidopterology")) {
                IAlleleButterflySpecies species = (IAlleleButterflySpecies)AlleleManager.alleleRegistry.getAllele("forestry.lepiAurora");
                Preconditions.checkNotNull((Object)species);
                items.add((Object)ItemSequence.create(new Gene((IAllele)species, (IChromosomeType)EnumButterflyChromosome.SPECIES, (ISpeciesRoot)ButterflyManager.butterflyRoot), false));
            }
        }
    }

    @Override
    public boolean isAnalysed(ItemStack stack) {
        SequencerItem seq = SequencerItem.create(stack);
        return seq != null && seq.isAnalysed();
    }

    @Override
    public ItemStack analyse(ItemStack stack) {
        SequencerItem seq = SequencerItem.create(stack);
        if (seq == null) {
            return stack;
        }
        seq.setAnalysed(true);
        seq.writeToItem(stack);
        return stack;
    }

    @Override
    public float getAnalyseTimeMult(ItemStack stack) {
        return 1.0f;
    }

    @Override
    public int getCharges(ItemStack stack) {
        return stack.func_77958_k() - stack.func_77952_i();
    }

    @Override
    public int getMaxCharges(ItemStack stack) {
        return stack.func_77958_k();
    }

    @Override
    public ISpeciesRoot getSpeciesRoot(ItemStack stack) {
        SequencerItem seq = SequencerItem.create(stack);
        if (seq == null) {
            return null;
        }
        return seq.getSpeciesRoot();
    }
}

