/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.liquid;

import binnie.core.Mods;
import binnie.core.liquid.ItemFluidContainer;
import binnie.core.util.I18N;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;

public enum FluidContainerType {
    CAPSULE,
    REFRACTORY,
    CAN,
    GLASS,
    CYLINDER;

    @Nullable
    private ItemFluidContainer item;

    public static FluidContainerType[] getBinnieContainers() {
        return new FluidContainerType[]{GLASS, CYLINDER};
    }

    public int getMaxStackSize() {
        return 16;
    }

    public String getName() {
        return this.name().toLowerCase();
    }

    public String getDisplayName() {
        return I18N.localise("binniecore.item.container." + this.name().toLowerCase());
    }

    public void setItem(ItemFluidContainer item) {
        this.item = item;
    }

    public ItemStack get(int amount) {
        if (this.item == null) {
            throw new IllegalArgumentException("Null container item: " + (Object)((Object)this));
        }
        return new ItemStack((Item)this.item, amount);
    }

    public ItemStack getEmpty() {
        switch (this) {
            case CAN: {
                return Mods.Forestry.stack("can");
            }
            case CAPSULE: {
                return Mods.Forestry.stack("capsule");
            }
            case CYLINDER: 
            case GLASS: {
                if (this.item != null) {
                    return new ItemStack((Item)this.item);
                }
                throw new IllegalArgumentException("Null container item: " + (Object)((Object)this));
            }
            case REFRACTORY: {
                return Mods.Forestry.stack("refractory");
            }
        }
        throw new IllegalArgumentException("Unknown container: " + (Object)((Object)this));
    }

    public ItemStack getFilled(Fluid fluid) {
        int fill;
        ItemStack stack = this.getEmpty();
        IFluidHandlerItem fluidHandler = FluidUtil.getFluidHandler((ItemStack)(stack = stack.func_77946_l()));
        if (fluidHandler != null && (fill = fluidHandler.fill(new FluidStack(fluid, Integer.MAX_VALUE), true)) > 0) {
            return stack;
        }
        throw new IllegalStateException("Could not fill fluid handler for container: " + (Object)((Object)this));
    }
}

