/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.liquid;

import binnie.core.liquid.FluidType;
import forestry.api.core.IItemModelRegister;
import forestry.api.core.IModelManager;
import java.awt.Color;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.BlockFluidClassic;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockBinnieFluid
extends BlockFluidClassic
implements IItemModelRegister {
    private final boolean flammable;
    private final int flammability;
    private final Color color;

    public BlockBinnieFluid(FluidType binnieFluid) {
        this(binnieFluid, 0, false);
    }

    public BlockBinnieFluid(FluidType binnieFluid, int flammability, boolean flammable) {
        this(binnieFluid.getFluid(), flammability, flammable, binnieFluid.getParticleColor());
    }

    private BlockBinnieFluid(Fluid fluid, int flammability, boolean flammable, Color color) {
        super(fluid, Material.field_151586_h);
        this.setDensity(fluid.getDensity());
        this.flammability = flammability;
        this.flammable = flammable;
        this.color = color;
    }

    @SideOnly(value=Side.CLIENT)
    public void registerModel(Item item, IModelManager manager) {
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        Material material;
        double d0 = pos.func_177958_n();
        double d1 = pos.func_177956_o();
        double d2 = pos.func_177952_p();
        if (this.field_149764_J == Material.field_151586_h) {
            int i = (Integer)stateIn.func_177229_b((IProperty)LEVEL);
            if (i > 0 && i < 8) {
                if (rand.nextInt(64) == 0) {
                    worldIn.func_184134_a(d0 + 0.5, d1 + 0.5, d2 + 0.5, SoundEvents.field_187917_gq, SoundCategory.BLOCKS, rand.nextFloat() * 0.25f + 0.75f, rand.nextFloat() + 0.5f, false);
                }
            } else if (rand.nextInt(10) == 0) {
                worldIn.func_175688_a(EnumParticleTypes.SUSPENDED, d0 + (double)rand.nextFloat(), d1 + (double)rand.nextFloat(), d2 + (double)rand.nextFloat(), 0.0, 0.0, 0.0, new int[0]);
            }
        }
        if (this.field_149764_J == Material.field_151587_i && worldIn.func_180495_p(pos.func_177984_a()).func_185904_a() == Material.field_151579_a && !worldIn.func_180495_p(pos.func_177984_a()).func_185914_p()) {
            if (rand.nextInt(100) == 0) {
                double d8 = d0 + (double)rand.nextFloat();
                double d4 = d1 + stateIn.func_185900_c((IBlockAccess)worldIn, (BlockPos)pos).field_72337_e;
                double d6 = d2 + (double)rand.nextFloat();
                worldIn.func_175688_a(EnumParticleTypes.LAVA, d8, d4, d6, 0.0, 0.0, 0.0, new int[0]);
                worldIn.func_184134_a(d8, d4, d6, SoundEvents.field_187662_cZ, SoundCategory.BLOCKS, 0.2f + rand.nextFloat() * 0.2f, 0.9f + rand.nextFloat() * 0.15f, false);
            }
            if (rand.nextInt(200) == 0) {
                worldIn.func_184134_a(d0, d1, d2, SoundEvents.field_187656_cX, SoundCategory.BLOCKS, 0.2f + rand.nextFloat() * 0.2f, 0.9f + rand.nextFloat() * 0.15f, false);
            }
        }
        if (rand.nextInt(10) == 0 && worldIn.func_180495_p(pos.func_177977_b()).func_185896_q() && !(material = worldIn.func_180495_p(pos.func_177979_c(2)).func_185904_a()).func_76230_c() && !material.func_76224_d()) {
            double d3 = d0 + (double)rand.nextFloat();
            double d5 = d1 - 1.05;
            double d7 = d2 + (double)rand.nextFloat();
            if (this.field_149764_J == Material.field_151586_h) {
                worldIn.func_175688_a(EnumParticleTypes.DRIP_WATER, d3, d5, d7, 0.0, 0.0, 0.0, new int[0]);
            } else {
                worldIn.func_175688_a(EnumParticleTypes.DRIP_LAVA, d3, d5, d7, 0.0, 0.0, 0.0, new int[0]);
            }
        }
    }

    public boolean canDisplace(IBlockAccess world, BlockPos pos) {
        IBlockState blockState = world.func_180495_p(pos);
        return !blockState.func_185904_a().func_76224_d() && super.canDisplace(world, pos);
    }

    public boolean displaceIfPossible(World world, BlockPos pos) {
        IBlockState blockState = world.func_180495_p(pos);
        return !blockState.func_185904_a().func_76224_d() && super.displaceIfPossible(world, pos);
    }

    public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return this.flammable ? 30 : 0;
    }

    public int getFlammability(IBlockAccess world, BlockPos pos, @Nullable EnumFacing face) {
        return this.flammability;
    }

    private static boolean isFlammable(IBlockAccess world, BlockPos pos) {
        IBlockState blockState = world.func_180495_p(pos);
        Block block = blockState.func_177230_c();
        return block.isFlammable(world, pos, EnumFacing.UP);
    }

    public boolean isFlammable(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return this.flammable;
    }

    public boolean isFireSource(World world, BlockPos pos, EnumFacing side) {
        return this.flammable && this.flammability == 0;
    }

    public Color getColor() {
        return this.color;
    }

    public Material func_149688_o(IBlockState state) {
        if (this.temperature > 505) {
            return Material.field_151587_i;
        }
        return super.func_149688_o(state);
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        float explosionSize;
        int flammability;
        super.func_180650_b(world, pos, state, rand);
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        if (this.func_149688_o(state) == Material.field_151587_i) {
            int rangeUp = rand.nextInt(3);
            for (int i = 0; i < rangeUp; ++i) {
                IBlockState blockState = world.func_180495_p(new BlockPos(x += rand.nextInt(3) - 1, ++y, z += rand.nextInt(3) - 1));
                if (blockState.func_185904_a() == Material.field_151579_a) {
                    if (!BlockBinnieFluid.isNeighborFlammable(world, x, y, z)) continue;
                    world.func_175656_a(new BlockPos(x, y, z), Blocks.field_150480_ab.func_176223_P());
                    return;
                }
                if (!blockState.func_185904_a().func_76230_c()) continue;
                return;
            }
            if (rangeUp == 0) {
                int startX = x;
                int startZ = z;
                for (int i = 0; i < 3; ++i) {
                    x = startX + rand.nextInt(3) - 1;
                    z = startZ + rand.nextInt(3) - 1;
                    BlockPos posAbove = new BlockPos(pos.func_177958_n(), y + 1, z);
                    if (!world.func_175623_d(posAbove) || !BlockBinnieFluid.isFlammable((IBlockAccess)world, new BlockPos(x, y, z))) continue;
                    world.func_175656_a(posAbove, Blocks.field_150480_ab.func_176223_P());
                }
            }
        }
        if ((flammability = this.getFlammability((IBlockAccess)world, pos, null)) > 0 && (double)(explosionSize = 4.0f * (float)flammability / 300.0f) > 1.0 && BlockBinnieFluid.isNearFire(world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p())) {
            world.func_175656_a(pos, Blocks.field_150480_ab.func_176223_P());
            world.func_72885_a(null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), explosionSize, true, true);
        }
    }

    private static boolean isNeighborFlammable(World world, int x, int y, int z) {
        return BlockBinnieFluid.isFlammable((IBlockAccess)world, new BlockPos(x - 1, y, z)) || BlockBinnieFluid.isFlammable((IBlockAccess)world, new BlockPos(x + 1, y, z)) || BlockBinnieFluid.isFlammable((IBlockAccess)world, new BlockPos(x, y, z - 1)) || BlockBinnieFluid.isFlammable((IBlockAccess)world, new BlockPos(x, y, z + 1)) || BlockBinnieFluid.isFlammable((IBlockAccess)world, new BlockPos(x, y - 1, z)) || BlockBinnieFluid.isFlammable((IBlockAccess)world, new BlockPos(x, y + 1, z));
    }

    private static boolean isNearFire(World world, int x, int y, int z) {
        AxisAlignedBB boundingBox = new AxisAlignedBB((double)(x - 1), (double)(y - 1), (double)(z - 1), (double)(x + 1), (double)(y + 1), (double)(z + 1));
        return world.func_147470_e(boundingBox);
    }
}

