/*
 * Decompiled with CFR 0.152.
 */
package p455w0rdslib;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.LogManager;
import org.lwjgl.opengl.ARBShaderObjects;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GLContext;
import p455w0rdslib.LibGlobals;
import p455w0rdslib.asm.ClassTransformer;
import p455w0rdslib.util.ShaderUtils;

@SideOnly(value=Side.CLIENT)
public class LibShaders {
    private static ShaderUtils.Shader activeShader = ShaderUtils.Shader.NONE;
    public static ShaderUtils.Shader coloredLightShader = ShaderUtils.Shader.NONE;
    private static boolean shaderCheck = false;
    private static boolean shadersEnabled = false;
    public static final String LIGHTOVERLAY_SRC_FRAG = LibShaders.getLightOverlaySrc(ShaderUtils.ShaderType.FRAGMENT);
    public static final String LIGHTOVERLAY_SRC_VERT = LibShaders.getLightOverlaySrc(ShaderUtils.ShaderType.VERTEX);

    public static boolean areShadersEnabled() {
        if (!shaderCheck && Minecraft.func_71410_x().func_152345_ab()) {
            shaderCheck = true;
            shadersEnabled = GLContext.getCapabilities().OpenGL20;
            if (!ClassTransformer.enabled || !LibGlobals.ConfigOptions.ENABLE_SHADERS) {
                shadersEnabled = false;
            }
        }
        return shadersEnabled;
    }

    public static ShaderUtils.Shader getActiveShader() {
        return activeShader;
    }

    public static void setActiveShader(ShaderUtils.Shader shader) {
        activeShader = shader;
    }

    public static void registerReloadListener() {
        if (!LibShaders.areShadersEnabled()) {
            return;
        }
        ((IReloadableResourceManager)Minecraft.func_71410_x().func_110442_L()).func_110542_a(irm -> LibShaders.reload());
    }

    public static void reload() {
        if (coloredLightShader != null) {
            coloredLightShader.delete();
            coloredLightShader = null;
        }
        coloredLightShader = new ShaderUtils.Shader(LibShaders.createProgram(LibShaders.getLightOverlaySrc(ShaderUtils.ShaderType.VERTEX), LibShaders.getLightOverlaySrc(ShaderUtils.ShaderType.FRAGMENT)));
        coloredLightShader.use();
        coloredLightShader.refreshUniforms();
        ShaderUtils.Shader.NONE.use();
    }

    public static int createProgram(String vsh, String fsh) {
        int p = OpenGlHelper.func_153183_d();
        OpenGlHelper.func_153178_b((int)p, (int)LibShaders.genShader(vsh, ShaderUtils.ShaderType.VERTEX));
        OpenGlHelper.func_153178_b((int)p, (int)LibShaders.genShader(fsh, ShaderUtils.ShaderType.FRAGMENT));
        OpenGlHelper.func_153179_f((int)p);
        if (GL20.glGetProgrami((int)p, (int)35714) == 0) {
            shadersEnabled = false;
        }
        return p;
    }

    public static int genShader(String source, ShaderUtils.ShaderType type) {
        int id = OpenGlHelper.func_153195_b((int)type.getId());
        if (id == 0) {
            return 0;
        }
        ARBShaderObjects.glShaderSourceARB((int)id, (CharSequence)source);
        OpenGlHelper.func_153170_c((int)id);
        if (GL20.glGetShaderi((int)id, (int)35713) == 0) {
            activeShader = ShaderUtils.Shader.NONE;
            LibGlobals.ConfigOptions.ENABLE_SHADERS = false;
            LibGlobals.ConfigOptions.ENABLE_VANILLA_LIGHT_EFFECTS = false;
            LogManager.getLogger((String)"p455w0rdslib").info("Error creating shader: " + ARBShaderObjects.glGetInfoLogARB((int)id, (int)ARBShaderObjects.glGetObjectParameteriARB((int)id, (int)35716)));
            LogManager.getLogger((String)"p455w0rdslib").info("Shaders disabled");
        }
        return id;
    }

    public static String getLightOverlaySrc(ShaderUtils.ShaderType type) {
        switch (type) {
            case FRAGMENT: {
                return "#version 120\n" + "varying vec3 position;\n" + "varying float magnitude;\n" + "varying vec4 lightColor;\n" + "uniform int chunkX;\n" + "uniform int chunkZ;\n" + "uniform sampler2D base;\n" + "uniform sampler2D lightmap;\n" + "vec3 normlize(vec3 vec) {\n" + "\tfloat length = sqrt((vec.x*vec.x) + (vec.y*vec.y) + (vec.z*vec.z));\n" + "\tif (length==0) return vec;\n" + "\treturn vec3(vec.x/length, vec.y/length, vec.z/length)+vec3(0.5,0.5,0.5);\n" + "}\n" + "void main() {\n" + "   gl_FragColor = clamp((gl_Color * texture2D(base, gl_TexCoord[0].st)) * vec4(vec3(mix(clamp(texture2D(lightmap, gl_TexCoord[1].st).xyz, 0.0f, 1.0f).xyz, normlize(lightColor.xyz), magnitude)),1), 0.0f, 1.0f);\n" + "}\n";
            }
            case VERTEX: {
                return "#version 120\n" + "varying vec3 position;\n" + "varying vec4 lightColor;\n" + "varying float magnitude;\n" + "struct Light {\n" + "vec4 color;\n" + "vec3 position;\n" + "vec3 rad;\n" + "float intensity;\n" + "};\n" + "uniform int chunkX;\n" + "uniform int chunkY;\n" + "uniform int chunkZ;\n" + "uniform sampler2D base;\n" + "uniform sampler2D lightmap;\n" + "uniform Light lights[100];\n" + "uniform int lightCount;\n" + "uniform int maxLights;\n" + "void main() {\n" + "vec4 pos = gl_ModelViewProjectionMatrix * gl_Vertex;\n" + "position = gl_Vertex.xyz+vec3(chunkX,chunkY,chunkZ);\n" + "float offset = 0;\n" + "gl_TexCoord[0] = gl_TextureMatrix[0] * gl_MultiTexCoord0;\n" + "gl_TexCoord[1] = gl_TextureMatrix[1] * gl_MultiTexCoord1;\n" + "gl_Position = gl_ModelViewProjectionMatrix * gl_Vertex;\n" + "gl_FrontColor = gl_Color;\n" + "float finalR = 0;\n" + "float finalG = 0;\n" + "float finalB = 0;\n" + "float finalIntensity = 0;\n" + "for (int i = 0; i < lightCount; i ++) {\n" + "float dist = distance(lights[i].position, position);\n" + "float radius = length(lights[i].rad);\n" + "if (dist <= radius) {\n" + "float falloff = 1-clamp(dist/radius, 0.0f, 1.0f);\n" + "float intensity = falloff * lights[i].color.w * lights[i].intensity;\n" + "finalIntensity += intensity;\n" + "vec3 normalLight = lights[i].color.xyz;\n" + "finalR += normalLight.x;\n" + "finalG += normalLight.y;\n" + "finalB += normalLight.z;\n" + "}\n" + "}\n" + "magnitude = finalIntensity;\n" + "lightColor = vec4(finalR, finalG, finalB, 1);\n" + "}\n";
            }
        }
        return "";
    }
}

