/*
 * Decompiled with CFR 0.152.
 */
package rustic.client.gui.book;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;
import rustic.common.book.BookEntry;
import rustic.common.book.BookEntryCategory;
import rustic.common.book.BookManager;
import rustic.common.book.BookPage;

@SideOnly(value=Side.CLIENT)
public class GuiBook
extends GuiScreen {
    public static final int WIDTH = 146;
    public static final int HEIGHT = 180;
    public static final ResourceLocation BOOK_BACKGROUND = new ResourceLocation("rustic", "textures/gui/book/book.png");
    public int guiLeft;
    public int guiTop;
    private BookEntry currentEntry = null;
    private BookEntry prevEntry = null;
    private int currentPageNum = 0;
    private int prevPageNum = 0;
    private BookPage currentPage = null;
    private BookLocation backLocation = null;
    private List<BookLocation> history = new ArrayList<BookLocation>();

    public void func_73866_w_() {
        this.guiTop = (this.field_146295_m - 180) / 2;
        this.guiLeft = (this.field_146294_l - 146) / 2;
        if (this.currentEntry == null || this.currentPage == null) {
            this.currentEntry = BookManager.categories_entry;
            this.currentPage = this.currentEntry.getPages().get(this.currentPageNum);
            this.pageOpened();
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        this.drawBackgroundLayer(partialTicks, mouseX, mouseY);
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.currentPage.drawScreen(this, mouseX, mouseY, partialTicks);
    }

    protected void drawBackgroundLayer(float partialTicks, int mouseX, int mouseY) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(BOOK_BACKGROUND);
        this.func_73729_b(this.guiLeft, this.guiTop, 0, 0, 146, 180);
    }

    public void func_73876_c() {
        this.prevEntry = this.currentEntry;
        this.prevPageNum = this.currentPageNum;
        if (!this.field_146297_k.field_71439_g.func_70089_S() || this.field_146297_k.field_71439_g.field_70128_L) {
            this.field_146297_k.field_71439_g.func_71053_j();
        }
        this.currentPage.update();
    }

    public void goToPage(int pageNum) {
        if (pageNum >= 0 && this.currentEntry.getPages().size() > pageNum && this.prevPageNum == this.currentPageNum) {
            this.currentPage.onClosed(this);
            this.currentPageNum = pageNum;
            this.currentPage = this.currentEntry.getPages().get(this.currentPageNum);
            this.pageOpened();
        }
    }

    public void goToEntry(BookEntry entry) {
        if (entry != null && entry.getPages().size() > 0 && this.prevEntry == this.currentEntry) {
            if (this.currentEntry instanceof BookEntryCategory && !(entry instanceof BookEntryCategory) && entry != BookManager.categories_entry) {
                this.backLocation = new BookLocation(this.currentEntry, this.currentPageNum);
            }
            if (entry instanceof BookEntryCategory || entry == BookManager.categories_entry) {
                this.backLocation = null;
            }
            if (entry instanceof BookEntryCategory || entry == BookManager.categories_entry) {
                this.history.clear();
            } else if (!(this.currentEntry instanceof BookEntryCategory) && this.currentEntry != BookManager.categories_entry) {
                this.history.add(new BookLocation(this.currentEntry, this.currentPageNum));
            }
            this.currentPage.onClosed(this);
            this.currentEntry = entry;
            this.currentPageNum = 0;
            this.currentPage = this.currentEntry.getPages().get(this.currentPageNum);
            this.pageOpened();
        }
    }

    private void goToHistoryLocation(int index) {
        if (index >= 0 && index < this.history.size() && this.prevEntry == this.currentEntry && this.prevPageNum == this.currentPageNum) {
            BookEntry entry = this.history.get(index).getEntry();
            int page = this.history.get(index).getPage();
            int i = index;
            while (i < this.history.size()) {
                this.history.remove(i);
            }
            this.currentPage.onClosed(this);
            this.currentEntry = entry;
            this.currentPageNum = page;
            this.currentPage = this.currentEntry.getPages().get(this.currentPageNum);
            this.pageOpened();
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected void func_146284_a(GuiButton button) throws IOException {
        if (button instanceof PageTurnButton) {
            if (((PageTurnButton)button).isForward()) {
                this.goToPage(this.currentPageNum + 1);
            } else {
                this.goToPage(this.currentPageNum - 1);
            }
        } else if (button instanceof BackButton) {
            if (this.currentEntry.getCategory() == null) {
                this.goToEntry(BookManager.categories_entry);
            } else if (this.backLocation != null) {
                this.backLocation.goTo(this);
            } else {
                this.goToEntry(this.currentEntry.getCategory().getCategoryEntry());
            }
        } else if (button instanceof LastHistoryButton) {
            this.goToHistoryLocation(this.history.size() - 1);
        } else {
            this.currentPage.actionPerformed(this, button);
        }
    }

    protected void func_73869_a(char c, int key) throws IOException {
        this.currentPage.keyPressed(c, key);
        if (this.field_146297_k.field_71474_y.field_151445_Q.func_151463_i() == key) {
            if (this.currentEntry == BookManager.categories_entry) {
                this.field_146297_k.func_147108_a(null);
                this.field_146297_k.func_71381_h();
            } else if (this.currentEntry.getCategory() == null) {
                this.goToEntry(BookManager.categories_entry);
            } else if (this.backLocation != null) {
                this.backLocation.goTo(this);
            } else {
                this.goToEntry(this.currentEntry.getCategory().getCategoryEntry());
            }
        } else if (1 == key) {
            this.field_146297_k.func_147108_a(null);
            this.field_146297_k.func_71381_h();
        }
    }

    public void func_146281_b() {
        this.currentPage.onClosed(this);
    }

    protected void pageOpened() {
        this.currentPage.onOpened(this);
    }

    public void addNavButtons() {
        boolean histButton;
        int numPages = this.currentEntry.getPages().size();
        if (this.currentPageNum > 0) {
            this.func_189646_b(new PageTurnButton(this.field_146292_n.size(), this.guiLeft, this.guiTop + 180 - 10, false));
        }
        if (this.currentPageNum < numPages - 1) {
            this.func_189646_b(new PageTurnButton(this.nextButtonID(), this.guiLeft + 146 - 18, this.guiTop + 180 - 10, true));
        }
        boolean backButton = this.currentEntry != BookManager.categories_entry;
        boolean bl = histButton = this.history.size() > 0 && this.currentEntry != BookManager.categories_entry;
        if (backButton) {
            this.func_189646_b(new BackButton(this.nextButtonID(), histButton ? this.guiLeft + 73 - 15 : this.guiLeft + 73 - 8, this.guiTop + 180 + 0));
        }
        if (histButton) {
            this.func_189646_b(new LastHistoryButton(this.nextButtonID(), backButton ? this.guiLeft + 73 + 15 - 10 : this.guiLeft + 73 - 5, this.guiTop + 180 - 3));
        }
    }

    public boolean func_73868_f() {
        return false;
    }

    public void func_175273_b(Minecraft mcIn, int w, int h) {
        this.func_146280_a(mcIn, w, h);
        this.currentPage.onClosed(this);
        this.pageOpened();
    }

    public FontRenderer getFontRenderer() {
        return this.field_146289_q;
    }

    public List<GuiButton> getButtonList() {
        return this.field_146292_n;
    }

    public int nextButtonID() {
        return this.field_146292_n.size();
    }

    public void drawCenteredText(String text, int x, int y, int color) {
        int cX = x - this.field_146289_q.func_78256_a(text) / 2;
        this.field_146289_q.func_78276_b(text, cX, y, color);
    }

    public void func_73730_a(int startX, int endX, int y, int color) {
        if (endX < startX) {
            int i = startX;
            startX = endX;
            endX = i;
        }
        GuiBook.func_73734_a((int)startX, (int)y, (int)(endX + 1), (int)(y + 1), (int)color);
    }

    public void func_73728_b(int x, int startY, int endY, int color) {
        if (endY < startY) {
            int i = startY;
            startY = endY;
            endY = i;
        }
        GuiBook.func_73734_a((int)x, (int)(startY + 1), (int)(x + 1), (int)endY, (int)color);
    }

    public void func_146285_a(ItemStack stack, int x, int y) {
        super.func_146285_a(stack, x, y);
    }

    private class BookLocation {
        private BookEntry entry;
        private int page;

        public BookLocation(BookEntry entry, int page) {
            this.entry = entry;
            this.page = page;
        }

        public void goTo(GuiBook gui) {
            gui.goToEntry(this.entry);
            gui.goToPage(this.page);
        }

        public BookEntry getEntry() {
            return this.entry;
        }

        public int getPage() {
            return this.page;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public class LastHistoryButton
    extends GuiButton {
        public LastHistoryButton(int buttonId, int x, int y) {
            super(buttonId, x, y, 10, 16, "book.rustic.button.last_history");
        }

        public void func_191745_a(Minecraft mc, int mouseX, int mouseY, float partialTicks) {
            if (this.field_146125_m) {
                boolean flag = mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g;
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                mc.func_110434_K().func_110577_a(BOOK_BACKGROUND);
                int i = 36;
                int j = 193;
                if (flag) {
                    i += 10;
                }
                this.func_73729_b(this.field_146128_h, this.field_146129_i, i, j, 10, 16);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public class BackButton
    extends GuiButton {
        public BackButton(int buttonId, int x, int y) {
            super(buttonId, x, y, 16, 10, "book.rustic.button.back");
        }

        public void func_191745_a(Minecraft mc, int mouseX, int mouseY, float partialTicks) {
            if (this.field_146125_m) {
                boolean flag = mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g;
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                mc.func_110434_K().func_110577_a(BOOK_BACKGROUND);
                int i = 0;
                int j = 200;
                if (flag) {
                    i += 16;
                }
                this.func_73729_b(this.field_146128_h, this.field_146129_i, i, j, 16, 10);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public class PageTurnButton
    extends GuiButton {
        private final boolean isForward;

        public PageTurnButton(int buttonId, int x, int y, boolean isForward) {
            super(buttonId, x, y, 18, 10, "book.rustic.button." + (isForward ? "next" : "prev"));
            this.isForward = isForward;
        }

        public void func_191745_a(Minecraft mc, int mouseX, int mouseY, float partialTicks) {
            if (this.field_146125_m) {
                boolean flag = mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g;
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                mc.func_110434_K().func_110577_a(BOOK_BACKGROUND);
                int i = 0;
                int j = 180;
                if (flag) {
                    i += 18;
                }
                if (!this.isForward) {
                    j += 10;
                }
                this.func_73729_b(this.field_146128_h, this.field_146129_i, i, j, 18, 10);
            }
        }

        public boolean isForward() {
            return this.isForward;
        }
    }
}

