/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.fx;

import vazkii.botania.client.fx.FXLightningBoltPoint;
import vazkii.botania.common.core.helper.Vector3;

public class FXLightningSegment {
    public final FXLightningBoltPoint startPoint;
    public final FXLightningBoltPoint endPoint;
    public Vector3 diff;
    public FXLightningSegment prev;
    public FXLightningSegment next;
    public Vector3 nextDiff;
    public Vector3 prevDiff;
    public float sinPrev;
    public float sinNext;
    public final float light;
    public final int segmentNo;
    public final int splitNo;

    public FXLightningSegment(FXLightningBoltPoint start, FXLightningBoltPoint end, float light, int segmentnumber, int splitnumber) {
        this.startPoint = start;
        this.endPoint = end;
        this.light = light;
        this.segmentNo = segmentnumber;
        this.splitNo = splitnumber;
        this.calcDiff();
    }

    public FXLightningSegment(Vector3 start, Vector3 end) {
        this(new FXLightningBoltPoint(start, new Vector3(0.0, 0.0, 0.0)), new FXLightningBoltPoint(end, new Vector3(0.0, 0.0, 0.0)), 1.0f, 0, 0);
    }

    public void calcDiff() {
        this.diff = this.endPoint.point.subtract(this.startPoint.point);
    }

    public void calcEndDiffs() {
        Vector3 thisdiffnorm;
        if (this.prev != null) {
            Vector3 prevdiffnorm = this.prev.diff.normalize();
            thisdiffnorm = this.diff.normalize();
            this.prevDiff = thisdiffnorm.add(prevdiffnorm).normalize();
            this.sinPrev = (float)Math.sin(thisdiffnorm.angle(prevdiffnorm.multiply(-1.0)) / 2.0);
        } else {
            this.prevDiff = this.diff.normalize();
            this.sinPrev = 1.0f;
        }
        if (this.next != null) {
            Vector3 nextdiffnorm = this.next.diff.normalize();
            thisdiffnorm = this.diff.normalize();
            this.nextDiff = thisdiffnorm.add(nextdiffnorm).normalize();
            this.sinNext = (float)Math.sin(thisdiffnorm.angle(nextdiffnorm.multiply(-1.0)) / 2.0);
        } else {
            this.nextDiff = this.diff.normalize();
            this.sinNext = 1.0f;
        }
    }

    public String toString() {
        return this.startPoint.point.toString() + " " + this.endPoint.point.toString();
    }
}

