/*
 * Decompiled with CFR 0.152.
 */
package mods.waterstrainer.item;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import javax.annotation.Nullable;
import mods.waterstrainer.Config;
import mods.waterstrainer.WaterStrainer;
import mods.waterstrainer.util.Loot;
import mods.waterstrainer.util.Patcher;
import mods.waterstrainer.util.WaterStrainerUtils;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemEnchantedBook;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ItemStrainer
extends Item {
    public List<StrainerType> strainer_type = new ArrayList<StrainerType>();
    private int minIndex = 0;
    private int maxIndex = 0;
    private int curTooltipIndex = 0;
    private static Random rand = new Random();
    private long updateTime = System.currentTimeMillis();
    private List<String> tooltipData = new ArrayList<String>();
    private List<Integer> sortedRarityList = new ArrayList<Integer>();
    private Map<String, List<String>> categoryTable = new HashMap<String, List<String>>();
    private Map<String, List<Loot>> lootTable = new HashMap<String, List<Loot>>();
    private Map<Integer, List<String>> lootTableSorted = new HashMap<Integer, List<String>>();

    public ItemStrainer(String name, int maxDurability) {
        this.field_77777_bU = 1;
        this.func_77656_e(maxDurability);
        this.setRegistryName(name);
        this.func_77655_b("waterstrainer." + name);
        this.func_77637_a(WaterStrainer.tabWaterStrainer);
    }

    public void initModel() {
        WaterStrainer.proxy.registerModel(this, 0, new ModelResourceLocation(this.getRegistryName(), "inventory"));
    }

    public boolean func_77616_k(ItemStack stack) {
        return this.hasType(StrainerType.REINFORCED) && Config.miscEnableEnchanting;
    }

    public int func_77619_b() {
        return ItemArmor.ArmorMaterial.IRON.func_78045_a();
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        if (!(book.func_77973_b() instanceof ItemEnchantedBook)) {
            return false;
        }
        NBTTagList taglist = ItemEnchantedBook.func_92110_g((ItemStack)book);
        for (int i = 0; i < taglist.func_74745_c(); ++i) {
            NBTTagCompound nbt = taglist.func_150305_b(i);
            Enchantment enchantment = Enchantment.func_185262_c((int)nbt.func_74765_d("id"));
            if (ItemStrainer.isValidEnchantment(enchantment)) continue;
            return false;
        }
        return true;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return ItemStrainer.isValidEnchantment(enchantment);
    }

    public static boolean isValidEnchantment(Enchantment enchantment) {
        return Config.miscEnableEnchanting && (enchantment == Enchantments.field_185307_s || enchantment == Enchantments.field_185305_q || enchantment == Enchantments.field_185308_t || enchantment == Enchantments.field_151370_z);
    }

    public static int getEnchantmentLevel(ItemStack stack, Enchantment enchantment) {
        if (Config.miscEnableEnchanting) {
            return EnchantmentHelper.func_77506_a((Enchantment)enchantment, (ItemStack)stack);
        }
        return 0;
    }

    public static boolean generateBonusItem(int level) {
        return level >= rand.nextInt(3) + 1;
    }

    public static boolean preventDamage(int level) {
        return level >= rand.nextInt(10) + 1;
    }

    public void func_77624_a(ItemStack stack, @Nullable World player, List<String> tooltip, ITooltipFlag advanced) {
        boolean shiftPressed = GuiScreen.func_146272_n();
        if (this.func_77645_m()) {
            int uses = this.func_77612_l() - this.getDamage(stack);
            if (uses <= 1) {
                tooltip.add("\u00a721 use left");
            } else {
                tooltip.add("\u00a72" + uses + " uses left");
            }
        } else {
            tooltip.add("\u00a72Does not break");
        }
        if (this.hasType(StrainerType.SOLID)) {
            if (Config.bonusSolidEfficiency > 0) {
                tooltip.add(WaterStrainerUtils.ctext(String.format("#GREEN#+%s%% Efficiency", Config.bonusSolidEfficiency)));
            }
        } else if (this.hasType(StrainerType.REINFORCED)) {
            if (Config.bonusReinforcedEfficiency > 0) {
                tooltip.add(WaterStrainerUtils.ctext(String.format("#GREEN#+%s%% Efficiency", Config.bonusReinforcedEfficiency)));
            }
            if (Config.miscEnableEnchanting) {
                tooltip.add(WaterStrainerUtils.ctext("#GREEN#+Enchantable"));
            }
        }
        if (shiftPressed || this.lootTable.size() == 0) {
            if (this.lootTable.size() > 0) {
                if (this.sortedRarityList.size() == 0) {
                    this.sortLootTable();
                }
                if (this.tooltipData.size() == 0) {
                    this.generateTooltip();
                }
                if (Math.abs(System.currentTimeMillis() - this.updateTime) > 750L) {
                    this.updateTime = System.currentTimeMillis();
                    this.generateTooltip();
                }
                if (this.tooltipData.size() > 0) {
                    for (String t : this.tooltipData) {
                        tooltip.add(t);
                    }
                }
            } else {
                tooltip.add(WaterStrainerUtils.ctext("#RED#This strainer has no valid output items and is therefore useless."));
                tooltip.add(WaterStrainerUtils.ctext("#RED#Use the configuration files to add valid items or disable it completely."));
                tooltip.add(WaterStrainerUtils.ctext("#RED#You could also delete your loottable config to restore the default one."));
            }
        } else {
            if (this.strainer_type.contains((Object)StrainerType.FISHER)) {
                tooltip.add("Catches fish, junk and treasures.");
                tooltip.add("Requires Bait.");
            } else if (this.strainer_type.contains((Object)StrainerType.SURVIVAL_DENSE)) {
                tooltip.add("Collects general small-sized items.");
            } else {
                tooltip.add("Collects general items.");
            }
            tooltip.add("Requires a Strainer Base.");
            tooltip.add("\u00a77Press \u00a76shift \u00a77for more info.");
        }
    }

    private void generateTooltip() {
        this.tooltipData.clear();
        for (int rarity : this.sortedRarityList) {
            List<String> categories = this.lootTableSorted.get(rarity);
            for (String category : categories) {
                Item getItem;
                int index;
                ItemStack randItem;
                List<Loot> lootlist;
                int size;
                if (!this.lootTable.containsKey(category) || (size = (lootlist = this.lootTable.get(category)).size()) <= 0 || Patcher.isStackEmpty(randItem = lootlist.get(index = this.curTooltipIndex % size).getDisplayStack()) || (getItem = randItem.func_77973_b()) == null) continue;
                String descrString = "" + Patcher.stackSize(randItem) + "x " + getItem.func_77653_i(randItem);
                int chance = Math.max(1, (int)(100.0f / ((float)this.maxIndex / (float)rarity)));
                if (chance < 10) {
                    this.tooltipData.add("0" + chance + "% - " + descrString);
                    continue;
                }
                this.tooltipData.add(chance + "% - " + descrString);
            }
        }
        ++this.curTooltipIndex;
        if (this.curTooltipIndex >= 1000) {
            this.curTooltipIndex = 0;
        }
    }

    public void resetLootTable() {
        this.tooltipData.clear();
        this.categoryTable.clear();
        this.lootTable.clear();
        this.lootTableSorted.clear();
        this.sortedRarityList.clear();
        this.minIndex = 0;
        this.maxIndex = 0;
    }

    public static boolean isItemValid(String itemName) {
        return Item.func_111206_d((String)itemName) != null || Objects.equals(itemName, "BLANK");
    }

    public void addItemToLootTable(String category, String itemName, String metadata, String quantity, String rarity, boolean chunkmeta) {
        if (ItemStrainer.isItemValid(itemName)) {
            if (!this.categoryTable.containsKey(category)) {
                int r = Integer.parseInt(rarity);
                this.minIndex = this.maxIndex + 1;
                this.maxIndex = this.minIndex + r - 1;
                ArrayList<String> data = new ArrayList<String>();
                data.add(Integer.toString(this.minIndex));
                data.add(Integer.toString(this.maxIndex));
                data.add(rarity);
                this.categoryTable.put(category, data);
            }
            List<Object> lootlist = new ArrayList<Loot>();
            if (this.lootTable.containsKey(category)) {
                lootlist = this.lootTable.get(category);
            }
            if (!Objects.equals(itemName, "BLANK")) {
                String[] metaList = metadata.split(",");
                if (chunkmeta) {
                    Loot loot = new Loot(category, new ItemStack(Item.func_111206_d((String)itemName), Integer.parseInt(quantity), 0));
                    for (String meta : metaList) {
                        loot.addMeta(Integer.parseInt(meta));
                    }
                    lootlist.add(loot);
                } else {
                    for (String meta : metaList) {
                        lootlist.add(new Loot(category, new ItemStack(Item.func_111206_d((String)itemName), Integer.parseInt(quantity), Integer.parseInt(meta))));
                    }
                }
            } else {
                lootlist.add(new Loot(category, Patcher.emptyStack()));
            }
            this.lootTable.put(category, lootlist);
        }
    }

    private void sortLootTable() {
        for (Map.Entry<String, List<String>> entry : this.categoryTable.entrySet()) {
            List<Object> data;
            String category = entry.getKey();
            int rarity = Integer.parseInt(entry.getValue().get(2));
            if (this.lootTableSorted.containsKey(rarity)) {
                data = this.lootTableSorted.get(rarity);
                data.add(category);
                this.lootTableSorted.put(rarity, data);
                continue;
            }
            data = new ArrayList<String>();
            data.add(category);
            this.lootTableSorted.put(rarity, data);
            this.sortedRarityList.add(rarity);
        }
        Collections.sort(this.sortedRarityList);
        Collections.reverse(this.sortedRarityList);
    }

    public ItemStack generateRandomItemStack(World world, BlockPos pos, ItemStack strainer) {
        List<Loot> lootlist;
        if (this.maxIndex < 1) {
            return Patcher.emptyStack();
        }
        boolean cancel = false;
        int bestrarity = -1;
        Map.Entry<String, List<String>> bestentry = null;
        for (int i = 0; i < ItemStrainer.getEnchantmentLevel(strainer, Enchantments.field_151370_z) + 1; ++i) {
            int randIndex = rand.nextInt(this.maxIndex - 1 + 1) + 1;
            for (Map.Entry<String, List<String>> entry : this.categoryTable.entrySet()) {
                int minIndex = Integer.parseInt(entry.getValue().get(0));
                int maxIndex = Integer.parseInt(entry.getValue().get(1));
                int rarity = Integer.parseInt(entry.getValue().get(2));
                if (randIndex < minIndex || randIndex > maxIndex) continue;
                if (bestrarity != -1 && rarity >= bestrarity) break;
                if (bestrarity != -1) {
                    cancel = true;
                }
                bestrarity = rarity;
                bestentry = entry;
                break;
            }
            if (cancel) break;
        }
        if ((lootlist = this.lootTable.get(bestentry.getKey())) != null && lootlist.size() > 0) {
            Loot loot = lootlist.get(rand.nextInt(lootlist.size()));
            ItemStack randItem = loot.getStack();
            if (loot.hasChunkMeta() && world != null && pos != null) {
                int chunkIndex = WaterStrainerUtils.generateIntForChunk(world, pos, loot.getChunkMetaSize());
                randItem.func_77964_b(loot.getChunkMetaWithIndex(chunkIndex));
            }
            if (!Patcher.isStackEmpty(randItem) && randItem.func_77973_b() != null) {
                if (randItem.func_77973_b() == Items.field_151134_bR) {
                    randItem = Patcher.emptyStack();
                    randItem = EnchantmentHelper.func_77504_a((Random)rand, (ItemStack)new ItemStack(Items.field_151122_aG), (int)(rand.nextInt(30) + 1), (boolean)true);
                    if (!Patcher.isStackEmpty(randItem) && randItem.func_77973_b() != null) {
                        return randItem;
                    }
                }
                if (randItem.func_77984_f()) {
                    randItem.func_77964_b(rand.nextInt(randItem.func_77958_k()));
                }
                if (!Patcher.isStackEmpty(randItem) && randItem.func_77973_b() != null) {
                    return new ItemStack(randItem.func_77973_b(), Patcher.stackSize(randItem), randItem.func_77960_j());
                }
            }
        }
        return Patcher.emptyStack();
    }

    public List<ItemStack> getLootTableNoBlanks() {
        ArrayList<ItemStack> loottable = new ArrayList<ItemStack>();
        for (Map.Entry<String, List<Loot>> entry : this.lootTable.entrySet()) {
            for (Loot loot : entry.getValue()) {
                ItemStack stack = loot.getStack();
                if (Patcher.isStackEmpty(stack)) continue;
                if (loot.hasChunkMeta()) {
                    for (int meta : loot.getChunkMeta()) {
                        loottable.add(new ItemStack(stack.func_77973_b(), 1, meta));
                    }
                    continue;
                }
                loottable.add(stack);
            }
        }
        return loottable;
    }

    public int getEfficiencyBonus() {
        int efficiency = 0;
        if (this.hasType(StrainerType.SOLID) && Config.bonusSolidEfficiency > 0) {
            efficiency += Config.bonusSolidEfficiency;
        }
        if (this.hasType(StrainerType.REINFORCED) && Config.bonusReinforcedEfficiency > 0) {
            efficiency += Config.bonusReinforcedEfficiency;
        }
        return efficiency;
    }

    public boolean hasType(StrainerType type) {
        return this.strainer_type.contains((Object)type);
    }

    public static enum StrainerType {
        SURVIVAL,
        SURVIVAL_DENSE,
        SOLID,
        REINFORCED,
        FISHER;

    }
}

