/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.config;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import io.netty.buffer.ByteBuf;
import mcjty.rftoolsdim.api.dimlet.ISettingsBuilder;
import mcjty.rftoolsdim.varia.JSonTools;

public class Settings {
    private final Integer rarity;
    private final Integer createCost;
    private final Integer maintainCost;
    private final Integer tickCost;
    private final Boolean worldgen;
    private final Boolean dimlet;

    private Settings(Builder builder) {
        this.rarity = builder.rarity;
        this.createCost = builder.createCost;
        this.maintainCost = builder.maintainCost;
        this.tickCost = builder.tickCost;
        this.worldgen = builder.worldgen;
        this.dimlet = builder.dimlet;
    }

    public void toBytes(ByteBuf buf) {
        if (this.rarity == null) {
            buf.writeByte(127);
        } else {
            buf.writeByte(this.rarity.intValue());
        }
        if (this.createCost == null) {
            buf.writeBoolean(false);
        } else {
            buf.writeBoolean(true);
            buf.writeInt(this.createCost.intValue());
        }
        if (this.maintainCost == null) {
            buf.writeBoolean(false);
        } else {
            buf.writeBoolean(true);
            buf.writeInt(this.maintainCost.intValue());
        }
        if (this.tickCost == null) {
            buf.writeBoolean(false);
        } else {
            buf.writeBoolean(true);
            buf.writeInt(this.tickCost.intValue());
        }
        if (this.worldgen == null) {
            buf.writeByte(127);
        } else {
            buf.writeByte(this.worldgen != false ? 1 : 0);
        }
        if (this.dimlet == null) {
            buf.writeByte(127);
        } else {
            buf.writeByte(this.dimlet != false ? 1 : 0);
        }
    }

    public Settings(ByteBuf buf) {
        byte b = buf.readByte();
        this.rarity = b == 127 ? null : Integer.valueOf(b);
        this.createCost = buf.readBoolean() ? Integer.valueOf(buf.readInt()) : null;
        this.maintainCost = buf.readBoolean() ? Integer.valueOf(buf.readInt()) : null;
        this.tickCost = buf.readBoolean() ? Integer.valueOf(buf.readInt()) : null;
        b = buf.readByte();
        this.worldgen = b == 127 ? null : Boolean.valueOf(b == 1);
        b = buf.readByte();
        this.dimlet = b == 127 ? null : Boolean.valueOf(b == 1);
    }

    public boolean isBlacklisted() {
        return this.worldgen == false && this.dimlet == false;
    }

    public boolean isComplete() {
        return this.rarity != null && this.createCost != null && this.maintainCost != null && this.tickCost != null && this.worldgen != null && this.dimlet != null;
    }

    public String toString() {
        return "Settings{ R:" + this.rarity + ", cost:" + this.createCost + "/" + this.maintainCost + "/" + this.tickCost + ", W:" + this.worldgen + ", D:" + this.dimlet + " }";
    }

    public JsonElement buildElement() {
        JsonObject jsonObject = new JsonObject();
        if (this.rarity != null) {
            jsonObject.add("rarity", (JsonElement)new JsonPrimitive((Number)this.rarity));
        }
        if (this.createCost != null) {
            jsonObject.add("create", (JsonElement)new JsonPrimitive((Number)this.createCost));
        }
        if (this.maintainCost != null) {
            jsonObject.add("maintain", (JsonElement)new JsonPrimitive((Number)this.maintainCost));
        }
        if (this.tickCost != null) {
            jsonObject.add("ticks", (JsonElement)new JsonPrimitive((Number)this.tickCost));
        }
        if (this.worldgen != null) {
            jsonObject.add("worldgen", (JsonElement)new JsonPrimitive(this.worldgen));
        }
        if (this.dimlet != null) {
            jsonObject.add("dimlet", (JsonElement)new JsonPrimitive(this.dimlet));
        }
        return jsonObject;
    }

    public static Settings parse(JsonElement element) {
        Builder builder = new Builder();
        JsonObject jsonObject = element.getAsJsonObject();
        JSonTools.getElement(jsonObject, "rarity").ifPresent(e -> builder.rarity(e.getAsInt()));
        JSonTools.getElement(jsonObject, "create").ifPresent(e -> builder.createCost(e.getAsInt()));
        JSonTools.getElement(jsonObject, "maintain").ifPresent(e -> builder.maintainCost(e.getAsInt()));
        JSonTools.getElement(jsonObject, "ticks").ifPresent(e -> builder.tickCost(e.getAsInt()));
        JSonTools.getElement(jsonObject, "worldgen").ifPresent(e -> builder.worldgen(e.getAsBoolean()));
        JSonTools.getElement(jsonObject, "dimlet").ifPresent(e -> builder.dimlet(e.getAsBoolean()));
        return builder.build();
    }

    public Integer getCreateCost() {
        return this.createCost;
    }

    public boolean isDimlet() {
        return this.dimlet == null ? false : this.dimlet;
    }

    public Integer getMaintainCost() {
        return this.maintainCost;
    }

    public Integer getRarity() {
        return this.rarity;
    }

    public Integer getTickCost() {
        return this.tickCost;
    }

    public boolean isWorldgen() {
        return this.worldgen == null ? false : this.worldgen;
    }

    public static class Builder
    implements ISettingsBuilder {
        private Integer rarity;
        private Integer createCost;
        private Integer maintainCost;
        private Integer tickCost;
        private Boolean worldgen;
        private Boolean dimlet;

        public Builder merge(Settings settings) {
            if (this.rarity == null) {
                this.rarity = settings.rarity;
            }
            if (this.createCost == null) {
                this.createCost = settings.createCost;
            }
            if (this.maintainCost == null) {
                this.maintainCost = settings.maintainCost;
            }
            if (this.tickCost == null) {
                this.tickCost = settings.tickCost;
            }
            if (this.worldgen == null) {
                this.worldgen = settings.worldgen;
            }
            if (this.dimlet == null) {
                this.dimlet = settings.dimlet;
            }
            return this;
        }

        public Builder complete() {
            if (this.rarity == null) {
                this.rarity = 0;
            }
            if (this.createCost == null) {
                this.createCost = 1;
            }
            if (this.maintainCost == null) {
                this.maintainCost = 1;
            }
            if (this.tickCost == null) {
                this.tickCost = 1;
            }
            if (this.worldgen == null) {
                this.worldgen = false;
            }
            if (this.dimlet == null) {
                this.dimlet = false;
            }
            return this;
        }

        @Override
        public Builder rarity(int rarity) {
            this.rarity = rarity;
            return this;
        }

        @Override
        public Builder createCost(int createCost) {
            this.createCost = createCost;
            return this;
        }

        @Override
        public Builder maintainCost(int maintainCost) {
            this.maintainCost = maintainCost;
            return this;
        }

        @Override
        public Builder tickCost(int tickCost) {
            this.tickCost = tickCost;
            return this;
        }

        @Override
        public Builder worldgen(boolean worldgen) {
            this.worldgen = worldgen;
            return this;
        }

        @Override
        public Builder dimlet(boolean dimlet) {
            this.dimlet = dimlet;
            return this;
        }

        public Settings build() {
            return new Settings(this);
        }
    }
}

