/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.utils;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.client.CustomFontColor;
import slimeknights.tconstruct.library.materials.BowMaterialStats;
import slimeknights.tconstruct.library.materials.FletchingMaterialStats;
import slimeknights.tconstruct.library.materials.HeadMaterialStats;
import slimeknights.tconstruct.library.modifiers.IModifier;
import slimeknights.tconstruct.library.modifiers.ModifierNBT;
import slimeknights.tconstruct.library.tools.ProjectileLauncherNBT;
import slimeknights.tconstruct.library.tools.ProjectileNBT;
import slimeknights.tconstruct.library.tools.ranged.BowCore;
import slimeknights.tconstruct.library.tools.ranged.IAmmo;
import slimeknights.tconstruct.library.utils.TagUtil;
import slimeknights.tconstruct.library.utils.ToolHelper;

public class TooltipBuilder {
    public static final String LOC_FreeModifiers = "tooltip.tool.modifiers";
    public static final String LOC_Ammo = "stat.projectile.ammo.name";
    public static final String LOC_Broken = "tooltip.tool.broken";
    public static final String LOC_Empty = "tooltip.tool.empty";
    private final List<String> tips = Lists.newLinkedList();
    private final ItemStack stack;

    public TooltipBuilder(ItemStack stack) {
        this.stack = stack;
    }

    public List<String> getTooltip() {
        return this.tips;
    }

    public TooltipBuilder add(String text) {
        this.tips.add(text);
        return this;
    }

    public static String formatAmmo(int durability, int ref) {
        return String.format("%s: %s%s%s/%s%s", Util.translate(LOC_Ammo, new Object[0]), CustomFontColor.valueToColorCode((float)durability / (float)ref), Util.df.format(durability), TextFormatting.GRAY.toString(), HeadMaterialStats.COLOR_Durability, Util.df.format(ref)) + TextFormatting.RESET;
    }

    public TooltipBuilder addDurability(boolean textIfBroken) {
        if (ToolHelper.isBroken(this.stack) && textIfBroken) {
            this.tips.add(String.format("%s: %s%s%s", Util.translate("stat.head.durability.name", new Object[0]), TextFormatting.DARK_RED, TextFormatting.BOLD, Util.translate(LOC_Broken, new Object[0])));
        } else {
            this.tips.add(HeadMaterialStats.formatDurability(ToolHelper.getCurrentDurability(this.stack), ToolHelper.getMaxDurability(this.stack)));
        }
        return this;
    }

    public TooltipBuilder addAmmo(boolean textIfEmpty) {
        if (this.stack.func_77973_b() instanceof IAmmo) {
            if (ToolHelper.isBroken(this.stack) && textIfEmpty) {
                this.tips.add(String.format("%s: %s%s%s", Util.translate(LOC_Ammo, new Object[0]), TextFormatting.DARK_RED, TextFormatting.BOLD, Util.translate(LOC_Empty, new Object[0])));
            } else {
                IAmmo ammoItem = (IAmmo)this.stack.func_77973_b();
                this.tips.add(TooltipBuilder.formatAmmo(ammoItem.getCurrentAmmo(this.stack), ammoItem.getMaxAmmo(this.stack)));
            }
        }
        return this;
    }

    public TooltipBuilder addMiningSpeed() {
        this.tips.add(HeadMaterialStats.formatMiningSpeed(ToolHelper.getActualMiningSpeed(this.stack)));
        return this;
    }

    public TooltipBuilder addHarvestLevel() {
        this.tips.add(HeadMaterialStats.formatHarvestLevel(ToolHelper.getHarvestLevelStat(this.stack)));
        return this;
    }

    public TooltipBuilder addAttack() {
        float attack = ToolHelper.getActualDamage(this.stack, (EntityLivingBase)Minecraft.func_71410_x().field_71439_g);
        this.tips.add(HeadMaterialStats.formatAttack(attack));
        return this;
    }

    public TooltipBuilder addFreeModifiers() {
        this.tips.add(String.format("%s: %d", I18n.func_74838_a((String)LOC_FreeModifiers), ToolHelper.getFreeModifiers(this.stack)));
        return this;
    }

    public TooltipBuilder addModifierInfo() {
        NBTTagList tagList = TagUtil.getModifiersTagList(this.stack);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound tag = tagList.func_150305_b(i);
            ModifierNBT data = ModifierNBT.readTag(tag);
            IModifier modifier = TinkerRegistry.getModifier(data.identifier);
            if (modifier == null || modifier.isHidden()) continue;
            for (String string : modifier.getExtraInfo(this.stack, tag)) {
                if (string.isEmpty()) continue;
                this.tips.add(data.getColorString() + string);
            }
        }
        return this;
    }

    public TooltipBuilder addDrawSpeed() {
        float speed = ProjectileLauncherNBT.from((ItemStack)this.stack).drawSpeed;
        if (this.stack.func_77973_b() instanceof BowCore) {
            speed = (float)((BowCore)this.stack.func_77973_b()).getDrawTime() / (20.0f * speed);
        }
        this.tips.add(BowMaterialStats.formatDrawspeed(speed));
        return this;
    }

    public TooltipBuilder addRange() {
        this.tips.add(BowMaterialStats.formatRange(ProjectileLauncherNBT.from((ItemStack)this.stack).range));
        return this;
    }

    public TooltipBuilder addProjectileBonusDamage() {
        this.tips.add(BowMaterialStats.formatDamage(ProjectileLauncherNBT.from((ItemStack)this.stack).bonusDamage));
        return this;
    }

    public TooltipBuilder addAccuracy() {
        this.add(FletchingMaterialStats.formatAccuracy(ProjectileNBT.from((ItemStack)this.stack).accuracy));
        return this;
    }

    public static void addModifierTooltips(ItemStack stack, List<String> tooltips) {
        NBTTagList tagList = TagUtil.getModifiersTagList(stack);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound tag = tagList.func_150305_b(i);
            ModifierNBT data = ModifierNBT.readTag(tag);
            IModifier modifier = TinkerRegistry.getModifier(data.identifier);
            if (modifier == null || modifier.isHidden()) continue;
            tooltips.add(data.getColorString() + modifier.getTooltip(tag, false));
        }
    }
}

