/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.util;

import com.lothrazar.cyclicmagic.ModCyclic;
import com.lothrazar.cyclicmagic.playerupgrade.storage.InventoryPlayerExtended;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.HashSet;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.event.entity.player.PlayerEvent;

public class UtilPlayerInventoryFilestorage {
    private static final String newExtension = "cyclicinvo";
    public static HashSet<Integer> playerEntityIds = new HashSet();
    private static HashMap<String, InventoryPlayerExtended> playerItems = new HashMap();

    public static void playerSetupOnLoad(PlayerEvent.LoadFromFile event) {
        EntityPlayer player = event.getEntityPlayer();
        UtilPlayerInventoryFilestorage.clearPlayerInventory(player);
        File playerFile = UtilPlayerInventoryFilestorage.getPlayerFileID(event.getPlayerDirectory(), event.getEntityPlayer());
        UtilPlayerInventoryFilestorage.loadPlayerInventory(event.getEntityPlayer(), playerFile);
        playerEntityIds.add(event.getEntityPlayer().func_145782_y());
    }

    private static void clearPlayerInventory(EntityPlayer player) {
        playerItems.remove(player.getDisplayNameString());
    }

    public static InventoryPlayerExtended getPlayerInventory(EntityPlayer player) {
        if (!playerItems.containsKey(player.getDisplayNameString())) {
            InventoryPlayerExtended inventory = new InventoryPlayerExtended(player);
            playerItems.put(player.getDisplayNameString(), inventory);
        }
        return playerItems.get(player.getDisplayNameString());
    }

    public static ItemStack getPlayerInventoryStack(EntityPlayer player, int slot) {
        return UtilPlayerInventoryFilestorage.getPlayerInventory(player).func_70301_a(slot);
    }

    public static void setPlayerInventoryStack(EntityPlayer player, int slot, ItemStack itemStack) {
        UtilPlayerInventoryFilestorage.getPlayerInventory((EntityPlayer)player).inv.set(slot, (Object)itemStack);
    }

    public static void setPlayerInventory(EntityPlayer player, InventoryPlayerExtended inventory) {
        playerItems.put(player.getDisplayNameString(), inventory);
    }

    private static void loadPlayerInventory(EntityPlayer player, File file1) {
        if (player != null && !player.func_130014_f_().field_72995_K) {
            try {
                NBTTagCompound data = null;
                boolean save = false;
                if (file1 != null && file1.exists()) {
                    try {
                        FileInputStream fileinputstream = new FileInputStream(file1);
                        data = CompressedStreamTools.func_74796_a((InputStream)fileinputstream);
                        fileinputstream.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (file1 == null || !file1.exists() || data == null || data.func_82582_d()) {
                    ModCyclic.logger.error("Data not found for " + player.getDisplayNameString());
                }
                if (data != null) {
                    InventoryPlayerExtended inventory = new InventoryPlayerExtended(player);
                    inventory.readNBT(data);
                    playerItems.put(player.getDisplayNameString(), inventory);
                    if (save) {
                        UtilPlayerInventoryFilestorage.savePlayerItems(player, file1);
                    }
                }
            }
            catch (Exception e) {
                ModCyclic.logger.error("Error loading player extended inventory");
                e.printStackTrace();
            }
        }
    }

    public static void savePlayerItems(@Nonnull EntityPlayer player, File playerDirectory) {
        if (!player.func_130014_f_().field_72995_K) {
            try {
                File fileToSaveID = UtilPlayerInventoryFilestorage.getPlayerFileID(playerDirectory, player);
                if (fileToSaveID != null) {
                    InventoryPlayerExtended inventory = UtilPlayerInventoryFilestorage.getPlayerInventory(player);
                    NBTTagCompound data = new NBTTagCompound();
                    inventory.saveNBT(data);
                    FileOutputStream fileoutputstream = new FileOutputStream(fileToSaveID);
                    CompressedStreamTools.func_74799_a((NBTTagCompound)data, (OutputStream)fileoutputstream);
                    fileoutputstream.close();
                } else {
                    ModCyclic.logger.error("Could not save file for player " + player.getDisplayNameString());
                }
            }
            catch (Exception e) {
                ModCyclic.logger.error("Could not save file for player " + player.getDisplayNameString(), e);
            }
        }
    }

    private static File getPlayerFileID(File playerDirectory, EntityPlayer player) {
        return new File(playerDirectory, player.func_110124_au() + "." + newExtension);
    }

    public static void syncItems(EntityPlayer player) {
        int size = 56;
        for (int a = 0; a < size; ++a) {
            UtilPlayerInventoryFilestorage.getPlayerInventory(player).syncSlotToClients(a);
        }
    }

    public static void putDataIntoInventory(InventoryPlayerExtended inventory, EntityPlayer player) {
        inventory.inv = UtilPlayerInventoryFilestorage.getPlayerInventory((EntityPlayer)player).inv;
    }

    public static int getSize() {
        return 56;
    }
}

