/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.util;

import com.lothrazar.cyclicmagic.ModCyclic;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;

public class UtilFluid {
    public static FluidActionResult fillContainer(World world, BlockPos pos, ItemStack stackIn, EnumFacing facing) {
        return FluidUtil.tryPickUpFluid((ItemStack)stackIn, null, (World)world, (BlockPos)pos, (EnumFacing)facing);
    }

    public static ItemStack dumpContainer(World world, BlockPos pos, ItemStack stackIn) {
        ItemStack dispensedStack = stackIn.func_77946_l();
        IFluidHandlerItem fluidHandler = FluidUtil.getFluidHandler((ItemStack)dispensedStack);
        if (fluidHandler == null) {
            return ItemStack.field_190927_a;
        }
        FluidStack fluidStack = fluidHandler.drain(1000, false);
        if (fluidStack != null) {
            ModCyclic.logger.info(fluidStack.amount + " amt BEFORE ", new Object[0]);
            FluidActionResult placementResult = FluidUtil.tryPlaceFluid(null, (World)world, (BlockPos)pos, (ItemStack)dispensedStack, (FluidStack)fluidStack.copy());
            if (placementResult.isSuccess()) {
                ModCyclic.logger.info(placementResult.success + " and  returnMe = " + placementResult.result, new Object[0]);
                return placementResult.result;
            }
        }
        return stackIn;
    }

    public static ItemStack drainOneBucket(ItemStack d) {
        IFluidHandlerItem fluidHandler = FluidUtil.getFluidHandler((ItemStack)d);
        if (fluidHandler == null) {
            return d;
        }
        fluidHandler.drain(1000, true);
        return fluidHandler.getContainer();
    }

    public static boolean isEmptyOfFluid(ItemStack returnMe) {
        FluidStack fs = FluidUtil.getFluidContained((ItemStack)returnMe);
        return fs == null || fs.amount == 0;
    }

    public static FluidStack getFluidContained(ItemStack returnMe) {
        return FluidUtil.getFluidContained((ItemStack)returnMe);
    }

    public static Fluid getFluidType(ItemStack returnMe) {
        FluidStack f = FluidUtil.getFluidContained((ItemStack)returnMe);
        return f == null ? null : f.getFluid();
    }

    public static boolean stackHasFluidHandler(ItemStack stackIn) {
        return FluidUtil.getFluidHandler((ItemStack)stackIn) != null;
    }

    public static boolean hasFluidHandler(TileEntity tile, EnumFacing side) {
        return tile != null && tile.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side);
    }

    public static IFluidHandler getFluidHandler(TileEntity tile, EnumFacing side) {
        return tile != null && tile.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side) ? (IFluidHandler)tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side) : null;
    }

    public static boolean interactWithFluidHandler(@Nonnull EntityPlayer player, @Nonnull World world, @Nonnull BlockPos pos, @Nullable EnumFacing side) {
        return FluidUtil.interactWithFluidHandler((EntityPlayer)player, (EnumHand)EnumHand.MAIN_HAND, (World)world, (BlockPos)pos, (EnumFacing)side);
    }

    public static boolean tryFillTankFromPosition(World world, BlockPos posSide, EnumFacing sideOpp, FluidTank tankTo, int amount) {
        return UtilFluid.tryFillTankFromPosition(world, posSide, sideOpp, tankTo, amount, false, null);
    }

    public static boolean isStackInvalid(FluidStack stackToTest, boolean isWhitelist, List<FluidStack> filterList) {
        if (filterList == null) {
            return true;
        }
        boolean hasMatch = false;
        for (FluidStack filt : filterList) {
            if (stackToTest.getFluid() != filt.getFluid()) continue;
            hasMatch = true;
            break;
        }
        if (hasMatch) {
            return isWhitelist;
        }
        return !isWhitelist;
    }

    public static boolean tryFillTankFromPosition(World world, BlockPos posSide, EnumFacing sideOpp, FluidTank tankTo, int amount, boolean isWhitelist, @Nullable List<FluidStack> allowedToMove) {
        try {
            IFluidHandler fluidFrom = FluidUtil.getFluidHandler((World)world, (BlockPos)posSide, (EnumFacing)sideOpp);
            if (fluidFrom != null) {
                FluidStack wasDrained = fluidFrom.drain(amount, false);
                if (wasDrained == null) {
                    return false;
                }
                if (!UtilFluid.isStackInvalid(wasDrained, isWhitelist, allowedToMove)) {
                    return false;
                }
                int filled = tankTo.fill(wasDrained, false);
                if (wasDrained != null && wasDrained.amount > 0 && filled > 0) {
                    int realAmt = Math.min(filled, wasDrained.amount);
                    wasDrained = fluidFrom.drain(realAmt, true);
                    if (wasDrained == null) {
                        return false;
                    }
                    return tankTo.fill(wasDrained, true) > 0;
                }
            }
            return false;
        }
        catch (Exception e) {
            ModCyclic.logger.error("External fluid block had an issue when we tried to drain", e);
            return false;
        }
    }

    public static boolean tryFillPositionFromTank(World world, BlockPos posSide, EnumFacing sideOpp, FluidTank tankFrom, int amount) {
        try {
            IFluidHandler fluidTo = FluidUtil.getFluidHandler((World)world, (BlockPos)posSide, (EnumFacing)sideOpp);
            if (fluidTo != null) {
                FluidStack wasDrained = tankFrom.drain(amount, false);
                if (wasDrained == null) {
                    return false;
                }
                int filled = fluidTo.fill(wasDrained, false);
                if (wasDrained != null && wasDrained.amount > 0 && filled > 0) {
                    int realAmt = Math.min(filled, wasDrained.amount);
                    wasDrained = tankFrom.drain(realAmt, true);
                    if (wasDrained == null) {
                        return false;
                    }
                    return fluidTo.fill(wasDrained, true) > 0;
                }
            }
            return false;
        }
        catch (Exception e) {
            ModCyclic.logger.error("A fluid tank had an issue when we tried to fill", e);
            return false;
        }
    }
}

