/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.potion.effect;

import com.lothrazar.cyclicmagic.potion.effect.PotionBase;
import com.lothrazar.cyclicmagic.util.UtilEntity;
import com.lothrazar.cyclicmagic.util.UtilParticle;
import com.lothrazar.cyclicmagic.util.UtilSound;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.potion.Potion;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class PotionBounce
extends PotionBase {
    private static final double VERTICAL_MOMENTUM_FACTOR = 0.917;
    private static final float DAMAGE_REDUCTION = 0.1f;
    private static final int MIN_HEIGHT_START_BOUNCE = 3;
    private static final double PERCENT_HEIGHT_BOUNCED = 0.95;
    private static final String NBT_MOTIONY = "motionY";
    private static final String NBT_TICK = "ticksExisted";

    public PotionBounce() {
        super("bounce", true, 9561177);
    }

    @SubscribeEvent
    public void onFall(LivingFallEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        if (entity == null || !(entity instanceof EntityPlayer) || entity.func_70093_af() || !entity.func_70644_a((Potion)this)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)entity;
        if (event.getDistance() >= 3.0f) {
            event.setDamageMultiplier(0.0f);
            if (!entity.func_130014_f_().field_72995_K) {
                event.setCanceled(true);
            } else {
                UtilSound.playSound(player, player.func_180425_c(), SoundEvents.field_187876_fn, SoundCategory.PLAYERS, 1.0f / event.getDistance());
                UtilParticle.spawnParticle(player.field_70170_p, EnumParticleTypes.SLIME, player.func_180425_c());
                event.setDistance(0.0f);
                if (!player.func_184613_cA()) {
                    player.field_70181_x *= -0.95;
                    player.field_70160_al = true;
                    player.field_70122_E = false;
                    player.field_70163_u += 0.01;
                    player.getEntityData().func_74768_a(NBT_TICK, player.field_70173_aa + 1);
                    player.getEntityData().func_74768_a(NBT_MOTIONY, (int)(player.field_70181_x * 100.0));
                }
            }
        } else if (!entity.func_130014_f_().field_72995_K && entity.func_70093_af()) {
            event.setDamageMultiplier(0.1f);
        }
    }

    @SubscribeEvent
    public void rebounceTick(TickEvent.PlayerTickEvent event) {
        if (event.player.func_70644_a((Potion)this) && !event.player.func_184613_cA()) {
            EntityPlayer player = event.player;
            if (player.func_184613_cA() || event.phase != TickEvent.Phase.END) {
                return;
            }
            float motionY = (float)player.getEntityData().func_74762_e(NBT_MOTIONY) / 100.0f;
            if (player.getEntityData().func_74762_e(NBT_TICK) == player.field_70173_aa && motionY > 0.0f) {
                player.getEntityData().func_74768_a(NBT_TICK, -1);
                player.field_70181_x = motionY;
            }
        }
    }

    @Override
    public void tick(EntityLivingBase entity) {
        if (!entity.field_70122_E && entity.func_70644_a((Potion)this) && !entity.func_184613_cA()) {
            UtilEntity.dragEntityMomentum(entity, 0.917);
        }
    }
}

