/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.block.password;

import com.lothrazar.cyclicmagic.block.core.TileEntityBaseMachineInvo;
import com.lothrazar.cyclicmagic.block.password.BlockPassword;
import com.lothrazar.cyclicmagic.block.password.IPlayerClaimed;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class TileEntityPassword
extends TileEntityBaseMachineInvo
implements ITickable,
IPlayerClaimed {
    private static final String NBT_ATYPE = "type";
    private static final String NBT_USERP = "up";
    private static final String NBT_PASSWORD = "myPass";
    public static List<String> listeningBlocksHash = new ArrayList<String>();
    public static List<TileEntityPassword> listeningBlocks = new ArrayList<TileEntityPassword>();
    private ActiveType type;
    private UsersAllowed userPerm;
    private String myPassword = "";
    private String userHash = "";
    private String userName = "";
    private int powerTimeout = 0;

    public TileEntityPassword() {
        super(0);
        this.setType(ActiveType.TOGGLE);
        this.setUserPerm(UsersAllowed.ALL);
    }

    public void onChunkUnload() {
        this.func_145843_s();
        this.onLoad();
    }

    public void onLoad() {
        if (FMLCommonHandler.instance().getEffectiveSide().isServer() && !listeningBlocksHash.contains(this.field_174879_c.toString())) {
            listeningBlocks.add(this);
            listeningBlocksHash.add(this.field_174879_c.toString());
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tags) {
        tags.func_74778_a(NBT_PASSWORD, this.getMyPassword());
        tags.func_74778_a("uhash", this.userHash);
        tags.func_74778_a("uname", this.userName);
        tags.func_74768_a(NBT_USERP, this.getUserPerm().ordinal());
        tags.func_74768_a(NBT_ATYPE, this.getType().ordinal());
        return super.func_189515_b(tags);
    }

    @Override
    public void func_145839_a(NBTTagCompound tags) {
        this.myPassword = tags.func_74779_i(NBT_PASSWORD);
        this.userHash = tags.func_74779_i("uhash");
        this.userName = tags.func_74779_i("uname");
        this.setType(ActiveType.values()[tags.func_74762_e(NBT_ATYPE)]);
        this.setUserPerm(UsersAllowed.values()[tags.func_74762_e(NBT_USERP)]);
        super.func_145839_a(tags);
    }

    public String getMyPassword() {
        return this.myPassword;
    }

    public void setMyPassword(String myPassword) {
        this.myPassword = myPassword;
    }

    @Override
    public int func_174890_g() {
        return Fields.values().length;
    }

    @Override
    public void func_174885_b(int id, int value) {
        switch (Fields.values()[id]) {
            case ACTIVETYPE: {
                this.setType(ActiveType.values()[value]);
                break;
            }
            case USERSALLOWED: {
                this.setUserPerm(UsersAllowed.values()[value]);
            }
        }
    }

    @Override
    public int func_174887_a_(int id) {
        switch (Fields.values()[id]) {
            case ACTIVETYPE: {
                return this.getType().ordinal();
            }
            case USERSALLOWED: {
                return this.getUserPerm().ordinal();
            }
        }
        return -1;
    }

    public ActiveType getType() {
        return this.type;
    }

    public void setType(ActiveType type) {
        this.type = type;
    }

    public UsersAllowed getUserPerm() {
        return this.userPerm;
    }

    public void setUserPerm(UsersAllowed userPerm) {
        this.userPerm = userPerm;
    }

    public void toggleActiveType() {
        int t = this.getType().ordinal();
        if (++t >= ActiveType.values().length) {
            t = 0;
        }
        this.setType(ActiveType.values()[t]);
    }

    public void toggleUserType() {
        int t = this.getUserPerm().ordinal();
        if (++t >= UsersAllowed.values().length) {
            t = 0;
        }
        this.setUserPerm(UsersAllowed.values()[t]);
    }

    public void onCorrectPassword(World world) {
        Block me = this.func_145838_q();
        IBlockState blockState = world.func_180495_p(this.func_174877_v());
        switch (this.type) {
            case PULSE: {
                world.func_175656_a(this.func_174877_v(), me.func_176223_P().func_177226_a((IProperty)BlockPassword.POWERED, (Comparable)Boolean.valueOf(true)));
                this.powerTimeout = 10;
                break;
            }
            case TOGGLE: {
                boolean hasPowerHere = me.func_176211_b(blockState, (IBlockAccess)world, this.func_174877_v(), EnumFacing.UP) > 0;
                world.func_175656_a(this.func_174877_v(), me.func_176223_P().func_177226_a((IProperty)BlockPassword.POWERED, (Comparable)Boolean.valueOf(!hasPowerHere)));
                break;
            }
        }
    }

    public void func_73660_a() {
        if (this.powerTimeout > 0) {
            --this.powerTimeout;
            if (this.powerTimeout == 0) {
                World world = this.func_145831_w();
                world.func_175656_a(this.func_174877_v(), this.func_145838_q().func_176223_P().func_177226_a((IProperty)BlockPassword.POWERED, (Comparable)Boolean.valueOf(false)));
            }
        }
    }

    @Override
    public boolean isClaimedBy(EntityPlayer p) {
        return p.func_110124_au().toString().equals(this.userHash);
    }

    @Override
    public boolean isClaimedBySomeone() {
        return this.userHash != null && !this.userHash.isEmpty();
    }

    @Override
    public String getClaimedHash() {
        return this.userHash;
    }

    @Override
    public void toggleClaimedHash(EntityPlayer player) {
        if (this.isClaimedBySomeone()) {
            this.userHash = "";
            this.userName = "";
        } else {
            this.userHash = player.func_110124_au().toString();
            this.userName = player.getDisplayNameString();
        }
    }

    @Override
    public String getClaimedName() {
        return this.userName;
    }

    public static enum Fields {
        ACTIVETYPE,
        USERSALLOWED;

    }

    public static enum UsersAllowed {
        ALL,
        ME;

    }

    public static enum ActiveType {
        TOGGLE,
        PULSE;

    }
}

