/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.block.exppylon;

import com.lothrazar.cyclicmagic.block.core.TileEntityBaseMachineFluid;
import com.lothrazar.cyclicmagic.data.ITileRedstoneToggle;
import com.lothrazar.cyclicmagic.liquid.FluidTankFixDesync;
import com.lothrazar.cyclicmagic.util.UtilItemStack;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class TileEntityXpPylon
extends TileEntityBaseMachineFluid
implements ITickable,
ITileRedstoneToggle {
    public static final int TANK_FULL = 1000000;
    private static final int XP_PER_SPEWORB = 50;
    public static final int FLUID_PER_EXP = 20;
    private static final int VRADIUS = 2;
    private static final int XP_PER_BOTTLE = 11;
    public static final int TIMER_FULL = 22;
    public static final int SLOT_INPUT = 0;
    public static final int SLOT_OUTPUT = 1;
    private static final String NBT_TIMER = "Timer";
    private static final String NBT_COLLECT = "collect";
    public static final int RADIUS = 16;
    private int collect = 1;

    public TileEntityXpPylon() {
        super(2);
        this.setSlotsForExtract(1);
        this.setSlotsForInsert(0);
        this.tank = new FluidTankFixDesync(1000000, this);
        this.tank.setFluidAllowed(FluidRegistry.getFluid((String)"xpjuice"));
    }

    @Override
    public boolean func_94041_b(int index, ItemStack stack) {
        if (index == 0) {
            return stack.func_77973_b() == Items.field_151069_bo;
        }
        return super.func_94041_b(index, stack);
    }

    @Override
    public int[] getFieldOrdinals() {
        return super.getFieldArray(Fields.values().length);
    }

    public void func_73660_a() {
        if (!this.isRunning()) {
            return;
        }
        --this.timer;
        if (this.timer <= 0) {
            this.timer = 22;
            if (this.collect == ActionMode.COLLECT.ordinal()) {
                this.updateCollection();
            }
            if (this.collect == ActionMode.SPRAY.ordinal()) {
                this.updateSpray();
            }
            this.updateBottle();
        }
    }

    private void updateBottle() {
        int fluidToDrain = 220;
        if (this.outputSlotHasRoom() && this.inputSlotHasSome() && this.getCurrentFluidStackAmount() >= fluidToDrain) {
            FluidStack actuallyDrained = this.tank.drain(fluidToDrain, true);
            if (actuallyDrained == null || actuallyDrained.amount == 0) {
                return;
            }
            this.outputSlotIncrement();
            this.inputSlotDecrement();
        }
    }

    private void updateSpray() {
        int fluidToDrain = 1000;
        int toSpew = Math.min(fluidToDrain, this.getCurrentFluidStackAmount());
        int expToRelease = toSpew / 50;
        if (expToRelease > 0 && this.getCurrentFluidStackAmount() >= toSpew) {
            FluidStack actuallyDrained = this.tank.drain(toSpew, true);
            if (actuallyDrained == null || actuallyDrained.amount == 0) {
                return;
            }
            if (!this.field_145850_b.field_72995_K) {
                EntityXPOrb orb = new EntityXPOrb(this.field_145850_b);
                orb.func_70634_a((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5);
                orb.field_70530_e = expToRelease;
                orb.field_70532_c = 0;
                this.field_145850_b.func_72838_d((Entity)orb);
                orb.func_70024_g(Math.random() / 1000.0, 0.01, Math.random() / 1000.0);
            }
        }
    }

    private void updateCollection() {
        AxisAlignedBB region = new AxisAlignedBB(this.func_174877_v().func_177984_a()).func_72321_a(16.0, 2.0, 16.0).func_72321_a(-16.0, -2.0, -16.0);
        List orbs = this.func_145831_w().func_72872_a(EntityXPOrb.class, region);
        if (orbs != null) {
            for (EntityXPOrb orb : orbs) {
                if (orb.field_70128_L || orb.field_70532_c > 0) continue;
                this.tank.fill(new FluidStack(FluidRegistry.getFluid((String)"xpjuice"), orb.func_70526_d() * 20), true);
                orb.field_70532_c = 9999;
                orb.field_70530_e = 0;
                this.func_145831_w().func_72900_e((Entity)orb);
            }
        }
    }

    private void outputSlotIncrement() {
        ItemStack fullOnes = this.func_70301_a(1);
        if (UtilItemStack.isEmpty(fullOnes)) {
            fullOnes = new ItemStack(Items.field_151062_by);
        } else {
            fullOnes.func_190917_f(1);
        }
        this.func_70299_a(1, fullOnes);
    }

    private boolean outputSlotHasRoom() {
        ItemStack fullOnes = this.func_70301_a(1);
        return fullOnes.func_190916_E() < 64;
    }

    private boolean inputSlotHasSome() {
        ItemStack emptyOnes = this.func_70301_a(0);
        if (emptyOnes.func_77973_b() != Items.field_151069_bo) {
            return false;
        }
        return !UtilItemStack.isEmpty(emptyOnes) && emptyOnes.func_190916_E() > 0;
    }

    private void inputSlotDecrement() {
        ItemStack fullOnes = this.func_70301_a(0);
        fullOnes.func_190918_g(1);
        if (fullOnes.func_190916_E() == 0) {
            fullOnes = ItemStack.field_190927_a;
        }
        this.func_70299_a(0, fullOnes);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tags) {
        tags.func_74768_a(NBT_TIMER, this.timer);
        tags.func_74768_a(NBT_COLLECT, this.collect);
        tags.func_74768_a("redstone", this.needsRedstone);
        return super.func_189515_b(tags);
    }

    @Override
    public void func_145839_a(NBTTagCompound tags) {
        super.func_145839_a(tags);
        this.timer = tags.func_74762_e(NBT_TIMER);
        this.collect = tags.func_74762_e(NBT_COLLECT);
        this.needsRedstone = tags.func_74762_e("redstone");
    }

    @Override
    public int func_174890_g() {
        return Fields.values().length;
    }

    @Override
    public int func_174887_a_(int id) {
        switch (Fields.values()[id]) {
            case TIMER: {
                return this.timer;
            }
            case EXP: {
                return this.getCurrentFluidStackAmount();
            }
            case COLLECT: {
                return this.collect;
            }
            case REDSTONE: {
                return this.needsRedstone;
            }
        }
        return -1;
    }

    @Override
    public void func_174885_b(int id, int value) {
        switch (Fields.values()[id]) {
            case TIMER: {
                this.timer = value;
                break;
            }
            case EXP: {
                if (this.tank.getFluid() == null) {
                    this.tank.setFluid(new FluidStack(FluidRegistry.getFluid((String)"xpjuice"), 0));
                }
                this.tank.setFluidAmount(value);
                break;
            }
            case COLLECT: {
                this.collect = value % 2;
                break;
            }
            case REDSTONE: {
                this.needsRedstone = value % 2;
                break;
            }
        }
    }

    @Override
    public void toggleNeedsRedstone() {
        this.func_174885_b(Fields.REDSTONE.ordinal(), (this.needsRedstone + 1) % 2);
    }

    @Override
    public boolean onlyRunIfPowered() {
        return this.needsRedstone == 1;
    }

    public static enum ActionMode {
        SPRAY,
        COLLECT;

    }

    public static enum Fields {
        TIMER,
        EXP,
        COLLECT,
        REDSTONE;

    }
}

