/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.block.dice;

import com.lothrazar.cyclicmagic.IContent;
import com.lothrazar.cyclicmagic.block.core.BlockBaseFacingOmni;
import com.lothrazar.cyclicmagic.block.dice.TileEntityDice;
import com.lothrazar.cyclicmagic.data.IHasRecipe;
import com.lothrazar.cyclicmagic.guide.GuideCategory;
import com.lothrazar.cyclicmagic.registry.BlockRegistry;
import com.lothrazar.cyclicmagic.registry.RecipeRegistry;
import com.lothrazar.cyclicmagic.registry.SoundRegistry;
import com.lothrazar.cyclicmagic.util.UtilSound;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.config.Configuration;

public class BlockDice
extends BlockBaseFacingOmni
implements IHasRecipe,
IContent {
    private static final double SIZE = 0.9;
    protected static final AxisAlignedBB AABB = new AxisAlignedBB(0.09999999999999998, 0.09999999999999998, 0.09999999999999998, 0.9, 0.9, 0.9);
    private boolean enabled;

    public BlockDice() {
        super(Material.field_151576_e);
        this.setTranslucent();
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB;
    }

    public TileEntity createTileEntity(World worldIn, IBlockState state) {
        return new TileEntityDice();
    }

    @Override
    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing blockFaceClickedOn, float hitX, float hitY, float hitZ, int meta, @Nullable EntityLivingBase placer) {
        EnumFacing fac = BlockDice.getRandom(world.field_73012_v);
        return this.func_176223_P().func_177226_a((IProperty)PROPERTYFACING, (Comparable)fac);
    }

    @Override
    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntity tile = world.func_175625_s(pos);
        if (hand == EnumHand.MAIN_HAND && tile instanceof TileEntityDice) {
            ((TileEntityDice)tile).startSpinning();
            UtilSound.playSound(player, SoundRegistry.dice_mikekoenig);
            return true;
        }
        return false;
    }

    public int func_180641_l(IBlockState blockState, World world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityDice && ((TileEntityDice)tile).isSpinning()) {
            return 0;
        }
        EnumFacing fac = (EnumFacing)blockState.func_177229_b((IProperty)PROPERTYFACING);
        int factor = 2;
        switch (fac) {
            case NORTH: {
                return 1 * factor;
            }
            case SOUTH: {
                return 2 * factor;
            }
            case UP: {
                return 3 * factor;
            }
            case DOWN: {
                return 4 * factor;
            }
            case WEST: {
                return 5 * factor;
            }
            case EAST: {
                return 6 * factor;
            }
        }
        return super.func_180641_l(blockState, world, pos);
    }

    public static EnumFacing getRandom(Random rand) {
        int index = MathHelper.func_76136_a((Random)rand, (int)0, (int)(EnumFacing.values().length - 1));
        return EnumFacing.values()[index];
    }

    @Override
    public void syncConfig(Configuration config) {
        this.enabled = config.getBoolean("dice", "cyclicmagic.content", true, " Set false to delete - requires restart");
    }

    @Override
    public void register() {
        BlockRegistry.registerBlock((Block)new BlockDice(), this.getContentName(), GuideCategory.BLOCK);
        BlockRegistry.registerTileEntity(TileEntityDice.class, this.getContentName() + "_te");
    }

    @Override
    public String getContentName() {
        return "dice";
    }

    @Override
    public boolean enabled() {
        return this.enabled;
    }

    @Override
    public IRecipe addRecipe() {
        return RecipeRegistry.addShapedRecipe(new ItemStack((Block)this), "sts", "tit", "sts", Character.valueOf('t'), "cobblestone", Character.valueOf('i'), "dyeBlack", Character.valueOf('s'), "bone");
    }
}

