/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.block.core;

import com.lothrazar.cyclicmagic.block.core.TileEntityBaseMachineInvo;
import com.lothrazar.cyclicmagic.liquid.FluidTankBase;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityBaseMachineFluid
extends TileEntityBaseMachineInvo
implements IFluidHandler {
    public FluidTankBase tank;

    public TileEntityBaseMachineFluid(int invoSize) {
        super(invoSize);
    }

    public int getCapacity() {
        return this.tank.getCapacity();
    }

    public IFluidTankProperties[] getTankProperties() {
        FluidTankInfo info = this.tank.getInfo();
        return new IFluidTankProperties[]{new FluidTankProperties(info.fluid, info.capacity, true, true)};
    }

    private boolean doesFluidMatchTank(FluidStack incoming) {
        if (this.tank == null) {
            return false;
        }
        if (this.tank.getFluid() == null) {
            return true;
        }
        return this.tank.getFluid().getFluid() == incoming.getFluid();
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (resource == null || !this.doesFluidMatchTank(resource)) {
            return 0;
        }
        if (resource.amount + this.tank.getFluidAmount() > this.tank.getCapacity()) {
            resource.amount = this.tank.getCapacity() - this.tank.getFluidAmount();
        }
        int result = this.tank.fill(resource, doFill);
        this.tank.setFluid(resource);
        return result;
    }

    public Fluid getFluidContainedOrNull() {
        if (this.tank == null || this.tank.getFluid() == null) {
            return null;
        }
        return this.tank.getFluid().getFluid();
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        if (!this.doesFluidMatchTank(resource)) {
            return resource;
        }
        FluidStack result = this.tank.drain(resource, doDrain);
        this.tank.setFluid(resource);
        return result;
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        FluidStack result = this.tank.drain(maxDrain, doDrain);
        return result;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        if (this.tank != null) {
            NBTTagCompound newTag = this.tank.writeToNBT(new NBTTagCompound());
            tagCompound.func_74782_a("tankwater", (NBTBase)newTag);
        }
        return super.func_189515_b(tagCompound);
    }

    @Override
    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        if (this.tank != null && tagCompound.func_74764_b("tankwater")) {
            this.tank.readFromNBT(tagCompound.func_74775_l("tankwater"));
        }
    }

    @Override
    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this.tank);
        }
        return super.getCapability(capability, facing);
    }

    @SideOnly(value=Side.CLIENT)
    public void updateFluidTo(FluidStack fluid) {
        this.tank.setFluid(fluid);
    }

    protected void setCurrentFluid(int amt) {
        IFluidHandler fluidHandler = (IFluidHandler)this.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, EnumFacing.UP);
        if (fluidHandler == null || fluidHandler.getTankProperties() == null || fluidHandler.getTankProperties().length == 0) {
            return;
        }
        FluidStack fluid = fluidHandler.getTankProperties()[0].getContents();
        fluid.amount = amt;
        this.tank.setFluid(fluid);
    }

    public final int getCurrentFluidStackAmount() {
        FluidStack fluid = this.getCurrentFluidStack();
        if (fluid == null) {
            return 0;
        }
        return fluid.amount;
    }

    public FluidStack getCurrentFluidStack() {
        IFluidHandler fluidHandler = (IFluidHandler)this.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, EnumFacing.UP);
        if (fluidHandler == null || fluidHandler.getTankProperties() == null || fluidHandler.getTankProperties().length == 0) {
            return null;
        }
        return fluidHandler.getTankProperties()[0].getContents();
    }

    public static class ContainerDummy
    extends Container {
        public boolean func_75145_c(EntityPlayer playerIn) {
            return false;
        }
    }
}

