/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.computer;

import java.util.Collection;
import java.util.HashMap;
import vswe.stevescarts.entitys.EntityMinecartModular;
import vswe.stevescarts.guis.buttons.ButtonBase;
import vswe.stevescarts.guis.buttons.ButtonControlType;
import vswe.stevescarts.modules.ModuleBase;
import vswe.stevescarts.modules.addons.ModuleChunkLoader;
import vswe.stevescarts.modules.addons.ModuleColorizer;
import vswe.stevescarts.modules.addons.ModuleHeightControl;
import vswe.stevescarts.modules.addons.ModuleInvisible;
import vswe.stevescarts.modules.addons.ModuleShield;
import vswe.stevescarts.modules.realtimers.ModuleDynamite;
import vswe.stevescarts.modules.realtimers.ModuleFirework;
import vswe.stevescarts.modules.realtimers.ModuleShooter;
import vswe.stevescarts.modules.realtimers.ModuleShooterAdv;
import vswe.stevescarts.modules.workers.ModuleComputer;
import vswe.stevescarts.modules.workers.ModuleTorch;
import vswe.stevescarts.modules.workers.tools.ModuleDrill;

public class ComputerControl {
    private static HashMap<Byte, ComputerControl> controls = new HashMap();
    private Class<? extends ModuleBase> moduleClass;
    private byte id;
    private String name;
    private int texture;

    public static HashMap<Byte, ComputerControl> getMap() {
        return controls;
    }

    public static Collection<ComputerControl> getList() {
        return controls.values();
    }

    public static void createButtons(EntityMinecartModular cart, ModuleComputer assembly) {
        for (ComputerControl control : ComputerControl.getList()) {
            if (!control.isControlValid(cart)) continue;
            new ButtonControlType(assembly, ButtonBase.LOCATION.TASK, control.id);
        }
    }

    private byte clamp(byte val, int min, int max) {
        return (byte)Math.max((byte)min, (byte)Math.min(val, (byte)max));
    }

    public ComputerControl(int id, String name, int texture, Class<? extends ModuleBase> moduleClass) {
        this.moduleClass = moduleClass;
        this.name = name;
        this.id = (byte)id;
        this.texture = texture;
        controls.put(this.id, this);
    }

    public boolean isControlValid(EntityMinecartModular cart) {
        for (ModuleBase module : cart.getModules()) {
            if (!this.moduleClass.isAssignableFrom(module.getClass()) || !this.isValid(module)) continue;
            return true;
        }
        return false;
    }

    public String getName() {
        return this.name;
    }

    public int getTexture() {
        return this.texture;
    }

    public void runHandler(EntityMinecartModular cart, byte val) {
        for (ModuleBase module : cart.getModules()) {
            if (!this.moduleClass.isAssignableFrom(module.getClass()) || !this.isValid(module)) continue;
            this.run(module, this.clamp(val, (byte)this.getIntegerMin(), (byte)this.getIntegerMax()));
            break;
        }
    }

    public int getIntegerMin() {
        if (this.isBoolean()) {
            return 0;
        }
        return this.getMin();
    }

    public int getIntegerMax() {
        if (this.isBoolean()) {
            return 1;
        }
        return this.getMax();
    }

    public boolean useIntegerOfSize(int size) {
        return !this.isBoolean() || size <= 1;
    }

    protected boolean isBoolean() {
        return false;
    }

    protected boolean isActivator() {
        return false;
    }

    protected void run(ModuleBase module, byte val) {
    }

    protected int getMin() {
        return -127;
    }

    protected int getMax() {
        return 128;
    }

    protected boolean isValid(ModuleBase module) {
        return true;
    }

    static {
        new ComputerControl(1, "Light threshold [0-15]", 69, ModuleTorch.class){

            @Override
            protected void run(ModuleBase module, byte val) {
                ((ModuleTorch)module).setThreshold(val);
            }

            @Override
            protected int getMin() {
                return 0;
            }

            @Override
            protected int getMax() {
                return 15;
            }
        };
        new ComputerControl(2, "Shield", 70, ModuleShield.class){

            @Override
            protected void run(ModuleBase module, byte val) {
                ((ModuleShield)module).setShieldStatus(val != 0);
            }

            @Override
            protected boolean isBoolean() {
                return true;
            }
        };
        new ComputerControl(3, "Drill", 71, ModuleDrill.class){

            @Override
            protected void run(ModuleBase module, byte val) {
                ((ModuleDrill)module).setDrillEnabled(val != 0);
            }

            @Override
            protected boolean isBoolean() {
                return true;
            }
        };
        new ComputerControl(4, "Invisibility Core", 72, ModuleInvisible.class){

            @Override
            protected void run(ModuleBase module, byte val) {
                ((ModuleInvisible)module).setIsVisible(val == 0);
            }

            @Override
            protected boolean isBoolean() {
                return true;
            }
        };
        new ComputerControl(5, "Chunk loader", 73, ModuleChunkLoader.class){

            @Override
            protected void run(ModuleBase module, byte val) {
                ((ModuleChunkLoader)module).setChunkLoading(val != 0);
            }

            @Override
            protected boolean isBoolean() {
                return true;
            }
        };
        new ComputerControl(6, "Fuse length [2-127]", 74, ModuleDynamite.class){

            @Override
            protected void run(ModuleBase module, byte val) {
                ((ModuleDynamite)module).setFuseLength(val);
            }

            @Override
            protected int getMin() {
                return 2;
            }
        };
        new ComputerControl(7, "Prime", 75, ModuleDynamite.class){

            @Override
            protected void run(ModuleBase module, byte val) {
                ((ModuleDynamite)module).prime();
            }

            @Override
            protected boolean isActivator() {
                return true;
            }
        };
        new ComputerControl(8, "Active pipes", 76, ModuleShooter.class){

            @Override
            protected void run(ModuleBase module, byte val) {
                ((ModuleShooter)module).setActivePipes(val);
            }

            @Override
            protected boolean isValid(ModuleBase module) {
                return !(module instanceof ModuleShooterAdv);
            }
        };
        new ComputerControl(9, "Selected targets", 77, ModuleShooterAdv.class){

            @Override
            protected void run(ModuleBase module, byte val) {
                ((ModuleShooterAdv)module).setOptions(val);
            }
        };
        new ComputerControl(10, "Fire", 78, ModuleFirework.class){

            @Override
            protected void run(ModuleBase module, byte val) {
                ((ModuleFirework)module).fire();
            }

            @Override
            protected boolean isActivator() {
                return true;
            }
        };
        new ComputerControl(11, "Red [0-64]", 79, ModuleColorizer.class){

            @Override
            protected void run(ModuleBase module, byte val) {
                ((ModuleColorizer)module).setColorVal(0, (byte)Math.min(val * 4, 255));
            }

            @Override
            protected int getMin() {
                return 0;
            }

            @Override
            protected int getMax() {
                return 64;
            }
        };
        new ComputerControl(12, "Green [0-64]", 80, ModuleColorizer.class){

            @Override
            protected void run(ModuleBase module, byte val) {
                ((ModuleColorizer)module).setColorVal(1, (byte)Math.min(val * 4, 255));
            }

            @Override
            protected int getMin() {
                return 0;
            }

            @Override
            protected int getMax() {
                return 64;
            }
        };
        new ComputerControl(13, "Blue [0-64]", 81, ModuleColorizer.class){

            @Override
            protected void run(ModuleBase module, byte val) {
                ((ModuleColorizer)module).setColorVal(2, (byte)Math.min(val * 4, 255));
            }

            @Override
            protected int getMin() {
                return 0;
            }

            @Override
            protected int getMax() {
                return 64;
            }
        };
        new ComputerControl(14, "Y target [-128-127]", 85, ModuleHeightControl.class){

            @Override
            protected void run(ModuleBase module, byte val) {
                ((ModuleHeightControl)module).setYTarget(val + 128);
            }
        };
    }
}

