/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.world;

import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.MapGenBase;
import net.minecraft.world.gen.MapGenCavesHell;
import net.minecraft.world.gen.NoiseGeneratorOctaves;
import net.minecraft.world.gen.NoiseGeneratorSimplex;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.terraingen.ChunkGeneratorEvent;
import net.minecraftforge.event.terraingen.InitMapGenEvent;
import net.minecraftforge.event.terraingen.InitNoiseGensEvent;
import net.minecraftforge.event.terraingen.TerrainGen;
import net.minecraftforge.fml.common.eventhandler.Event;
import zmaster587.advancedRocketry.dimension.DimensionManager;
import zmaster587.advancedRocketry.dimension.DimensionProperties;
import zmaster587.advancedRocketry.util.OreGenProperties;
import zmaster587.advancedRocketry.world.ChunkProviderPlanet;
import zmaster587.advancedRocketry.world.decoration.MapGenHighCaves;
import zmaster587.advancedRocketry.world.decoration.MapGenMassiveRavine;
import zmaster587.advancedRocketry.world.ore.CustomizableOreGen;

public class ChunkProviderAsteroids
extends ChunkProviderPlanet {
    protected static final IBlockState AIR = Blocks.field_150350_a.func_176223_P();
    protected static final IBlockState BEDROCK = Blocks.field_150357_h.func_176223_P();
    private final World world;
    private final boolean generateStructures;
    private final Random rand;
    private double[] slowsandNoise = new double[256];
    private double[] gravelNoise = new double[256];
    private double[] depthBuffer = new double[256];
    private double[] buffer;
    private NoiseGeneratorOctaves lperlinNoise1;
    private NoiseGeneratorOctaves lperlinNoise2;
    private NoiseGeneratorOctaves perlinNoise1;
    private NoiseGeneratorOctaves slowsandGravelNoiseGen;
    private NoiseGeneratorOctaves netherrackExculsivityNoiseGen;
    public NoiseGeneratorOctaves scaleNoise;
    public NoiseGeneratorOctaves depthNoise;
    public NoiseGeneratorSimplex islandNoise;
    MapGenBase genHighCaves = new MapGenHighCaves();
    private MapGenBase genRavines = new MapGenMassiveRavine();
    private MapGenBase genNetherCaves = new MapGenCavesHell();
    double[] pnr;
    double[] ar;
    double[] br;
    double[] noiseData4;
    double[] dr;
    private IBlockState oceanBlock;
    private IBlockState fillblock;

    public ChunkProviderAsteroids(World worldIn, boolean p_i45637_2_, long seed, String p_i46668_5_) {
        super(worldIn, seed, p_i45637_2_, p_i46668_5_);
        this.world = worldIn;
        this.generateStructures = p_i45637_2_;
        this.rand = new Random(seed);
        this.lperlinNoise1 = new NoiseGeneratorOctaves(this.rand, 16);
        this.lperlinNoise2 = new NoiseGeneratorOctaves(this.rand, 16);
        this.perlinNoise1 = new NoiseGeneratorOctaves(this.rand, 8);
        this.slowsandGravelNoiseGen = new NoiseGeneratorOctaves(this.rand, 4);
        this.netherrackExculsivityNoiseGen = new NoiseGeneratorOctaves(this.rand, 8);
        this.scaleNoise = new NoiseGeneratorOctaves(this.rand, 10);
        this.depthNoise = new NoiseGeneratorOctaves(this.rand, 16);
        this.islandNoise = new NoiseGeneratorSimplex(this.rand);
        DimensionProperties dimProps = DimensionManager.getInstance().getDimensionProperties(worldIn.field_73011_w.getDimension());
        worldIn.func_181544_b(dimProps.getSeaLevel());
        IBlockState oceanBlock = dimProps.getOceanBlock();
        this.oceanBlock = oceanBlock != null ? oceanBlock : Blocks.field_150355_j.func_176223_P();
        IBlockState fillBlock = dimProps.getStoneBlock();
        this.fillblock = fillBlock != null ? fillBlock : Blocks.field_150348_b.func_176223_P();
        InitNoiseGensEvent.ContextHell ctx = new InitNoiseGensEvent.ContextHell(this.lperlinNoise1, this.lperlinNoise2, this.perlinNoise1, this.slowsandGravelNoiseGen, this.netherrackExculsivityNoiseGen, this.scaleNoise, this.depthNoise);
        ctx = (InitNoiseGensEvent.ContextHell)TerrainGen.getModdedNoiseGenerators((World)worldIn, (Random)this.rand, (InitNoiseGensEvent.Context)ctx);
        this.lperlinNoise1 = ctx.getLPerlin1();
        this.lperlinNoise2 = ctx.getLPerlin2();
        this.perlinNoise1 = ctx.getPerlin();
        this.slowsandGravelNoiseGen = ctx.getPerlin2();
        this.netherrackExculsivityNoiseGen = ctx.getPerlin3();
        this.scaleNoise = ctx.getScale();
        this.depthNoise = ctx.getDepth();
        this.genNetherCaves = TerrainGen.getModdedMapGen((MapGenBase)this.genNetherCaves, (InitMapGenEvent.EventType)InitMapGenEvent.EventType.NETHER_CAVE);
        this.heightmapOffset = 0;
        this.heightmapMult = (float)((double)this.heightmapMult * 1.0);
    }

    public void prepareHeights(int p_185936_1_, int p_185936_2_, int yOffset, ChunkPrimer primer) {
        int i = 4;
        int k = 5;
        int l = 17;
        int i1 = 5;
        this.buffer = this.getHeights(this.buffer, p_185936_1_ * 4, 0, p_185936_2_ * 4, 5, 17, 5);
        for (int j1 = 0; j1 < 4; ++j1) {
            for (int k1 = 0; k1 < 4; ++k1) {
                for (int l1 = 0; l1 < 16; ++l1) {
                    double d0 = 0.125;
                    double d1 = this.buffer[((j1 + 0) * 5 + k1 + 0) * 17 + l1 + 0];
                    double d2 = this.buffer[((j1 + 0) * 5 + k1 + 1) * 17 + l1 + 0];
                    double d3 = this.buffer[((j1 + 1) * 5 + k1 + 0) * 17 + l1 + 0];
                    double d4 = this.buffer[((j1 + 1) * 5 + k1 + 1) * 17 + l1 + 0];
                    double d5 = (this.buffer[((j1 + 0) * 5 + k1 + 0) * 17 + l1 + 1] - d1) * d0;
                    double d6 = (this.buffer[((j1 + 0) * 5 + k1 + 1) * 17 + l1 + 1] - d2) * d0;
                    double d7 = (this.buffer[((j1 + 1) * 5 + k1 + 0) * 17 + l1 + 1] - d3) * d0;
                    double d8 = (this.buffer[((j1 + 1) * 5 + k1 + 1) * 17 + l1 + 1] - d4) * d0;
                    for (int i2 = 0; i2 < 8; ++i2) {
                        double d9 = 0.25;
                        double d10 = d1;
                        double d11 = d2;
                        double d12 = (d3 - d1) * 0.25;
                        double d13 = (d4 - d2) * 0.25;
                        for (int j2 = 0; j2 < 4; ++j2) {
                            double d14 = 0.25;
                            double d15 = d10;
                            double d16 = (d11 - d10) * 0.25;
                            for (int k2 = 0; k2 < 4; ++k2) {
                                IBlockState iblockstate = null;
                                if (d15 > 10.0) {
                                    iblockstate = this.fillblock;
                                }
                                int l2 = j2 + j1 * 4;
                                int i3 = i2 + l1 * 8;
                                int j3 = k2 + k1 * 4;
                                primer.func_177855_a(l2, i3 + yOffset, j3, iblockstate);
                                d15 += d16;
                            }
                            d10 += d12;
                            d11 += d13;
                        }
                        d1 += d5;
                        d2 += d6;
                        d3 += d7;
                        d4 += d8;
                    }
                }
            }
        }
    }

    private double[] getHeights(double[] p_185963_1_, int p_185963_2_, int p_185963_3_, int p_185963_4_, int p_185963_5_, int p_185963_6_, int p_185963_7_) {
        ChunkGeneratorEvent.InitNoiseField event = new ChunkGeneratorEvent.InitNoiseField((IChunkGenerator)this, p_185963_1_, p_185963_2_, p_185963_3_, p_185963_4_, p_185963_5_, p_185963_6_, p_185963_7_);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.getResult() == Event.Result.DENY) {
            return event.getNoisefield();
        }
        if (p_185963_1_ == null) {
            p_185963_1_ = new double[p_185963_5_ * p_185963_6_ * p_185963_7_];
        }
        double d0 = 684.412;
        double d1 = 684.412;
        double scale = 1.0;
        this.pnr = this.perlinNoise1.func_76304_a(this.pnr, (int)(scale * (double)p_185963_2_), (int)(scale * (double)p_185963_3_), (int)(scale * (double)p_185963_4_), p_185963_5_, p_185963_6_, p_185963_7_, scale * (d0 *= 6.0) / 80.0, scale * 4.277575000000001, scale * d0 / 80.0);
        this.ar = this.lperlinNoise1.func_76304_a(this.ar, (int)(scale * (double)p_185963_2_), (int)(scale * (double)p_185963_3_), (int)(scale * (double)p_185963_4_), p_185963_5_, p_185963_6_, p_185963_7_, scale * d0, scale * 684.412, scale * d0);
        this.br = this.lperlinNoise2.func_76304_a(this.br, (int)(scale * (double)p_185963_2_), (int)(scale * (double)p_185963_3_), (int)(scale * (double)p_185963_4_), p_185963_5_, p_185963_6_, p_185963_7_, scale * d0, scale * 684.412, scale * d0);
        int i = p_185963_2_ / 2;
        int j = p_185963_4_ / 2;
        int k = 0;
        for (int l = 0; l < p_185963_5_; ++l) {
            for (int i1 = 0; i1 < p_185963_7_; ++i1) {
                float f = this.getIslandHeightValue(i, j, l, i1);
                for (int j1 = 0; j1 < p_185963_6_; ++j1) {
                    double d2 = this.ar[k] / 512.0;
                    double d3 = this.br[k] / 512.0;
                    double d5 = (this.pnr[k] / 10.0 + 1.0) / 2.0;
                    double d4 = d5 < 0.0 ? d2 : (d5 > 1.0 ? d3 : d2 + (d3 - d2) * d5);
                    d4 -= 8.0;
                    d4 += (double)f;
                    int k1 = 2;
                    if (j1 > p_185963_6_ / 2 - k1) {
                        double d6 = (float)(j1 - (p_185963_6_ / 2 - k1)) / 64.0f;
                        d6 = MathHelper.func_151237_a((double)d6, (double)0.0, (double)1.0);
                        d4 = d4 * (1.0 - d6) + -3000.0 * d6;
                    }
                    if (j1 < (k1 = 8)) {
                        double d7 = (float)(k1 - j1) / ((float)k1 - 1.0f);
                        d4 = d4 * (1.0 - d7) + -30.0 * d7;
                    }
                    p_185963_1_[k] = d4;
                    ++k;
                }
            }
        }
        return p_185963_1_;
    }

    private float getIslandHeightValue(int p_185960_1_, int p_185960_2_, int p_185960_3_, int p_185960_4_) {
        float f = p_185960_1_ * 2 + p_185960_3_;
        float f1 = p_185960_2_ * 2 + p_185960_4_;
        float f2 = 100.0f - MathHelper.func_76129_c((float)(f * f + f1 * f1)) * 8.0f;
        if (f2 > 80.0f) {
            f2 = 80.0f;
        }
        if (f2 < -100.0f) {
            f2 = -100.0f;
        }
        for (int i = -12; i <= 12; ++i) {
            for (int j = -12; j <= 12; ++j) {
                long k = p_185960_1_ + i;
                long l = p_185960_2_ + j;
                if (!(this.islandNoise.func_151605_a((double)k, (double)l) < -0.9399999761581421)) continue;
                float f3 = (MathHelper.func_76135_e((float)k) * 3439.0f + MathHelper.func_76135_e((float)l) * 147.0f) % 13.0f + 9.0f;
                f = p_185960_3_ - i * 2;
                f1 = p_185960_4_ - j * 2;
                float f4 = 100.0f - MathHelper.func_76129_c((float)(f * f + f1 * f1)) * f3;
                if (f4 > 80.0f) {
                    f4 = 80.0f;
                }
                if (f4 < -100.0f) {
                    f4 = -100.0f;
                }
                if (!(f4 > f2)) continue;
                f2 = f4;
            }
        }
        return f2 * 2.0f;
    }

    @Override
    public Chunk func_185932_a(int x, int z) {
        this.rand.setSeed((long)x * 341873128712L + (long)z * 132897987541L);
        ChunkPrimer chunkprimer = new ChunkPrimer();
        this.prepareHeights(x, z, 0, chunkprimer);
        this.prepareHeights(x + 500, z + 500, 100, chunkprimer);
        if (this.generateStructures) {
            // empty if block
        }
        Chunk chunk = new Chunk(this.world, chunkprimer, x, z);
        Biome[] abiome = this.world.func_72959_q().func_76933_b((Biome[])null, x * 16, z * 16, 16, 16);
        byte[] abyte = chunk.func_76605_m();
        for (int i = 0; i < abyte.length; ++i) {
            abyte[i] = (byte)Biome.func_185362_a((Biome)abiome[i]);
        }
        chunk.func_177421_e(true);
        return chunk;
    }

    @Override
    public List<Biome.SpawnListEntry> func_177458_a(EnumCreatureType creatureType, BlockPos pos) {
        Biome biome = this.world.func_180494_b(pos);
        return biome.func_76747_a(creatureType);
    }

    @Override
    public boolean func_185933_a(Chunk chunkIn, int x, int z) {
        return false;
    }

    @Override
    public void func_180514_a(Chunk chunkIn, int x, int z) {
    }

    @Override
    public BlockPos func_180513_a(World worldIn, String structureName, BlockPos position, boolean findUnexplored) {
        return null;
    }

    @Override
    public boolean func_193414_a(World worldIn, String structureName, BlockPos pos) {
        return false;
    }

    @Override
    public void func_185931_b(int x, int z) {
        ForgeEventFactory.onChunkPopulate((boolean)false, (IChunkGenerator)this, (World)this.world, (Random)this.rand, (int)x, (int)z, (boolean)false);
        OreGenProperties oreGenProperties = DimensionManager.getInstance().getDimensionProperties(this.world.field_73011_w.getDimension()).getOreGenProperties(this.world);
        if (oreGenProperties != null) {
            for (OreGenProperties.OreEntry entry : oreGenProperties.getOreEntries()) {
                new CustomizableOreGen(entry).generate(this.rand, x, z, this.world, this, this.world.func_72863_F());
            }
        }
        BlockFalling.field_149832_M = false;
    }
}

