/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.util;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import net.minecraft.block.BlockTorch;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import zmaster587.advancedRocketry.AdvancedRocketry;
import zmaster587.advancedRocketry.api.AdvancedRocketryBlocks;
import zmaster587.advancedRocketry.api.AreaBlob;
import zmaster587.advancedRocketry.api.Configuration;
import zmaster587.advancedRocketry.api.util.IBlobHandler;
import zmaster587.advancedRocketry.atmosphere.AtmosphereHandler;
import zmaster587.advancedRocketry.network.PacketAirParticle;
import zmaster587.advancedRocketry.util.SealableBlockHandler;
import zmaster587.libVulpes.network.BasePacket;
import zmaster587.libVulpes.network.PacketHandler;
import zmaster587.libVulpes.util.AdjacencyGraph;
import zmaster587.libVulpes.util.HashedBlockPosition;

public class AtmosphereBlob
extends AreaBlob
implements Runnable {
    static ThreadPoolExecutor pool = (Configuration.atmosphereHandleBitMask & 1) == 1 ? new ThreadPoolExecutor(2, 16, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(32)) : null;
    boolean executing = false;
    HashedBlockPosition blockPos;
    List<AreaBlob> nearbyBlobs;

    public AtmosphereBlob(IBlobHandler blobHandler) {
        super(blobHandler);
    }

    public int getPressure() {
        return 100;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeBlock(HashedBlockPosition blockPos) {
        AdjacencyGraph adjacencyGraph = this.graph;
        synchronized (adjacencyGraph) {
            this.graph.remove((Object)blockPos);
            for (EnumFacing direction : EnumFacing.values()) {
                HashedBlockPosition newBlock = blockPos.getPositionAtOffset(direction);
                if (!this.graph.contains((Object)newBlock) || this.graph.doesPathExist((Object)newBlock, (Object)this.blobHandler.getRootPosition())) continue;
                this.runEffectOnWorldBlocks(this.blobHandler.getWorldObj(), this.graph.removeAllNodesConnectedTo((Object)newBlock));
            }
        }
    }

    @Override
    public boolean isPositionAllowed(World world, HashedBlockPosition pos, List<AreaBlob> otherBlobs) {
        for (AreaBlob blob : otherBlobs) {
            if (!blob.contains(pos) || blob == this) continue;
            return false;
        }
        return !SealableBlockHandler.INSTANCE.isBlockSealed(world, pos.getBlockPos());
    }

    @Override
    public void addBlock(HashedBlockPosition blockPos, List<AreaBlob> nearbyBlobs) {
        if (this.blobHandler.canFormBlob() && !this.contains(blockPos) && (this.graph.size() == 0 || this.contains(blockPos.getPositionAtOffset(EnumFacing.UP)) || this.contains(blockPos.getPositionAtOffset(EnumFacing.DOWN)) || this.contains(blockPos.getPositionAtOffset(EnumFacing.EAST)) || this.contains(blockPos.getPositionAtOffset(EnumFacing.WEST)) || this.contains(blockPos.getPositionAtOffset(EnumFacing.NORTH)) || this.contains(blockPos.getPositionAtOffset(EnumFacing.SOUTH))) && !this.executing) {
            this.nearbyBlobs = nearbyBlobs;
            this.blockPos = blockPos;
            this.executing = true;
            if ((Configuration.atmosphereHandleBitMask & 1) == 1) {
                try {
                    pool.execute(this);
                }
                catch (RejectedExecutionException e) {
                    AdvancedRocketry.logger.warn("Atmosphere calculation at " + this.getRootPosition() + " aborted due to oversize queue!");
                }
            } else {
                this.run();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Stack<HashedBlockPosition> stack = new Stack<HashedBlockPosition>();
        stack.push(this.blockPos);
        int maxSize = (Configuration.atmosphereHandleBitMask & 2) != 0 ? (int)(Math.pow(this.getBlobMaxRadius(), 3.0) * 4.1887903296220665) : this.getBlobMaxRadius();
        HashSet<HashedBlockPosition> addableBlocks = new HashSet<HashedBlockPosition>();
        while (!stack.isEmpty()) {
            HashedBlockPosition stackElement = (HashedBlockPosition)stack.pop();
            addableBlocks.add(stackElement);
            for (EnumFacing dir2 : EnumFacing.values()) {
                HashedBlockPosition searchNextPosition = stackElement.getPositionAtOffset(dir2);
                if (this.graph.contains((Object)searchNextPosition) || addableBlocks.contains(searchNextPosition)) continue;
                try {
                    boolean sealed;
                    boolean bl = sealed = !this.isPositionAllowed(this.blobHandler.getWorldObj(), searchNextPosition, this.nearbyBlobs);
                    if (this.blobHandler.getTraceDistance() > 0 && this.blobHandler.getWorldObj().func_82737_E() % 20L == 0L && (int)searchNextPosition.getDistance(this.getRootPosition()) == this.blobHandler.getTraceDistance()) {
                        PacketHandler.sendToNearby((BasePacket)new PacketAirParticle(searchNextPosition), (int)this.blobHandler.getWorldObj().field_73011_w.getDimension(), (BlockPos)this.blobHandler.getRootPosition().getBlockPos(), (double)128.0);
                    }
                    if (sealed) continue;
                    if ((Configuration.atmosphereHandleBitMask & 2) == 0 && searchNextPosition.getDistance(this.getRootPosition()) <= (double)maxSize || (Configuration.atmosphereHandleBitMask & 2) != 0 && addableBlocks.size() <= maxSize) {
                        stack.push(searchNextPosition);
                        addableBlocks.add(searchNextPosition);
                        continue;
                    }
                    this.clearBlob();
                    this.executing = false;
                    return;
                }
                catch (Exception e) {
                    AdvancedRocketry.logger.info("Error: AtmosphereBlob has failed to form correctly due to an error. \nCurrentBlock: " + stackElement + "\tNextPos: " + searchNextPosition + "\tDir: " + dir2 + "\tStackSize: " + stack.size());
                    e.printStackTrace();
                    this.clearBlob();
                    this.executing = false;
                    return;
                }
            }
        }
        AdjacencyGraph adjacencyGraph = this.graph;
        synchronized (adjacencyGraph) {
            for (HashedBlockPosition blockPos2 : addableBlocks) {
                super.addBlock(blockPos2, this.nearbyBlobs);
            }
        }
        this.executing = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runEffectOnWorldBlocks(World world, Collection<HashedBlockPosition> blocks) {
        if (!AtmosphereHandler.getOxygenHandler(world.field_73011_w.getDimension()).getDefaultAtmosphereType().allowsCombustion()) {
            LinkedList<HashedBlockPosition> list;
            AdjacencyGraph adjacencyGraph = this.graph;
            synchronized (adjacencyGraph) {
                list = new LinkedList<HashedBlockPosition>(blocks);
            }
            for (HashedBlockPosition pos : list) {
                IBlockState state = world.func_180495_p(pos.getBlockPos());
                if (state.func_177230_c() == Blocks.field_150478_aa) {
                    world.func_175656_a(pos.getBlockPos(), AdvancedRocketryBlocks.blockUnlitTorch.func_176223_P().func_177226_a((IProperty)BlockTorch.field_176596_a, state.func_177229_b((IProperty)BlockTorch.field_176596_a)));
                    continue;
                }
                if (!Configuration.torchBlocks.contains(state.func_177230_c())) continue;
                EntityItem item = new EntityItem(world, (double)pos.x, (double)pos.y, (double)pos.z, new ItemStack(state.func_177230_c()));
                world.func_175698_g(pos.getBlockPos());
                world.func_72838_d((Entity)item);
            }
        }
    }

    @Override
    public void clearBlob() {
        World world = this.blobHandler.getWorldObj();
        this.runEffectOnWorldBlocks(world, this.getLocations());
        super.clearBlob();
    }
}

