/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.network;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.logging.Logger;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumFacing;
import zmaster587.advancedRocketry.api.stations.ISpaceObject;
import zmaster587.advancedRocketry.dimension.DimensionManager;
import zmaster587.advancedRocketry.event.PlanetEventHandler;
import zmaster587.advancedRocketry.stations.SpaceObject;
import zmaster587.advancedRocketry.stations.SpaceObjectManager;
import zmaster587.libVulpes.network.BasePacket;

public class PacketStationUpdate
extends BasePacket {
    ISpaceObject spaceObject;
    int stationNumber;
    Type type;
    int destOrbitingBody;
    int fuel;
    double rx;
    double ry;
    double rz;
    double drx;
    double dry;
    double drz;
    float orbitalDistance;
    NBTTagCompound nbt;

    public PacketStationUpdate() {
    }

    public PacketStationUpdate(ISpaceObject dimProperties, Type type) {
        this.spaceObject = (SpaceObject)dimProperties;
        this.stationNumber = dimProperties.getId();
        this.type = type;
    }

    public void write(ByteBuf out) {
        out.writeInt(this.stationNumber);
        out.writeInt(this.type.ordinal());
        switch (this.type) {
            case DEST_ORBIT_UPDATE: {
                out.writeInt(this.spaceObject.getDestOrbitingBody());
                break;
            }
            case ORBIT_UPDATE: {
                out.writeInt(this.spaceObject.getOrbitingPlanetId());
                break;
            }
            case FUEL_UPDATE: {
                if (!(this.spaceObject instanceof SpaceObject)) break;
                out.writeInt(((SpaceObject)this.spaceObject).getFuelAmount());
                break;
            }
            case ROTANGLE_UPDATE: {
                out.writeDouble(this.spaceObject.getRotation(EnumFacing.EAST));
                out.writeDouble(this.spaceObject.getRotation(EnumFacing.UP));
                out.writeDouble(this.spaceObject.getRotation(EnumFacing.NORTH));
                out.writeDouble(this.spaceObject.getDeltaRotation(EnumFacing.EAST));
                out.writeDouble(this.spaceObject.getDeltaRotation(EnumFacing.UP));
                out.writeDouble(this.spaceObject.getDeltaRotation(EnumFacing.NORTH));
                break;
            }
            case ALTITUDE_UPDATE: {
                out.writeFloat(this.spaceObject.getOrbitalDistance());
                break;
            }
            case DIM_PROPERTY_UPDATE: {
                NBTTagCompound nbt = new NBTTagCompound();
                try {
                    this.spaceObject.getProperties().writeToNBT(nbt);
                    PacketBuffer packetBuffer = new PacketBuffer(out);
                    packetBuffer.func_150786_a(nbt);
                    break;
                }
                catch (NullPointerException e) {
                    out.writeBoolean(true);
                    Logger.getLogger("advancedRocketry").warning("Dimension " + this.stationNumber + " has thrown an exception trying to write NBT, deleting!");
                    DimensionManager.getInstance().deleteDimension(this.stationNumber);
                }
            }
        }
    }

    public void readClient(ByteBuf in) {
        this.stationNumber = in.readInt();
        this.type = Type.values()[in.readInt()];
        switch (this.type) {
            case DEST_ORBIT_UPDATE: {
                this.destOrbitingBody = in.readInt();
                break;
            }
            case ORBIT_UPDATE: {
                this.destOrbitingBody = in.readInt();
                break;
            }
            case FUEL_UPDATE: {
                this.fuel = in.readInt();
                break;
            }
            case ROTANGLE_UPDATE: {
                this.rx = in.readDouble();
                this.ry = in.readDouble();
                this.rz = in.readDouble();
                this.drx = in.readDouble();
                this.dry = in.readDouble();
                this.drz = in.readDouble();
                break;
            }
            case SIGNAL_WHITE_BURST: {
                break;
            }
            case ALTITUDE_UPDATE: {
                this.orbitalDistance = in.readFloat();
                break;
            }
            case DIM_PROPERTY_UPDATE: {
                PacketBuffer packetBuffer = new PacketBuffer(in);
                try {
                    this.nbt = packetBuffer.func_150793_b();
                    break;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    this.nbt = null;
                    return;
                }
            }
        }
    }

    public void read(ByteBuf in) {
    }

    public void executeClient(EntityPlayer thePlayer) {
        this.spaceObject = SpaceObjectManager.getSpaceManager().getSpaceStation(this.stationNumber);
        switch (this.type) {
            case DEST_ORBIT_UPDATE: {
                this.spaceObject.setDestOrbitingBody(this.destOrbitingBody);
                break;
            }
            case ORBIT_UPDATE: {
                this.spaceObject.setOrbitingBody(this.destOrbitingBody);
                break;
            }
            case FUEL_UPDATE: {
                if (!(this.spaceObject instanceof SpaceObject)) break;
                ((SpaceObject)this.spaceObject).setFuelAmount(this.fuel);
                break;
            }
            case ROTANGLE_UPDATE: {
                this.spaceObject.setRotation(this.rx, EnumFacing.EAST);
                this.spaceObject.setRotation(this.ry, EnumFacing.UP);
                this.spaceObject.setRotation(this.rz, EnumFacing.NORTH);
                this.spaceObject.setDeltaRotation(this.drx, EnumFacing.EAST);
                this.spaceObject.setDeltaRotation(this.dry, EnumFacing.UP);
                this.spaceObject.setDeltaRotation(this.drz, EnumFacing.NORTH);
                break;
            }
            case SIGNAL_WHITE_BURST: {
                PlanetEventHandler.runBurst(Minecraft.func_71410_x().field_71441_e.func_82737_E() + 20L, 20L);
                break;
            }
            case ALTITUDE_UPDATE: {
                this.spaceObject.setOrbitalDistance(this.orbitalDistance);
                break;
            }
            case DIM_PROPERTY_UPDATE: {
                if (this.nbt == null) break;
                this.spaceObject.getProperties().readFromNBT(this.nbt);
            }
        }
    }

    public void executeServer(EntityPlayerMP player) {
    }

    public static enum Type {
        DEST_ORBIT_UPDATE,
        ORBIT_UPDATE,
        SIGNAL_WHITE_BURST,
        FUEL_UPDATE,
        ROTANGLE_UPDATE,
        DIM_PROPERTY_UPDATE,
        ALTITUDE_UPDATE;

    }
}

