/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.item.components;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;
import zmaster587.advancedRocketry.AdvancedRocketry;
import zmaster587.advancedRocketry.api.AdvancedRocketryFluids;
import zmaster587.advancedRocketry.api.AdvancedRocketryItems;
import zmaster587.advancedRocketry.api.Configuration;
import zmaster587.advancedRocketry.event.RocketEventHandler;
import zmaster587.advancedRocketry.inventory.TextureResources;
import zmaster587.libVulpes.api.IArmorComponent;
import zmaster587.libVulpes.api.IJetPack;
import zmaster587.libVulpes.api.IModularArmor;
import zmaster587.libVulpes.client.ResourceIcon;
import zmaster587.libVulpes.util.FluidUtils;
import zmaster587.libVulpes.util.InputSyncHandler;

public class ItemJetpack
extends Item
implements IArmorComponent,
IJetPack {
    private ResourceLocation background = TextureResources.rocketHud;

    public void onTick(World world, EntityPlayer player, ItemStack armorStack, IInventory inv, ItemStack componentStack) {
        if (player.field_71075_bZ.field_75098_d) {
            return;
        }
        int speedUpgrades = 1;
        boolean allowsHover = false;
        ItemStack helm = player.func_184582_a(EntityEquipmentSlot.HEAD);
        if (helm != null && helm.func_77973_b() instanceof IModularArmor) {
            List helmInv = ((IModularArmor)helm.func_77973_b()).getComponents(helm);
            for (ItemStack stack : helmInv) {
                Item item;
                if (stack == null || (item = stack.func_77973_b()) != AdvancedRocketryItems.itemUpgrade) continue;
                if (stack.func_77952_i() == 0) {
                    allowsHover = true;
                    continue;
                }
                if (stack.func_77952_i() != 1) continue;
                ++speedUpgrades;
            }
        }
        MODES mode = this.getMode(componentStack);
        boolean isActive = this.isActive(componentStack, player);
        player.field_70159_w *= (double)(1.0f + (float)speedUpgrades * 0.02f);
        player.field_70179_y *= (double)(1.0f + (float)speedUpgrades * 0.02f);
        if (this.hasModeSwitched(componentStack)) {
            player.field_71075_bZ.field_75100_b = false;
        }
        if (this.isEnabled(componentStack)) {
            if (mode == MODES.HOVER) {
                if (!allowsHover) {
                    this.changeMode(componentStack, inv, player);
                }
                if (!this.hasFuel(inv)) {
                    player.field_71075_bZ.field_75100_b = false;
                } else if (InputSyncHandler.isSpaceDown((EntityPlayer)player)) {
                    this.onAccelerate(componentStack, inv, player);
                    this.setHeight(componentStack, (float)((int)player.field_70163_u) + player.field_70131_O);
                } else if ((isActive || player.func_70093_af()) && !player.field_70122_E) {
                    this.setHeight(componentStack, (float)((int)player.field_70163_u) + player.field_70131_O);
                    if (player.field_70181_x < -0.6) {
                        this.onAccelerate(componentStack, inv, player);
                    }
                } else if (player.field_70163_u < (double)this.getHeight(componentStack)) {
                    this.onAccelerate(componentStack, inv, player);
                    if (player.field_70181_x < 0.1 && player.field_70181_x > -0.1) {
                        player.field_70181_x *= 0.01;
                    }
                }
            } else if (isActive) {
                this.onAccelerate(componentStack, inv, player);
            }
        } else if (mode == MODES.HOVER && !isActive) {
            player.field_71075_bZ.field_75100_b = false;
        }
    }

    public boolean onComponentAdded(World world, ItemStack armorStack) {
        return true;
    }

    public void onComponentRemoved(World world, ItemStack armorStack) {
    }

    public void onArmorDamaged(EntityLivingBase entity, ItemStack armorStack, ItemStack componentStack, DamageSource source, int damage) {
    }

    public boolean isActive(ItemStack stack, EntityPlayer player) {
        return InputSyncHandler.isSpaceDown((EntityPlayer)player);
    }

    public boolean isEnabled(ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_74767_n("enabled");
    }

    public void setEnabledState(ItemStack stack, boolean state) {
        if (stack.func_77942_o()) {
            NBTTagCompound nbt = stack.func_77978_p();
            nbt.func_74757_a("enabled", state);
            this.flagModeSwitched(stack);
        } else if (state) {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74757_a("enabled", state);
            stack.func_77982_d(nbt);
            this.flagModeSwitched(stack);
        }
    }

    boolean hasFuel(IInventory inv) {
        boolean hasFuel = false;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack fuelTank = inv.func_70301_a(i);
            if (!FluidUtils.containsFluid((ItemStack)fuelTank, (Fluid)AdvancedRocketryFluids.fluidHydrogen)) continue;
            boolean bl = hasFuel = FluidUtils.getFluidHandler((ItemStack)fuelTank).drain(1, true) != null;
            if (hasFuel) break;
        }
        return hasFuel;
    }

    public void onAccelerate(ItemStack stack, IInventory inv, EntityPlayer player) {
        boolean hasFuel = this.hasFuel(inv);
        MODES mode = this.getMode(stack);
        if (hasFuel) {
            player.func_70024_g(0.0, (double)Configuration.jetPackThrust * (double)0.1f, 0.0);
            if (player.field_70170_p.field_72995_K) {
                double xPos = player.field_70165_t;
                double zPos = player.field_70161_v;
                float playerRot = (float)(Math.PI / 180 * (double)(player.field_70177_z - 55.0f));
                xPos = player.field_70165_t + (double)(MathHelper.func_76134_b((float)playerRot) * 0.4f);
                zPos = player.field_70161_v + (double)(MathHelper.func_76126_a((float)playerRot) * 0.4f);
                float ejectSpeed = mode == MODES.HOVER ? 0.1f : 0.3f;
                AdvancedRocketry.proxy.spawnParticle("smallRocketFlame", player.field_70170_p, xPos, player.field_70163_u + 0.75, zPos, 0.0, player.field_70181_x - (double)ejectSpeed, 0.0);
                playerRot = (float)(Math.PI / 180 * (double)(player.field_70177_z - 125.0f));
                xPos = player.field_70165_t + (double)(MathHelper.func_76134_b((float)playerRot) * 0.4f);
                zPos = player.field_70161_v + (double)(MathHelper.func_76126_a((float)playerRot) * 0.4f);
                AdvancedRocketry.proxy.spawnParticle("smallRocketFlame", player.field_70170_p, xPos, player.field_70163_u + 0.75, zPos, 0.0, player.field_70181_x - (double)ejectSpeed, 0.0);
            }
            if (player.field_70181_x > -1.0) {
                player.field_70143_R = 0.0f;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public ResourceIcon getComponentIcon(ItemStack armorStack) {
        return this.isEnabled(armorStack) ? (this.getMode(armorStack) == MODES.HOVER ? new ResourceIcon(TextureResources.jetpackIconHover) : new ResourceIcon(TextureResources.jetpackIconEnabled)) : new ResourceIcon(TextureResources.jetpackIconDisabled);
    }

    private MODES getMode(ItemStack stack) {
        if (stack.func_77942_o()) {
            return MODES.values()[stack.func_77978_p().func_74762_e("mode")];
        }
        return MODES.values()[0];
    }

    private void setHeight(ItemStack stack, float height) {
        if (stack.func_77942_o()) {
            stack.func_77978_p().func_74776_a("height", height);
        } else {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74776_a("height", height);
            stack.func_77982_d(nbt);
        }
    }

    private float getHeight(ItemStack stack) {
        if (stack.func_77942_o()) {
            return stack.func_77978_p().func_74760_g("height");
        }
        return 0.0f;
    }

    public void changeMode(ItemStack stack, IInventory modules, EntityPlayer player) {
        int mode = 0;
        ItemStack helm = player.func_184582_a(EntityEquipmentSlot.HEAD);
        if (helm != null && helm.func_77973_b() instanceof IModularArmor) {
            List helmInv = ((IModularArmor)helm.func_77973_b()).getComponents(helm);
            for (ItemStack helmStack : helmInv) {
                if (stack == null || helmStack.func_77973_b() != AdvancedRocketryItems.itemUpgrade || helmStack.func_77952_i() != 0) continue;
                mode = 1;
                break;
            }
        }
        if (stack.func_77942_o()) {
            NBTTagCompound nbt = stack.func_77978_p();
            if (mode == 1) {
                mode = nbt.func_74762_e("mode");
                if (++mode >= MODES.values().length) {
                    mode = 0;
                }
            }
            nbt.func_74768_a("mode", mode);
            this.flagModeSwitched(stack);
        } else {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74768_a("mode", mode);
            stack.func_77982_d(nbt);
            this.flagModeSwitched(stack);
        }
        if (mode == MODES.HOVER.ordinal()) {
            this.setHeight(stack, (float)player.field_70163_u + player.field_70131_O);
        }
    }

    private void flagModeSwitched(ItemStack stack) {
        if (stack.func_77942_o()) {
            NBTTagCompound nbt = stack.func_77978_p();
            nbt.func_74757_a("modeSwitch", true);
        } else {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74757_a("modeSwitch", true);
            stack.func_77982_d(nbt);
        }
    }

    private boolean hasModeSwitched(ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("modeSwitch")) {
            NBTTagCompound nbt = stack.func_77978_p();
            boolean hasSwitched = nbt.func_74767_n("modeSwitch");
            nbt.func_74757_a("modeSwitch", false);
            return hasSwitched;
        }
        return false;
    }

    public boolean isAllowedInSlot(ItemStack stack, EntityEquipmentSlot slot) {
        return slot == EntityEquipmentSlot.CHEST;
    }

    @SideOnly(value=Side.CLIENT)
    public void renderScreen(ItemStack componentStack, List<ItemStack> modules, RenderGameOverlayEvent event, Gui gui) {
        List<ItemStack> inv = modules;
        int amt = 0;
        int maxAmt = 0;
        for (int i = 0; i < inv.size(); ++i) {
            ItemStack currentStack = inv.get(i);
            if (!FluidUtils.containsFluid((ItemStack)currentStack, (Fluid)AdvancedRocketryFluids.fluidHydrogen)) continue;
            FluidStack fluidStack = FluidUtils.getFluidForItem((ItemStack)currentStack);
            if (fluidStack != null) {
                amt += fluidStack.amount;
            }
            maxAmt += FluidUtils.getFluidItemCapacity((ItemStack)currentStack);
        }
        if (maxAmt > 0) {
            float size = (float)amt / (float)maxAmt;
            Minecraft.func_71410_x().field_71446_o.func_110577_a(this.background);
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            int width = 83;
            int screenX = RocketEventHandler.hydrogenBar.getRenderX();
            int screenY = RocketEventHandler.hydrogenBar.getRenderY();
            gui.func_73729_b(screenX, screenY, 23, 34, width, 17);
            gui.func_73729_b(screenX, screenY, 23, 51, (int)((float)width * size), 17);
        }
    }

    private static enum MODES {
        NORMAL,
        HOVER;

    }
}

