/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.block;

import java.util.Random;
import net.minecraft.block.BlockMushroom;
import net.minecraft.block.IGrowable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import zmaster587.advancedRocketry.api.AdvancedRocketryBiomes;
import zmaster587.advancedRocketry.api.Configuration;
import zmaster587.advancedRocketry.entity.fx.FxSystemElectricArc;
import zmaster587.advancedRocketry.util.AudioRegistry;

public class BlockElectricMushroom
extends BlockMushroom
implements IGrowable {
    public boolean func_180671_f(World worldIn, BlockPos pos, IBlockState state) {
        state.func_177230_c().canSustainPlant(state, (IBlockAccess)worldIn, pos, EnumFacing.UP, (IPlantable)this);
        if (pos.func_177956_o() >= 0 && pos.func_177956_o() < 256) {
            IBlockState iblockstate = worldIn.func_180495_p(pos.func_177977_b());
            return iblockstate.func_177230_c().canSustainPlant(iblockstate, (IBlockAccess)worldIn, pos.func_177977_b(), EnumFacing.UP, (IPlantable)this);
        }
        return false;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return field_185505_j;
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (!world.field_72995_K && Configuration.electricPlantsSpawnLightning && world.func_72896_J() && world.func_180494_b(pos) == AdvancedRocketryBiomes.stormLandsBiome) {
            int lightningX = pos.func_177958_n() + rand.nextInt(24) - 12;
            int lightningZ = pos.func_177952_p() + rand.nextInt(24) - 12;
            BlockPos lightning = new BlockPos(lightningX, 0, lightningZ);
            lightning = world.func_175672_r(lightning);
            world.func_72942_c((Entity)new EntityLightningBolt(world, (double)lightning.func_177958_n(), (double)lightning.func_177956_o(), (double)lightning.func_177952_p(), true));
        }
    }

    public void func_176206_d(World world, BlockPos pos, IBlockState state) {
        super.func_176206_d(world, pos, state);
        if (world.field_72995_K) {
            FxSystemElectricArc.spawnArc(world, (float)pos.func_177958_n() + 0.5f, (float)pos.func_177956_o() + 0.5f, (float)pos.func_177952_p() + 0.5f, 0.3, 7);
            world.func_184134_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), new SoundEvent(new ResourceLocation("advancedrocketry:ElectricShockSmall")), SoundCategory.BLOCKS, 0.7f, 0.975f + world.field_73012_v.nextFloat() * 0.05f, false);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World world, BlockPos pos, Random rand) {
        super.func_180655_c(stateIn, world, pos, rand);
        if (world.func_82737_E() % 100L == 0L && world.func_180494_b(pos) == AdvancedRocketryBiomes.stormLandsBiome) {
            FxSystemElectricArc.spawnArc(world, (float)pos.func_177958_n() + 0.5f, (float)pos.func_177956_o() + 0.5f, (float)pos.func_177952_p() + 0.5f, 0.3, 7);
            world.func_184133_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g, pos, AudioRegistry.electricShockSmall, SoundCategory.BLOCKS, 0.7f, 0.975f + world.field_73012_v.nextFloat() * 0.05f);
        }
    }
}

