/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.randompatches.patch.client;

import com.therandomlabs.randompatches.config.RPConfig;
import com.therandomlabs.randompatches.core.Patch;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public final class EntityRendererPatch
extends Patch {
    public static final String SET_RENDER_VIEW_ENTITY = EntityRendererPatch.getName("setRenderViewEntity", "func_175607_a");
    public static final String TRANSLATE = EntityRendererPatch.getName("translate", "func_179109_b");
    public static final String EYE_HEIGHT_HANDLER = EntityRendererPatch.getName(EntityRendererPatch.class) + "$EyeHeightHandler";

    @Override
    public boolean apply(ClassNode node) {
        EntityRendererPatch.patchUpdateRenderer(EntityRendererPatch.findInstructions(node, "updateRenderer", "func_78464_a"));
        EntityRendererPatch.patchOrientCamera(EntityRendererPatch.findInstructions(node, "orientCamera", "func_78467_g"));
        return true;
    }

    private static void patchUpdateRenderer(InsnList instructions) {
        AbstractInsnNode label = null;
        for (int i = 0; i < instructions.size(); ++i) {
            AbstractInsnNode instruction = instructions.get(i);
            if (instruction.getOpcode() != 182) continue;
            MethodInsnNode method = (MethodInsnNode)instruction;
            if (!SET_RENDER_VIEW_ENTITY.equals(method.name)) continue;
            label = method.getNext();
            break;
        }
        instructions.insert(label, (AbstractInsnNode)new MethodInsnNode(184, EYE_HEIGHT_HANDLER, "updateRenderer", "()V", false));
    }

    private static void patchOrientCamera(InsnList instructions) {
        VarInsnNode getEyeHeight = null;
        for (int i = instructions.size() - 1; i >= 0; --i) {
            AbstractInsnNode instruction = instructions.get(i);
            if (instruction.getOpcode() != 184) continue;
            MethodInsnNode method = (MethodInsnNode)instruction;
            if (!TRANSLATE.equals(method.name)) continue;
            getEyeHeight = (VarInsnNode)method.getPrevious().getPrevious().getPrevious();
            break;
        }
        getEyeHeight.var = 1;
        instructions.insert(getEyeHeight, (AbstractInsnNode)new MethodInsnNode(184, EYE_HEIGHT_HANDLER, "getEyeHeight", "(F)F", false));
    }

    public static final class EyeHeightHandler {
        private static final Minecraft mc = Minecraft.func_71410_x();
        private static float lastEyeHeight;
        private static float eyeHeight;

        public static void updateRenderer() {
            lastEyeHeight = eyeHeight;
            eyeHeight += (mc.func_175606_aa().func_70047_e() - eyeHeight) * 0.5f;
        }

        public static float getEyeHeight(float partialTicks) {
            Entity entity = mc.func_175606_aa();
            if (!RPConfig.Client.smoothEyeLevelChanges) {
                return entity.func_70047_e();
            }
            float height = lastEyeHeight + (eyeHeight - lastEyeHeight) * partialTicks;
            if (entity instanceof EntityLivingBase && ((EntityLivingBase)entity).func_70608_bn()) {
                return height + 1.0f;
            }
            return height;
        }
    }
}

