/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.blocks;

import com.blakebr0.cucumber.iface.IEnableable;
import com.blakebr0.mysticalagriculture.MysticalAgriculture;
import com.blakebr0.mysticalagriculture.config.ModConfig;
import com.blakebr0.mysticalagriculture.tileentity.TileEntitySeedReprocessor;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockSeedReprocessor
extends BlockContainer
implements IEnableable {
    private Random rand = new Random();
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;

    public BlockSeedReprocessor() {
        super(Material.field_151573_f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
        this.func_149672_a(SoundType.field_185852_e);
        this.func_149711_c(8.0f);
        this.func_149663_c("ma.seed_reprocessor");
        this.setRegistryName("seed_reprocessor");
        this.setHarvestLevel("pickaxe", 1);
        this.func_149752_b(12.0f);
        this.func_149647_a(MysticalAgriculture.CREATIVE_TAB);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing heldItem, float side, float hitX, float hitY) {
        if (world.field_72995_K) {
            return true;
        }
        TileEntity tileentity = world.func_175625_s(pos);
        if (tileentity instanceof TileEntitySeedReprocessor) {
            player.openGui((Object)MysticalAgriculture.INSTANCE, 0, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
        return true;
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntitySeedReprocessor();
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        this.setDefaultFacing(world, pos, state);
    }

    private void setDefaultFacing(World world, BlockPos pos, IBlockState state) {
        if (!world.field_72995_K) {
            IBlockState iblockstate = world.func_180495_p(pos.func_177978_c());
            IBlockState iblockstate1 = world.func_180495_p(pos.func_177968_d());
            IBlockState iblockstate2 = world.func_180495_p(pos.func_177976_e());
            IBlockState iblockstate3 = world.func_180495_p(pos.func_177974_f());
            EnumFacing enumfacing = (EnumFacing)state.func_177229_b((IProperty)FACING);
            if (enumfacing == EnumFacing.NORTH && iblockstate.func_185913_b() && !iblockstate1.func_185913_b()) {
                enumfacing = EnumFacing.SOUTH;
            } else if (enumfacing == EnumFacing.SOUTH && iblockstate1.func_185913_b() && !iblockstate.func_185913_b()) {
                enumfacing = EnumFacing.NORTH;
            } else if (enumfacing == EnumFacing.WEST && iblockstate2.func_185913_b() && !iblockstate3.func_185913_b()) {
                enumfacing = EnumFacing.EAST;
            } else if (enumfacing == EnumFacing.EAST && iblockstate3.func_185913_b() && !iblockstate2.func_185913_b()) {
                enumfacing = EnumFacing.WEST;
            }
            world.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)enumfacing), 2);
        }
    }

    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d());
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World world, BlockPos pos, Random rand) {
        TileEntitySeedReprocessor compressor = (TileEntitySeedReprocessor)world.func_175625_s(pos);
        if (compressor.timeLeft()) {
            EnumFacing enumfacing = (EnumFacing)stateIn.func_177229_b((IProperty)FACING);
            double d0 = (double)pos.func_177958_n() + 0.5;
            double d1 = (double)pos.func_177956_o() + rand.nextDouble() * 6.0 / 16.0;
            double d2 = (double)pos.func_177952_p() + 0.5;
            double d3 = 0.52;
            double d4 = rand.nextDouble() * 0.6 - 0.3;
            if (rand.nextDouble() < 0.1) {
                world.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, SoundEvents.field_187652_bv, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
            }
            switch (enumfacing) {
                case WEST: {
                    world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d0 - 0.52, d1, d2 + d4, 0.0, 0.0, 0.0, new int[0]);
                    break;
                }
                case EAST: {
                    world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d0 + 0.52, d1, d2 + d4, 0.0, 0.0, 0.0, new int[0]);
                    break;
                }
                case NORTH: {
                    world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d0 + d4, d1, d2 - 0.52, 0.0, 0.0, 0.0, new int[0]);
                    break;
                }
                case SOUTH: {
                    world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d0 + d4, d1, d2 + 0.52, 0.0, 0.0, 0.0, new int[0]);
                }
            }
        }
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntitySeedReprocessor compressor = (TileEntitySeedReprocessor)world.func_175625_s(pos);
        if (compressor != null) {
            for (int i = 0; i < 2; ++i) {
                ItemStack itemstack = compressor.func_70301_a(i);
                if (itemstack.func_190926_b()) continue;
                float f = this.rand.nextFloat() * 0.8f + 0.1f;
                float f1 = this.rand.nextFloat() * 0.8f + 0.1f;
                float f2 = this.rand.nextFloat() * 0.8f + 0.1f;
                EntityItem entityitem = new EntityItem(world, (double)((float)pos.func_177958_n() + f), (double)((float)pos.func_177956_o() + f1), (double)((float)pos.func_177952_p() + f2), new ItemStack(itemstack.func_77973_b(), itemstack.func_190916_E(), itemstack.func_77952_i()));
                if (itemstack.func_77942_o()) {
                    entityitem.func_92059_d().func_77982_d(itemstack.func_77978_p().func_74737_b());
                }
                float f3 = 0.05f;
                entityitem.field_70159_w = (float)this.rand.nextGaussian() * f3;
                entityitem.field_70181_x = (float)this.rand.nextGaussian() * f3 + 0.2f;
                entityitem.field_70179_y = (float)this.rand.nextGaussian() * f3;
                world.func_72838_d((Entity)entityitem);
            }
        }
        super.func_180663_b(world, pos, state);
    }

    public boolean rotateBlock(World world, BlockPos pos, EnumFacing axis) {
        TileEntity tile = world.func_175625_s(pos);
        boolean rotate = super.rotateBlock(world, pos, axis);
        if (tile != null && rotate) {
            tile.func_145829_t();
            world.func_175690_a(pos, tile);
        }
        return rotate;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing enumfacing = EnumFacing.func_82600_a((int)meta);
        if (enumfacing.func_176740_k() == EnumFacing.Axis.Y) {
            enumfacing = EnumFacing.NORTH;
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumfacing);
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    public boolean isEnabled() {
        return ModConfig.confSeedReprocessor;
    }
}

