/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.tile;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.blay09.mods.cookingforblockheads.api.SourceItem;
import net.blay09.mods.cookingforblockheads.api.capability.CapabilityKitchenItemProvider;
import net.blay09.mods.cookingforblockheads.api.capability.DefaultKitchenItemProvider;
import net.blay09.mods.cookingforblockheads.api.capability.IKitchenItemProvider;
import net.blay09.mods.cookingforblockheads.compat.Compat;
import net.blay09.mods.cookingforblockheads.network.VanillaPacketHandler;
import net.blay09.mods.cookingforblockheads.registry.CookingRegistry;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.items.ItemHandlerHelper;

public class TileMilkJar
extends TileEntity {
    protected static final int MILK_CAPACITY = 8000;
    private final MilkJarItemProvider itemProvider = new MilkJarItemProvider(this);
    private final IFluidHandler milkFluidHandler = new IFluidHandler(){

        public IFluidTankProperties[] getTankProperties() {
            Fluid milkFluid = Compat.getMilkFluid();
            if (milkFluid != null) {
                return new IFluidTankProperties[]{new FluidTankProperties(new FluidStack(milkFluid, (int)TileMilkJar.this.milkAmount), 8000)};
            }
            return new IFluidTankProperties[0];
        }

        public int fill(FluidStack resource, boolean doFill) {
            if (resource.getFluid() == Compat.getMilkFluid()) {
                return TileMilkJar.this.fill(resource.amount, doFill);
            }
            return 0;
        }

        @Nullable
        public FluidStack drain(FluidStack resource, boolean doDrain) {
            Fluid milkFluid = Compat.getMilkFluid();
            if (milkFluid != null && resource.getFluid() == milkFluid) {
                return new FluidStack(milkFluid, TileMilkJar.this.drain(resource.amount, doDrain));
            }
            return null;
        }

        @Nullable
        public FluidStack drain(int maxDrain, boolean doDrain) {
            Fluid milkFluid = Compat.getMilkFluid();
            if (milkFluid != null) {
                return new FluidStack(milkFluid, TileMilkJar.this.drain(maxDrain, doDrain));
            }
            return null;
        }
    };
    protected float milkAmount;

    public int fill(int amount, boolean doFill) {
        int filled = (int)Math.min(8000.0f - this.milkAmount, (float)amount);
        if (doFill) {
            this.milkAmount += (float)filled;
            VanillaPacketHandler.sendTileEntityUpdate(this);
        }
        return filled;
    }

    public int drain(int amount, boolean doDrain) {
        int drained = (int)Math.min(this.milkAmount, (float)amount);
        if (doDrain) {
            this.milkAmount -= (float)drained;
            VanillaPacketHandler.sendTileEntityUpdate(this);
        }
        return drained;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        super.func_189515_b(tagCompound);
        tagCompound.func_74776_a("MilkAmount", this.milkAmount);
        return tagCompound;
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.milkAmount = tagCompound.func_74760_g("MilkAmount");
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        this.func_145839_a(pkt.func_148857_g());
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, this.func_189517_E_());
    }

    public float getMilkAmount() {
        return this.milkAmount;
    }

    public float getMilkCapacity() {
        return 8000.0f;
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityKitchenItemProvider.CAPABILITY || capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && Compat.getMilkFluid() != null || super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityKitchenItemProvider.CAPABILITY) {
            return (T)this.itemProvider;
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && Compat.getMilkFluid() != null) {
            return (T)this.milkFluidHandler;
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }

    private static class MilkJarItemProvider
    extends DefaultKitchenItemProvider {
        private final NonNullList<ItemStack> itemStacks = NonNullList.func_191196_a();
        private final TileMilkJar tileMilkJar;
        private int milkUsed;

        public MilkJarItemProvider(TileMilkJar tileMilkJar) {
            this.tileMilkJar = tileMilkJar;
            this.itemStacks.addAll(CookingRegistry.getMilkItems());
        }

        @Override
        public void resetSimulation() {
            this.milkUsed = 0;
        }

        @Override
        public int getSimulatedUseCount(int slot) {
            return this.milkUsed / 1000;
        }

        @Override
        public ItemStack useItemStack(int slot, int amount, boolean simulate, List<IKitchenItemProvider> inventories, boolean requireBucket) {
            if (this.tileMilkJar.getMilkAmount() - (float)this.milkUsed >= (float)(amount * 1000)) {
                if (requireBucket && ((ItemStack)this.itemStacks.get(slot)).func_77973_b() == Items.field_151117_aB && !CookingRegistry.consumeBucket(inventories, simulate)) {
                    return ItemStack.field_190927_a;
                }
                if (simulate) {
                    this.milkUsed += amount * 1000;
                } else {
                    this.tileMilkJar.drain(amount * 1000, true);
                }
                return ItemHandlerHelper.copyStackWithSize((ItemStack)((ItemStack)this.itemStacks.get(slot)), (int)amount);
            }
            return ItemStack.field_190927_a;
        }

        @Override
        public ItemStack returnItemStack(ItemStack itemStack, SourceItem sourceItem) {
            for (ItemStack providedStack : this.itemStacks) {
                if (!ItemHandlerHelper.canItemStacksStackRelaxed((ItemStack)itemStack, (ItemStack)providedStack)) continue;
                this.tileMilkJar.fill(1000, true);
                break;
            }
            return ItemStack.field_190927_a;
        }

        @Override
        public int getSlots() {
            return this.itemStacks.size();
        }

        @Override
        @Nonnull
        public ItemStack getStackInSlot(int slot) {
            if (this.tileMilkJar.getMilkAmount() - (float)this.milkUsed < 1000.0f) {
                return ItemStack.field_190927_a;
            }
            return (ItemStack)this.itemStacks.get(slot);
        }
    }
}

