/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.compat;

import java.util.HashMap;
import net.blay09.mods.cookingforblockheads.CookingForBlockheads;
import net.blay09.mods.cookingforblockheads.api.capability.CapabilityKitchenConnector;
import net.blay09.mods.cookingforblockheads.api.capability.CapabilityKitchenItemProvider;
import net.blay09.mods.cookingforblockheads.api.capability.KitchenItemProvider;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class CompatCapabilityLoader {
    private static final HashMap<Class<? extends TileEntity>, CapabilityType> tilesClasses = new HashMap();
    private static final CompatCapabilityLoader instance = new CompatCapabilityLoader();
    private static boolean registered = false;
    private static final ResourceLocation itemProviderResourceKey = new ResourceLocation("cookingforblockheads", CapabilityKitchenItemProvider.CAPABILITY.getName());
    private static final ResourceLocation connectorResourceKey = new ResourceLocation("cookingforblockheads", CapabilityKitchenConnector.CAPABILITY.getName());
    private static final KitchenConnectorCapabilityProvider connectorCapabilityProvider = new KitchenConnectorCapabilityProvider();
    private static final ItemStackHandler emptyItemHandler = new ItemStackHandler(0);

    public static void register() {
        if (!registered) {
            MinecraftForge.EVENT_BUS.register((Object)instance);
            registered = true;
        }
    }

    private static final void addTileEntityClass(String className, CapabilityType type) {
        try {
            Class<?> c = Class.forName(className);
            if (TileEntity.class.isAssignableFrom(c)) {
                tilesClasses.put(c, type);
                CompatCapabilityLoader.register();
            } else {
                CookingForBlockheads.logger.warn("Incompatible TileEntity class: {}", (Object)className);
            }
        }
        catch (ClassNotFoundException e) {
            CookingForBlockheads.logger.warn("TileEntity class not found: {}", (Object)className);
        }
    }

    public static void addKitchenItemProviderClass(String className) {
        CompatCapabilityLoader.addTileEntityClass(className, CapabilityType.ITEM_PROVIDER);
    }

    public static void addKitchenConnectorClass(String className) {
        CompatCapabilityLoader.addTileEntityClass(className, CapabilityType.CONNECTOR);
    }

    @SubscribeEvent
    public void tileEntity(AttachCapabilitiesEvent<TileEntity> event) {
        TileEntity entity = (TileEntity)event.getObject();
        Class<?> entityClass = entity.getClass();
        CapabilityType type = tilesClasses.get(entityClass);
        if (type == null) {
            return;
        }
        switch (type) {
            case CONNECTOR: {
                event.addCapability(connectorResourceKey, (ICapabilityProvider)connectorCapabilityProvider);
                break;
            }
            case ITEM_PROVIDER: {
                event.addCapability(itemProviderResourceKey, (ICapabilityProvider)new KitchenItemCapabilityProvider(entity));
            }
        }
    }

    private static final class KitchenItemCapabilityProvider
    implements ICapabilityProvider {
        private KitchenItemProvider kitchenProvider = null;
        private final TileEntity entity;

        public KitchenItemCapabilityProvider(TileEntity entity) {
            this.entity = entity;
        }

        public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
            return CapabilityKitchenItemProvider.CAPABILITY == capability;
        }

        public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
            if (CapabilityKitchenItemProvider.CAPABILITY != capability) {
                return null;
            }
            if (this.kitchenProvider != null) {
                return (T)this.kitchenProvider;
            }
            ItemStackHandler handler = null;
            if (this.entity.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) {
                handler = (IItemHandler)this.entity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
            }
            this.kitchenProvider = new KitchenItemProvider((IItemHandler)(handler != null ? handler : emptyItemHandler));
            return (T)this.kitchenProvider;
        }
    }

    private static final class KitchenConnectorCapabilityProvider
    implements ICapabilityProvider {
        private KitchenConnectorCapabilityProvider() {
        }

        public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
            return CapabilityKitchenConnector.CAPABILITY == capability;
        }

        public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
            return null;
        }
    }

    private static enum CapabilityType {
        CONNECTOR,
        ITEM_PROVIDER;

    }
}

