/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.doors.descriptor;

import net.malisis.core.MalisisCore;
import net.malisis.core.renderer.model.EmptyModelLoader;
import net.malisis.doors.DoorDescriptor;
import net.malisis.doors.DoorRegistry;
import net.malisis.doors.movement.RotatingDoorMovement;
import net.malisis.doors.sound.IronDoorSound;
import net.malisis.doors.sound.WoodenDoorSound;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraftforge.client.model.ModelLoader;

public class VanillaDoor
extends DoorDescriptor {
    public VanillaDoor(Type type) {
        boolean iron = type == Type.IRON;
        this.setOpeningTime(6);
        this.setMaterial(iron ? Material.field_151573_f : Material.field_151575_d);
        this.setHardness(iron ? 5.0f : 3.0f);
        this.setSoundType(iron ? SoundType.field_185852_e : SoundType.field_185848_a);
        this.setRegistryName("minecraft:" + type.registry);
        this.setUnlocalizedName(type.unlocalized);
        this.setTextureName("minecraft", type.texture);
        this.setRedstoneBehavior(iron ? DoorDescriptor.RedstoneBehavior.REDSTONE_ONLY : DoorDescriptor.RedstoneBehavior.STANDARD);
        this.setMovement(DoorRegistry.getMovement(RotatingDoorMovement.class));
        this.setSound(DoorRegistry.getSound(iron ? IronDoorSound.class : WoodenDoorSound.class));
        this.setTab(CreativeTabs.field_78028_d);
    }

    @Override
    public DoorDescriptor register() {
        super.register();
        if (MalisisCore.isClient()) {
            ModelResourceLocation mrl = new ModelResourceLocation(this.item.getRegistryName() + "-malisis", "inventory");
            EmptyModelLoader.register((Item)this.item, (ModelResourceLocation)mrl);
            ModelLoader.setCustomModelResourceLocation((Item)this.item, (int)0, (ModelResourceLocation)mrl);
        }
        return this;
    }

    public static enum Type {
        OAK("wooden_door", "doorOak", "door_wood"),
        SPRUCE("spruce_door", "doorSpruce", "door_spruce"),
        BIRCH("birch_door", "doorBirch", "door_birch"),
        JUNGLE("jungle_door", "doorJungle", "door_jungle"),
        ACACIA("acacia_door", "doorAcacia", "door_acacia"),
        DARK_OAK("dark_oak_door", "doorDarkOak", "door_dark_oak"),
        IRON("iron_door", "doorIron", "door_iron");

        private String registry;
        private String unlocalized;
        private String texture;

        private Type(String registry, String unlocalized, String texture) {
            this.registry = registry;
            this.unlocalized = unlocalized;
            this.texture = texture;
        }
    }
}

