/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.world;

import epicsquid.mysticallib.util.Util;
import epicsquid.mysticalworld.entity.EntityBeetle;
import epicsquid.mysticalworld.entity.EntityDeer;
import epicsquid.mysticalworld.entity.EntityFox;
import epicsquid.roots.entity.grove.EntityWildGrove;
import epicsquid.roots.init.ModBlocks;
import epicsquid.roots.world.StructureBase;
import java.util.Random;
import net.minecraft.block.BlockGrass;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DimensionType;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.common.IWorldGenerator;

public class WorldGenWildlandGrove
extends StructureBase
implements IWorldGenerator {
    public WorldGenWildlandGrove() {
        super(12, 12);
        this.addBlockMapping("W", Blocks.field_150355_j.func_176223_P());
        this.addBlockMapping("D", Blocks.field_150346_d.func_176223_P());
        this.addBlockMapping("G", Blocks.field_150349_c.func_176223_P());
        this.addBlockMapping("S", Blocks.field_150436_aH.func_176223_P());
        this.addBlockMapping(" ", Blocks.field_150350_a.func_176223_P());
        this.addBlockMapping("O", Blocks.field_150329_H.func_176203_a(1));
        this.addBlockMapping("A", ModBlocks.structure_marker.func_176223_P());
        this.addBlockMapping("Y", Blocks.field_150327_N.func_176223_P());
        this.addLayer(new String[]{"DDDDDDDDDDDD", "DDDDDDDDDDDD", "DDDDDDDDDDDD", "DDDDDDDDDDDD", "DDDDDDDDDDDD", "DDDDDDDDDDDD", "DDDDDDDDDDDD", "DDDDDDDDDDDD", "DDDDDDDDDDDD", "DDDDDDDDDDDD", "DDDDDDDDDDDD", "DDDDDDDDDDDD"});
        this.addLayer(new String[]{"DDDDDDDDDDDD", "DDDDDDDDDDDD", "DDDDDDDDDDDD", "DDDDDDWWDDDD", "DDDDDWWWWDDD", "DDDDWWWWWDDD", "DDDWWWWDDDDD", "DDDDWWWDDDDD", "DDDDDDDDDDDD", "DDDDDDDDDDDD", "DDDDDDDDDDDD", "DDDDDDDDDDDD"});
        this.addLayer(new String[]{"DDDDDDDDDDDD", "DDDDDDDDDDDD", "DDDDDDWWDDDD", "DDDDDWWWWDDD", "DDDDWWWWWWDD", "DDDWWWWWWWDD", "DDDWWWWWWDDD", "DDDDWWWWWDDD", "DDDDDWWWDDDD", "DDDDDDDDDDDD", "DDDDDDDDDDDD", "DDDDDDDDDDDD"});
        this.addLayer(new String[]{"GGGGGGGGGGGG", "GGGGGGWWGGGG", "GGGGWWWWWGGG", "GGGGWWWWWWGG", "GGGWWWWWWWWG", "GWWWWWWWWWWG", "GGWWWWWWWWGG", "GGGWWWWWWWGG", "GGGGWWWWWGGG", "GGGGGWWWGGGG", "GGGGGGGGGGGG", "GGGGGGGGGGGG"});
        this.addLayer(new String[]{"  OYOOOOOO  ", " YOOOOAAOOY ", "OOOSAAAAAYOO", "OYOOAAAAAAOO", "OOOAAAAAAAAS", "OAAAAAAAAAAY", "OSAAAAAAAAOO", "OOOAAAAAAAOO", "OYOOAAAAAOOO", "OOOOOAAASOOO", " OYOOOOOYYO ", "  OOOYOOOO  "});
    }

    @Override
    public void placeBlock(World world, BlockPos pos, IBlockState state) {
        super.placeBlock(world, pos, state);
        if (state.func_177230_c() == ModBlocks.structure_marker) {
            world.func_175698_g(pos);
        }
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        if (random.nextInt(10) != 0) {
            return;
        }
        if (world.field_73011_w.getDimension() == DimensionType.OVERWORLD.func_186068_a() && !world.field_72995_K) {
            int height;
            int xx = chunkX * 16 + 13 + Util.rand.nextInt(6);
            int zz = chunkZ * 16 + 13 + Util.rand.nextInt(6);
            if ((Math.abs(xx) > 500 || Math.abs(zz) > 500) && (height = world.func_189649_b(xx, zz) - 1) > 0 && world.func_180495_p(new BlockPos(xx, height, zz)).func_177230_c() instanceof BlockGrass) {
                boolean canGenerate = true;
                for (int i = -5; i < 6; ++i) {
                    for (int j = -5; j < 6; ++j) {
                        if (world.func_180495_p(new BlockPos(xx + i, height, zz + j)).func_177230_c() == Blocks.field_150349_c) continue;
                        canGenerate = false;
                    }
                }
                if (canGenerate) {
                    this.generateIn(world, xx, height - 3, zz);
                    this.spawnEntities(world, random, xx, zz, height);
                    EntityWildGrove wildGrove = new EntityWildGrove(world);
                    wildGrove.func_70107_b(xx, height + 6, zz);
                    world.func_72838_d((Entity)wildGrove);
                    for (int i = 0; i < 10; ++i) {
                        int randX = random.nextInt(10) - 5;
                        int randZ = random.nextInt(10) - 5;
                        BlockPos checkPos = new BlockPos(xx - randX, height + 1, zz - randZ);
                        BlockPos grassPos = checkPos.func_177982_a(0, -1, 0);
                        if (world.func_180495_p(checkPos).func_177230_c() != Blocks.field_150350_a && world.func_180495_p(checkPos).func_177230_c() != Blocks.field_150329_H || !world.func_180495_p(grassPos).func_177230_c().canSustainPlant(world.func_180495_p(grassPos), (IBlockAccess)world, grassPos, EnumFacing.UP, (IPlantable)((BlockSapling)Blocks.field_150345_g))) continue;
                        world.func_175656_a(checkPos, Blocks.field_150345_g.func_176223_P());
                        ((BlockSapling)Blocks.field_150345_g).func_176476_e(world, checkPos, world.func_180495_p(checkPos), random);
                    }
                }
            }
        }
    }

    private void spawnEntities(World world, Random rand, int xx, int zz, int height) {
        EntityBeetle beetle1 = new EntityBeetle(world);
        EntityDeer deer1 = new EntityDeer(world);
        EntityFox fox1 = new EntityFox(world);
        EntityBeetle beetle2 = new EntityBeetle(world);
        EntityDeer deer2 = new EntityDeer(world);
        EntityFox fox2 = new EntityFox(world);
        beetle1.func_70107_b((double)(xx + (rand.nextInt(12) - 6)), (double)(height + 1), (double)(zz + (rand.nextInt(12) - 6)));
        deer1.func_70107_b((double)(xx + (rand.nextInt(12) - 6)), (double)(height + 1), (double)(zz + (rand.nextInt(12) - 6)));
        fox1.func_70107_b((double)(xx + (rand.nextInt(12) - 6)), (double)(height + 1), (double)(zz + (rand.nextInt(12) - 6)));
        beetle2.func_70107_b((double)(xx + (rand.nextInt(12) - 6)), (double)(height + 1), (double)(zz + (rand.nextInt(12) - 6)));
        deer2.func_70107_b((double)(xx + (rand.nextInt(12) - 6)), (double)(height + 1), (double)(zz + (rand.nextInt(12) - 6)));
        fox2.func_70107_b((double)(xx + (rand.nextInt(12) - 6)), (double)(height + 1), (double)(zz + (rand.nextInt(12) - 6)));
        world.func_72838_d((Entity)beetle1);
        world.func_72838_d((Entity)deer1);
        world.func_72838_d((Entity)fox1);
        world.func_72838_d((Entity)beetle2);
        world.func_72838_d((Entity)deer2);
        world.func_72838_d((Entity)fox2);
    }
}

