/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.tileentity;

import epicsquid.mysticallib.tile.TileBase;
import epicsquid.roots.init.ModBlocks;
import epicsquid.roots.init.ModItems;
import epicsquid.roots.tileentity.TileEntityIncenseBurner;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public class TileEntityWildrootRune
extends TileBase
implements ITickable {
    private TileEntityIncenseBurner incenseBurner = null;
    private static final BlockPos[] INCENSE_POSITIONS = new BlockPos[]{new BlockPos(0, -1, 1), new BlockPos(0, -1, -1), new BlockPos(1, -1, 0), new BlockPos(-1, -1, 0)};
    public final Map<Item, PotionEffect> effectItemMap = new HashMap<Item, PotionEffect>();

    public TileEntityWildrootRune() {
        this.effectItemMap.put(ModItems.moonglow_leaf, new PotionEffect(MobEffects.field_76424_c, 2400, 1));
        this.effectItemMap.put(ModItems.spirit_herb, new PotionEffect(MobEffects.field_76439_r, 2400, 1));
        this.effectItemMap.put(ModItems.infernal_bulb, new PotionEffect(MobEffects.field_76426_n, 2400, 1));
        this.effectItemMap.put(ModItems.dewgonia, new PotionEffect(MobEffects.field_76427_o, 3600, 1));
        this.effectItemMap.put(ModItems.stalicripe, new PotionEffect(MobEffects.field_76420_g, 1200, 1));
        this.effectItemMap.put(ModItems.spirit_herb, new PotionEffect(MobEffects.field_76441_p, 2400, 1));
        this.effectItemMap.put(ModItems.cloud_berry, new PotionEffect(MobEffects.field_76430_j, 1200, 1));
        this.effectItemMap.put(ModItems.pereskia, new PotionEffect(MobEffects.field_76428_l, 200, 1));
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        return super.func_189515_b(compound);
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
    }

    public boolean activate(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull EntityPlayer player, @Nonnull EnumHand hand, @Nonnull EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack heldItem = player.func_184586_b(hand);
        if (this.incenseBurner == null) {
            return true;
        }
        if (heldItem.func_190926_b() && this.incenseBurner.isLit() && this.effectItemMap.getOrDefault(this.incenseBurner.burningItem(), null) != null) {
            player.func_70690_d(this.effectItemMap.get(this.incenseBurner.burningItem()));
        }
        return true;
    }

    public void func_73660_a() {
        block1: {
            block2: {
                if (this.field_145850_b.func_72820_D() % 20L != 0L) break block1;
                if (this.incenseBurner == null) break block2;
                if (this.incenseBurner.isLit()) break block1;
                this.incenseBurner = null;
                break block1;
            }
            for (BlockPos pos : INCENSE_POSITIONS) {
                TileEntityIncenseBurner incenseBurner;
                if (this.field_145850_b.func_180495_p(this.func_174877_v().func_177971_a((Vec3i)pos)).func_177230_c() != ModBlocks.incense_burner || (incenseBurner = (TileEntityIncenseBurner)this.field_145850_b.func_175625_s(this.func_174877_v().func_177971_a((Vec3i)pos))) == null || !incenseBurner.isLit()) continue;
                this.incenseBurner = incenseBurner;
                break;
            }
        }
    }

    public TileEntityIncenseBurner getIncenseBurner() {
        return this.incenseBurner;
    }
}

