/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.tileentity;

import epicsquid.mysticallib.tile.TileBase;
import epicsquid.mysticallib.util.Util;
import epicsquid.roots.entity.grove.EntityGrove;
import epicsquid.roots.grove.GroveType;
import epicsquid.roots.util.ItemSpawnUtil;
import epicsquid.roots.util.OfferingUtil;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileEntityOffertoryPlate
extends TileBase {
    public ItemStackHandler inventory = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            TileEntityOffertoryPlate.this.func_70296_d();
            if (!((TileEntityOffertoryPlate)TileEntityOffertoryPlate.this).field_145850_b.field_72995_K) {
                TileEntityOffertoryPlate.this.updatePacketViaState();
            }
        }
    };
    private UUID lastPlayer = null;
    private int progress = 0;

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74782_a("handler", (NBTBase)this.inventory.serializeNBT());
        tag.func_74768_a("progress", this.progress);
        if (this.lastPlayer != null) {
            tag.func_74782_a("lastPlayer", (NBTBase)NBTUtil.func_186862_a((UUID)this.lastPlayer));
        }
        return tag;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        if (tag.func_74764_b("lastPlayer")) {
            this.lastPlayer = NBTUtil.func_186860_b((NBTTagCompound)tag.func_74775_l("lastPlayer"));
        }
        this.inventory.deserializeNBT(tag.func_74775_l("handler"));
        this.progress = tag.func_74762_e("progress");
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public boolean activate(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull EntityPlayer player, @Nonnull EnumHand hand, @Nonnull EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack toInsert;
        ItemStack attemptedInsert;
        ItemStack heldItem = player.func_184586_b(hand);
        this.lastPlayer = player.func_110124_au();
        this.func_70296_d();
        if (!heldItem.func_190926_b() && this.inventory.getStackInSlot(0).func_190926_b() && (attemptedInsert = this.inventory.insertItem(0, toInsert = heldItem.func_77946_l(), true)).func_190926_b()) {
            List groveList;
            this.inventory.insertItem(0, toInsert, false);
            player.func_184586_b(hand).func_190918_g(toInsert.func_190916_E());
            if (player.func_184586_b(hand).func_190916_E() == 0) {
                player.func_184611_a(hand, ItemStack.field_190927_a);
            }
            if ((groveList = Util.getEntitiesWithinRadius((World)world, EntityGrove.class, (BlockPos)this.func_174877_v(), (float)10.0f, (float)10.0f, (float)10.0f)).size() > 0) {
                GroveType type = OfferingUtil.getGroveType(this.inventory.getStackInSlot(0));
                EntityGrove grove = null;
                for (EntityGrove entityGrove : groveList) {
                    if (entityGrove.getType() != type) continue;
                    grove = entityGrove;
                    break;
                }
                if (grove != null) {
                    grove.addActiveOffering(this);
                }
            }
            if (!world.field_72995_K) {
                this.updatePacketViaState();
            }
            return true;
        }
        if (heldItem.func_190926_b() && !world.field_72995_K && hand == EnumHand.MAIN_HAND && !this.inventory.getStackInSlot(0).func_190926_b()) {
            ItemStack extracted = this.inventory.extractItem(0, this.inventory.getStackInSlot(0).func_190916_E(), false);
            ItemSpawnUtil.spawnItem(world, this.func_174877_v(), extracted);
            if (!world.field_72995_K) {
                this.updatePacketViaState();
            }
            return true;
        }
        return false;
    }

    public ItemStack getHeldItem() {
        return this.inventory.getStackInSlot(0);
    }

    public void removeItem() {
        ItemStack stack = this.inventory.getStackInSlot(0);
        stack.func_190920_e(stack.func_190916_E() - 1);
        if (stack.func_190916_E() == 0) {
            this.inventory.setStackInSlot(0, ItemStack.field_190927_a);
        } else {
            this.inventory.setStackInSlot(0, stack);
        }
    }

    public void breakBlock(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        if (!world.field_72995_K) {
            Util.spawnInventoryInWorld((World)world, (double)((double)this.func_174877_v().func_177958_n() + 0.5), (double)((double)this.func_174877_v().func_177956_o() + 0.5), (double)((double)this.func_174877_v().func_177952_p() + 0.5), (IItemHandler)this.inventory);
        }
    }

    public UUID getLastPlayer() {
        return this.lastPlayer;
    }
}

