/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.tileentity;

import epicsquid.mysticallib.tile.TileBase;
import epicsquid.mysticallib.util.Util;
import epicsquid.roots.api.Herb;
import epicsquid.roots.init.HerbRegistry;
import epicsquid.roots.util.ItemSpawnUtil;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileEntityIncenseBurner
extends TileBase
implements ITickable {
    public static final int BURN_TICKS = 1200;
    public ItemStackHandler inventory = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            TileEntityIncenseBurner.this.func_70296_d();
            if (!((TileEntityIncenseBurner)TileEntityIncenseBurner.this).field_145850_b.field_72995_K) {
                TileEntityIncenseBurner.this.updatePacketViaState();
            }
        }
    };
    private int burnTick = 0;
    private boolean lit = false;

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74768_a("burnTick", this.burnTick);
        compound.func_74757_a("lit", this.lit);
        compound.func_74782_a("handler", (NBTBase)this.inventory.serializeNBT());
        return super.func_189515_b(compound);
    }

    public void func_145839_a(NBTTagCompound compound) {
        this.burnTick = compound.func_74762_e("burnTick");
        this.lit = compound.func_74767_n("lit");
        this.inventory.deserializeNBT(compound.func_74775_l("handler"));
        super.func_145839_a(compound);
    }

    public boolean activate(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull EntityPlayer player, @Nonnull EnumHand hand, @Nonnull EnumFacing side, float hitX, float hitY, float hitZ) {
        if (hand != EnumHand.MAIN_HAND) {
            return false;
        }
        ItemStack stack = player.func_184586_b(hand);
        ItemStack inventoryStack = this.inventory.getStackInSlot(0);
        if (stack.func_190926_b()) {
            if (this.lit) {
                this.lit = false;
                this.func_70296_d();
                if (!world.field_72995_K) {
                    this.updatePacketViaState();
                }
                return false;
            }
            ItemStack extracted = this.inventory.extractItem(0, this.inventory.getStackInSlot(0).func_190916_E(), false);
            if (!world.field_72995_K) {
                ItemSpawnUtil.spawnItem(world, this.func_174877_v(), extracted);
                this.updatePacketViaState();
            }
            return false;
        }
        if (stack.func_77973_b() == Items.field_151033_d && !inventoryStack.func_190926_b()) {
            this.lit = true;
            this.func_70296_d();
            if (!world.field_72995_K) {
                this.updatePacketViaState();
            }
            return false;
        }
        if (!this.isHerb(stack)) {
            return false;
        }
        if (!inventoryStack.func_190926_b()) {
            if (inventoryStack.func_77973_b() == stack.func_77973_b()) {
                int remainingHerbs = 64 - inventoryStack.func_190916_E();
                if (stack.func_190916_E() <= remainingHerbs) {
                    inventoryStack.func_190920_e(inventoryStack.func_190916_E() + stack.func_190916_E());
                    player.func_184611_a(hand, ItemStack.field_190927_a);
                } else {
                    inventoryStack.func_190920_e(inventoryStack.func_190916_E() + remainingHerbs);
                    stack.func_190920_e(stack.func_190916_E() - remainingHerbs);
                }
            }
        } else {
            this.inventory.insertItem(0, stack, false);
            player.func_184611_a(hand, ItemStack.field_190927_a);
        }
        this.func_70296_d();
        if (!world.field_72995_K) {
            this.updatePacketViaState();
        }
        return false;
    }

    private boolean isHerb(@Nonnull ItemStack stack) {
        for (Herb herb : HerbRegistry.REGISTRY.getValuesCollection()) {
            if (stack.func_77973_b() != herb.getItem()) continue;
            return true;
        }
        return false;
    }

    public void func_73660_a() {
        if (this.lit) {
            double d3 = (double)this.field_174879_c.func_177958_n() + 0.5 + Util.rand.nextDouble() * (double)0.1f;
            double d8 = (double)this.field_174879_c.func_177956_o() + 0.6;
            double d13 = (double)this.field_174879_c.func_177952_p() + 0.5;
            this.field_145850_b.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d3, d8, d13, 0.0, 0.0, 0.0, new int[0]);
            ++this.burnTick;
            if (this.burnTick >= 1200) {
                this.inventory.extractItem(0, 1, false);
                this.burnTick = 0;
                if (this.inventory.getStackInSlot(0).func_190926_b()) {
                    this.lit = false;
                }
                this.func_70296_d();
                if (!this.field_145850_b.field_72995_K) {
                    this.updatePacketViaState();
                }
            }
        }
    }

    public void breakBlock(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        if (!world.field_72995_K) {
            Util.spawnInventoryInWorld((World)world, (double)((double)this.func_174877_v().func_177958_n() + 0.5), (double)((double)this.func_174877_v().func_177956_o() + 0.5), (double)((double)this.func_174877_v().func_177952_p() + 0.5), (IItemHandler)this.inventory);
        }
    }

    public boolean isLit() {
        return this.lit;
    }

    public Item burningItem() {
        if (this.lit) {
            return this.inventory.getStackInSlot(0).func_77973_b();
        }
        return null;
    }
}

