/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.spell;

import epicsquid.mysticallib.network.PacketHandler;
import epicsquid.mysticallib.util.Util;
import epicsquid.roots.init.HerbRegistry;
import epicsquid.roots.init.ModItems;
import epicsquid.roots.network.fx.MessageRampantLifeInfusionFX;
import epicsquid.roots.spell.SpellBase;
import epicsquid.roots.spell.modules.SpellModule;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.BlockNetherWart;
import net.minecraft.block.IGrowable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class SpellRampantGrowth
extends SpellBase {
    public static String spellName = "spell_rampant_growth";
    public static SpellRampantGrowth instance = new SpellRampantGrowth(spellName);
    private static List<Block> skips = Arrays.asList(Blocks.field_150349_c, Blocks.field_150329_H, Blocks.field_150398_cm);

    public SpellRampantGrowth(String name) {
        super(name, TextFormatting.DARK_AQUA, 0.8784314f, 0.5294118f, 0.15686275f, 0.18039216f, 0.36862746f, 0.3647059f);
        this.castType = SpellBase.EnumCastType.CONTINUOUS;
        this.cooldown = 0;
        this.addCost(HerbRegistry.getHerbByName("spirit_herb"), 0.65f);
        this.addCost(HerbRegistry.getHerbByName("pereskia"), 0.45f);
        this.addIngredients(new ItemStack(Blocks.field_150345_g, 1, 5), new ItemStack(Items.field_151153_ao), new ItemStack(Blocks.field_150345_g, 1, 4), new ItemStack(ModItems.spirit_herb), new ItemStack(ModItems.pereskia));
    }

    @Override
    public boolean cast(EntityPlayer player, List<SpellModule> modules) {
        List positions = Util.getBlocksWithinRadius((World)player.field_70170_p, (BlockPos)player.func_180425_c(), (float)6.0f, (float)3.0f, (float)6.0f, pos -> {
            IBlockState state = player.field_70170_p.func_180495_p(pos);
            if (state.func_177230_c() instanceof IGrowable) {
                Block block = state.func_177230_c();
                if (skips.contains(block)) {
                    return false;
                }
                if (state.func_177230_c() instanceof BlockFlower) {
                    return false;
                }
                return ((IGrowable)state.func_177230_c()).func_176473_a(player.field_70170_p, pos, state, false);
            }
            if (state.func_177230_c() == Blocks.field_150388_bm) {
                return (Integer)state.func_177229_b((IProperty)BlockNetherWart.field_176486_a) < 3;
            }
            return false;
        });
        if (positions.isEmpty()) {
            return false;
        }
        if (!player.field_70170_p.field_72995_K) {
            for (int i = 0; i < 2 + player.field_70170_p.field_73012_v.nextInt(4); ++i) {
                BlockPos pos2 = (BlockPos)positions.get(player.field_70170_p.field_73012_v.nextInt(positions.size()));
                IBlockState state = player.field_70170_p.func_180495_p(pos2);
                for (int j = 0; j < 3; ++j) {
                    state.func_177230_c().func_180645_a(player.field_70170_p, pos2, state, new Random());
                }
                if (player.field_70170_p.field_73012_v.nextInt(3) != 0) continue;
                PacketHandler.sendToAllTracking((IMessage)new MessageRampantLifeInfusionFX(pos2.func_177958_n(), pos2.func_177956_o(), pos2.func_177952_p()), (Entity)player);
            }
        }
        return true;
    }
}

