/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.spell;

import epicsquid.mysticallib.network.PacketHandler;
import epicsquid.mysticallib.util.Util;
import epicsquid.roots.init.HerbRegistry;
import epicsquid.roots.init.ModItems;
import epicsquid.roots.network.fx.MessageHarvestCompleteFX;
import epicsquid.roots.spell.SpellBase;
import epicsquid.roots.spell.modules.SpellModule;
import epicsquid.roots.util.ItemSpawnUtil;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.lang.reflect.Method;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBeetroot;
import net.minecraft.block.BlockCocoa;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.BlockNetherWart;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class SpellHarvest
extends SpellBase {
    public static String spellName = "spell_harvest";
    public static SpellHarvest instance = new SpellHarvest(spellName);
    private static Method getSeed;
    public Deque<HarvestEntry> queue;
    public static HashMap<Block, ItemStack> seedCache;
    public HashMap<Block, IProperty<Integer>> propertyMap;
    private static List<Block> skipBlocks;
    private static Map<IProperty<Integer>, Integer> stateMax;

    public SpellHarvest(String name) {
        super(name, TextFormatting.GREEN, 0.22352941f, 0.99215686f, 0.10980392f, 0.77254903f, 0.9137255f, 0.10980392f);
        getSeed = ReflectionHelper.findMethod(BlockCrops.class, (String)"getSeed", (String)"func_149866_i", (Class[])new Class[0]);
        this.queue = new ArrayDeque<HarvestEntry>();
        this.propertyMap = new HashMap();
        this.castType = SpellBase.EnumCastType.INSTANTANEOUS;
        this.cooldown = 25;
        this.addCost(HerbRegistry.getHerbByName("wildewheet"), 0.55f);
        this.addIngredients(new ItemStack(Items.field_151013_M), new ItemStack(ModItems.spirit_herb), new ItemStack(ModItems.wildewheet), new ItemStack(ModItems.terra_moss), new ItemStack(Items.field_151014_N));
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.propertyMap.put(Blocks.field_185773_cZ, (IProperty<Integer>)BlockBeetroot.field_185531_a);
        this.propertyMap.put(Blocks.field_150375_by, (IProperty<Integer>)BlockCocoa.field_176501_a);
        this.propertyMap.put(Blocks.field_150388_bm, (IProperty<Integer>)BlockNetherWart.field_176486_a);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onHarvestDrops(BlockEvent.HarvestDropsEvent event) {
        HarvestEntry me;
        if (this.queue.peek() == null) {
            return;
        }
        HarvestEntry ref = this.queue.pop();
        if (!ref.equals(me = new HarvestEntry(null, event.getWorld().field_73011_w.getDimension(), event.getPos(), event.getState()))) {
            return;
        }
        ItemStack seed = ref.getSeed();
        List drops = event.getDrops();
        ListIterator dropIter = drops.listIterator();
        while (dropIter.hasNext()) {
            ItemStack copy = ((ItemStack)dropIter.next()).func_77946_l();
            copy.func_190920_e(1);
            if (ItemStack.func_77989_b((ItemStack)copy, (ItemStack)seed)) {
                dropIter.remove();
                break;
            }
            if (!(copy.func_77973_b() instanceof IPlantable)) continue;
            dropIter.remove();
            break;
        }
    }

    @Override
    public boolean cast(EntityPlayer player, List<SpellModule> modules) {
        Object state;
        ArrayList<BlockPos> affectedPositions = new ArrayList<BlockPos>();
        ArrayList pumpkinsAndMelons = new ArrayList();
        ArrayList reedsAndCactus = new ArrayList();
        List crops = Util.getBlocksWithinRadius((World)player.field_70170_p, (BlockPos)player.func_180425_c(), (float)6.0f, (float)5.0f, (float)6.0f, pos -> {
            if (player.field_70170_p.func_175623_d(pos)) {
                return false;
            }
            IBlockState state = player.field_70170_p.func_180495_p(pos);
            Block block = state.func_177230_c();
            if (skipBlocks.contains(block)) {
                return false;
            }
            if (block.getRegistryName() != null && block.getRegistryName().func_110624_b().equals("rustic")) {
                return false;
            }
            if (state.func_177230_c() == Blocks.field_150423_aK || state.func_177230_c() == Blocks.field_150440_ba) {
                pumpkinsAndMelons.add(pos);
                return false;
            }
            if (state.func_177230_c() == Blocks.field_150436_aH || state.func_177230_c() == Blocks.field_150434_aF) {
                reedsAndCactus.add(pos);
                return false;
            }
            for (IProperty prop : state.func_177227_a()) {
                if (!prop.func_177701_a().equals("age") && !prop.func_177701_a().equals("growth") || prop.func_177699_b() != Integer.class) continue;
                int max = stateMax.getOrDefault(prop, -1);
                if (max == -1) {
                    max = (Integer)Collections.max(prop.func_177700_c());
                    stateMax.put((IProperty<Integer>)prop, max);
                }
                if ((Integer)state.func_177229_b(prop) != max) continue;
                return true;
            }
            return false;
        });
        int count = 0;
        for (BlockPos pos2 : crops) {
            state = player.field_70170_p.func_180495_p(pos2);
            ItemStack seed = this.getSeed((IBlockState)state);
            IProperty<Integer> prop = null;
            for (IProperty<Integer> entry : stateMax.keySet()) {
                if (!state.func_177227_a().contains(entry)) continue;
                prop = entry;
            }
            assert (prop != null);
            if (!player.field_70170_p.field_72995_K) {
                IBlockState newState = state.func_177226_a(prop, (Comparable)Integer.valueOf(0));
                NonNullList drops = NonNullList.func_191196_a();
                this.queue.push(new HarvestEntry(seed, player.field_71093_bK, pos2, (IBlockState)state));
                state.func_177230_c().getDrops(drops, (IBlockAccess)player.field_70170_p, pos2, (IBlockState)state, 0);
                ForgeEventFactory.fireBlockHarvesting((List)drops, (World)player.field_70170_p, (BlockPos)pos2, (IBlockState)state, (int)0, (float)1.0f, (boolean)false, (EntityPlayer)player);
                player.field_70170_p.func_175656_a(pos2, newState);
                for (ItemStack stack : drops) {
                    if (stack.func_190926_b()) continue;
                    ItemSpawnUtil.spawnItem(player.field_70170_p, pos2, stack);
                }
                affectedPositions.add(pos2);
            }
            ++count;
        }
        for (BlockPos pos2 : pumpkinsAndMelons) {
            ++count;
            if (player.field_70170_p.field_72995_K) continue;
            state = player.field_70170_p.func_180495_p(pos2);
            player.field_70170_p.func_175656_a(pos2, Blocks.field_150350_a.func_176223_P());
            state.func_177230_c().func_180657_a(player.field_70170_p, player, pos2, (IBlockState)state, null, player.func_184614_ca());
            affectedPositions.add(pos2);
        }
        HashSet<BlockPos> done = new HashSet<BlockPos>();
        ArrayList<BlockPos> lowest = new ArrayList<BlockPos>();
        for (BlockPos pos3 : reedsAndCactus) {
            if (done.contains(pos3)) continue;
            BlockPos down = pos3.func_177977_b();
            IBlockState downState = player.field_70170_p.func_180495_p(down);
            while (downState.func_177230_c() == Blocks.field_150434_aF || downState.func_177230_c() == Blocks.field_150436_aH) {
                done.add(down);
                down = down.func_177977_b();
                downState = player.field_70170_p.func_180495_p(down);
            }
            lowest.add(down.func_177984_a());
            done.add(pos3);
        }
        for (BlockPos pos3 : lowest) {
            IBlockState state2 = player.field_70170_p.func_180495_p(pos3.func_177984_a());
            if (state2.func_177230_c() != Blocks.field_150434_aF && state2.func_177230_c() != Blocks.field_150436_aH) continue;
            ++count;
            if (player.field_70170_p.field_72995_K) continue;
            state2.func_177230_c().func_180657_a(player.field_70170_p, player, pos3.func_177984_a(), state2, null, player.func_184614_ca());
            player.field_70170_p.func_175656_a(pos3.func_177984_a(), Blocks.field_150350_a.func_176223_P());
            affectedPositions.add(pos3);
        }
        if (!affectedPositions.isEmpty() && !player.field_70170_p.field_72995_K) {
            MessageHarvestCompleteFX message = new MessageHarvestCompleteFX(affectedPositions);
            PacketHandler.sendToAllTracking((IMessage)message, (Entity)player);
        }
        return count != 0;
    }

    public ItemStack getSeed(IBlockState state) {
        Block block = state.func_177230_c();
        ItemStack seed = seedCache.get(block);
        if (seed != null) {
            return seed;
        }
        try {
            seed = new ItemStack((Item)getSeed.invoke((Object)state.func_177230_c(), new Object[0]));
        }
        catch (Exception e) {
            seed = ItemStack.field_190927_a;
        }
        seedCache.put(state.func_177230_c(), seed);
        return seed;
    }

    static {
        seedCache = new HashMap();
        seedCache.put(Blocks.field_150388_bm, new ItemStack(Items.field_151075_bm));
        skipBlocks = Arrays.asList(Blocks.field_150357_h, Blocks.field_150349_c, Blocks.field_150346_d, Blocks.field_150348_b, Blocks.field_150329_H, Blocks.field_150355_j, Blocks.field_150353_l, Blocks.field_150398_cm, Blocks.field_150394_bc, Blocks.field_150393_bb);
        stateMax = new Object2IntOpenHashMap();
    }

    private class HarvestEntry {
        private ItemStack seed;
        private int dimension;
        private BlockPos position;
        private IBlockState block;

        public HarvestEntry(ItemStack seed, int dimension, BlockPos position, IBlockState block) {
            this.seed = seed;
            this.dimension = dimension;
            this.position = position;
            this.block = block;
        }

        public ItemStack getSeed() {
            return this.seed;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            HarvestEntry that = (HarvestEntry)o;
            return this.dimension == that.dimension && Objects.equals(this.position, that.position) && Objects.equals(this.block, that.block);
        }

        public int hashCode() {
            return Objects.hash(this.seed, this.dimension, this.position, this.block);
        }
    }
}

