/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.network.fx;

import epicsquid.roots.particle.ParticleUtil;
import io.netty.buffer.ByteBuf;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ElementalSoilTransformFX
implements IMessage {
    private static Random random = new Random();
    private double x;
    private double y;
    private double z;
    private int elementId;

    public ElementalSoilTransformFX() {
    }

    public ElementalSoilTransformFX(double x, double y, double z, int elementId) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.elementId = elementId;
    }

    public void fromBytes(ByteBuf byteBuf) {
        this.x = byteBuf.readDouble();
        this.y = byteBuf.readDouble();
        this.z = byteBuf.readDouble();
        this.elementId = byteBuf.readInt();
    }

    public void toBytes(ByteBuf byteBuf) {
        byteBuf.writeDouble(this.x);
        byteBuf.writeDouble(this.y);
        byteBuf.writeDouble(this.z);
        byteBuf.writeInt(this.elementId);
    }

    public static int[] getColor(int elementId) {
        int b;
        int g;
        int r;
        switch (elementId) {
            case 0: {
                r = 196;
                g = 90;
                b = 13;
                break;
            }
            case 1: {
                r = 43;
                g = 159;
                b = 206;
                break;
            }
            case 2: {
                r = 164;
                g = 196;
                b = 203;
                break;
            }
            case 3: {
                r = 81;
                g = 55;
                b = 8;
                break;
            }
            default: {
                r = 0;
                g = 0;
                b = 0;
            }
        }
        return new int[]{r, g, b};
    }

    public static class Handler
    implements IMessageHandler<ElementalSoilTransformFX, IMessage> {
        @SideOnly(value=Side.CLIENT)
        public IMessage onMessage(ElementalSoilTransformFX message, MessageContext ctx) {
            WorldClient world = Minecraft.func_71410_x().field_71441_e;
            int[] color = ElementalSoilTransformFX.getColor(message.elementId);
            for (int k = 0; k < 10; ++k) {
                if (random.nextBoolean()) {
                    ParticleUtil.spawnParticleGlow((World)world, (float)message.x, (float)message.y + 0.5f, (float)message.z, 0.125f * (random.nextFloat() - 0.5f), 0.125f * (random.nextFloat() - 0.5f), 0.125f * (random.nextFloat() - 0.5f), color[0], color[1], color[2], 0.75f, 9.0f, 30);
                    continue;
                }
                ParticleUtil.spawnParticleGlow((World)world, (float)message.x, (float)message.y + 0.5f, (float)message.z, 0.125f * (random.nextFloat() - 0.5f), 0.125f * (random.nextFloat() - 0.5f), 0.125f * (random.nextFloat() - 0.5f), color[0], color[1], color[2], 0.75f, 9.0f, 30);
            }
            return null;
        }
    }
}

