/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.network;

import epicsquid.roots.capability.playerdata.PlayerDataCapability;
import epicsquid.roots.capability.playerdata.PlayerDataCapabilityProvider;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MessagePlayerDataUpdate
implements IMessage {
    private UUID id = null;
    private NBTTagCompound tag = new NBTTagCompound();

    public MessagePlayerDataUpdate() {
    }

    public MessagePlayerDataUpdate(UUID id, NBTTagCompound tag) {
        this.tag = tag;
        this.id = id;
    }

    public void fromBytes(ByteBuf buf) {
        this.id = new UUID(buf.readLong(), buf.readLong());
        this.tag = ByteBufUtils.readTag((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeLong(this.id.getMostSignificantBits());
        buf.writeLong(this.id.getLeastSignificantBits());
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.tag);
    }

    public static class MessageHolder
    implements IMessageHandler<MessagePlayerDataUpdate, IMessage> {
        @SideOnly(value=Side.CLIENT)
        public IMessage onMessage(MessagePlayerDataUpdate message, MessageContext ctx) {
            EntityPlayer player;
            WorldClient w;
            if (message != null && (w = Minecraft.func_71410_x().field_71441_e) != null && w.func_152378_a(message.id) != null && (player = w.func_152378_a(message.id)) != null && player.hasCapability(PlayerDataCapabilityProvider.PLAYER_DATA_CAPABILITY, null)) {
                ((PlayerDataCapability)player.getCapability(PlayerDataCapabilityProvider.PLAYER_DATA_CAPABILITY, null)).setData(message.tag);
            }
            return null;
        }
    }
}

