/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.item.itemblock;

import epicsquid.mysticallib.network.PacketHandler;
import epicsquid.roots.config.ElementalSoilConfig;
import epicsquid.roots.init.ModBlocks;
import epicsquid.roots.network.fx.ElementalSoilTransformFX;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFarmland;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class ItemBlockElementalSoil
extends ItemBlock {
    public ItemBlockElementalSoil(Block block) {
        super(block);
    }

    public boolean placeBlockAt(@Nonnull ItemStack stack, @Nonnull EntityPlayer player, World world, @Nonnull BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, @Nonnull IBlockState newState) {
        Block oldblock = world.func_180495_p(pos.func_177972_a(side.func_176734_d())).func_177230_c();
        if (oldblock instanceof BlockFarmland && player.field_71071_by.func_70441_a(new ItemStack(oldblock))) {
            pos = pos.func_177972_a(side.func_176734_d());
        }
        return super.placeBlockAt(stack, player, world, pos, side, hitX, hitY, hitZ, newState);
    }

    public boolean onEntityItemUpdate(EntityItem entityItem) {
        if (this.field_150939_a == ModBlocks.elemental_soil) {
            World world = entityItem.field_70170_p;
            if (!world.field_72995_K) {
                int count = entityItem.func_92059_d().func_190916_E();
                if (entityItem.func_180799_ab()) {
                    world.func_72838_d((Entity)new EntityItem(world, entityItem.field_70165_t, entityItem.field_70163_u + 0.5, entityItem.field_70161_v, new ItemStack(ModBlocks.elemental_soil_fire, count)));
                    PacketHandler.sendToAllTracking((IMessage)new ElementalSoilTransformFX(entityItem.field_70165_t, entityItem.field_70163_u, entityItem.field_70161_v, 0), (Entity)entityItem);
                    entityItem.func_70106_y();
                    return true;
                }
                if (entityItem.func_70090_H() && entityItem.field_70173_aa >= ElementalSoilConfig.WaterSoilDelay) {
                    world.func_72838_d((Entity)new EntityItem(world, entityItem.field_70165_t, entityItem.field_70163_u, entityItem.field_70161_v, new ItemStack(ModBlocks.elemental_soil_water, count)));
                    PacketHandler.sendToAllTracking((IMessage)new ElementalSoilTransformFX(entityItem.field_70165_t, entityItem.field_70163_u, entityItem.field_70161_v, 1), (Entity)entityItem);
                    entityItem.func_70106_y();
                    return true;
                }
                if (entityItem.field_70163_u <= (double)ElementalSoilConfig.EarthSoilMaxY && entityItem.field_70173_aa >= ElementalSoilConfig.EarthSoilDelay) {
                    BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(entityItem.func_180425_c());
                    boolean found_roof = false;
                    for (int i = pos.func_177956_o(); i < Math.min(ElementalSoilConfig.EarthSoilMaxY + 20, world.func_175726_f((BlockPos)pos).func_177433_f((BlockPos)pos)); ++i) {
                        pos.func_185336_p(i);
                        if (world.func_175623_d((BlockPos)pos)) continue;
                        found_roof = true;
                    }
                    if (!found_roof) {
                        return super.onEntityItemUpdate(entityItem);
                    }
                    world.func_72838_d((Entity)new EntityItem(world, entityItem.field_70165_t, entityItem.field_70163_u, entityItem.field_70161_v, new ItemStack(ModBlocks.elemental_soil_earth, count)));
                    PacketHandler.sendToAllTracking((IMessage)new ElementalSoilTransformFX(entityItem.field_70165_t, entityItem.field_70163_u, entityItem.field_70161_v, 3), (Entity)entityItem);
                    entityItem.func_70106_y();
                    return true;
                }
                if (entityItem.field_70163_u >= (double)ElementalSoilConfig.AirSoilMinY && entityItem.field_70173_aa >= ElementalSoilConfig.AirSoilDelay) {
                    BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(entityItem.func_180425_c());
                    int height = world.func_175726_f((BlockPos)pos).func_177433_f((BlockPos)pos);
                    if (pos.func_177956_o() < height) {
                        return super.onEntityItemUpdate(entityItem);
                    }
                    world.func_72838_d((Entity)new EntityItem(world, entityItem.field_70165_t, entityItem.field_70163_u, entityItem.field_70161_v, new ItemStack(ModBlocks.elemental_soil_air, count)));
                    PacketHandler.sendToAllTracking((IMessage)new ElementalSoilTransformFX(entityItem.field_70165_t, entityItem.field_70163_u, entityItem.field_70161_v, 2), (Entity)entityItem);
                    entityItem.func_70106_y();
                    return true;
                }
            }
        }
        return super.onEntityItemUpdate(entityItem);
    }
}

