/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.item;

import epicsquid.mysticallib.item.ItemBase;
import epicsquid.mysticallib.network.PacketHandler;
import epicsquid.mysticallib.particle.particles.ParticleGlitter;
import epicsquid.mysticallib.proxy.ClientProxy;
import epicsquid.mysticallib.util.Util;
import epicsquid.roots.capability.runic_shears.RunicShearsCapability;
import epicsquid.roots.capability.runic_shears.RunicShearsCapabilityProvider;
import epicsquid.roots.config.GeneralConfig;
import epicsquid.roots.init.ModRecipes;
import epicsquid.roots.network.fx.MessageRunicShearsFX;
import epicsquid.roots.recipe.RunicShearRecipe;
import epicsquid.roots.util.ItemSpawnUtil;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class ItemRunicShears
extends ItemBase {
    private Random random;

    public ItemRunicShears(@Nonnull String name) {
        super(name);
        this.func_77656_e(357);
        this.func_77625_d(1);
        this.func_77627_a(false);
        this.random = new Random();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nonnull
    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        Block block = world.func_180495_p(pos).func_177230_c();
        RunicShearRecipe recipe = ModRecipes.getRunicShearRecipe(block);
        if (recipe == null) return EnumActionResult.SUCCESS;
        if (!world.field_72995_K) {
            if (block instanceof BlockCrops) {
                if (!((BlockCrops)block).func_185525_y(world.func_180495_p(pos))) return EnumActionResult.SUCCESS;
                world.func_175656_a(pos, ((BlockCrops)block).func_185528_e(0));
            } else {
                world.func_175656_a(pos, recipe.getReplacementBlock().func_176223_P());
            }
            ItemSpawnUtil.spawnItem(world, pos.func_177982_a(0, 1, 0), recipe.getDrop().func_77946_l());
            if (!player.field_71075_bZ.field_75098_d) {
                player.func_184586_b(hand).func_77972_a(1, (EntityLivingBase)player);
            }
        } else {
            for (int i = 0; i < 50; ++i) {
                ClientProxy.particleRenderer.spawnParticle(world, Util.getLowercaseClassName(ParticleGlitter.class), (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, this.random.nextDouble() * 0.1 * (double)(this.random.nextDouble() > 0.5 ? -1 : 1), this.random.nextDouble() * 0.1 * (double)(this.random.nextDouble() > 0.5 ? -1 : 1), this.random.nextDouble() * 0.1 * (double)(this.random.nextDouble() > 0.5 ? -1 : 1), new double[]{120.0, 0.855 + this.random.nextDouble() * 0.05, 0.71, 0.943 - this.random.nextDouble() * 0.05, 1.0, this.random.nextDouble() + 0.5, this.random.nextDouble() * 2.0});
            }
        }
        world.func_184133_a(player, pos, SoundEvents.field_187763_eJ, SoundCategory.BLOCKS, 1.0f, 1.0f);
        return EnumActionResult.SUCCESS;
    }

    public boolean func_111207_a(ItemStack itemstack, EntityPlayer player, EntityLivingBase entity, EnumHand hand) {
        RunicShearsCapability cap;
        if (entity.field_70170_p.field_72995_K) {
            return false;
        }
        World world = player.field_70170_p;
        Random rand = field_77697_d;
        if (entity instanceof IShearable) {
            int count = 0;
            if (Items.field_151097_aZ.func_111207_a(itemstack, player, entity, hand)) {
                ++count;
            }
            float radius = GeneralConfig.RunicShearsRadius;
            List entities = Util.getEntitiesWithinRadius((World)entity.field_70170_p, e -> e instanceof IShearable, (BlockPos)entity.func_180425_c(), (float)radius, (float)(radius / 2.0f), (float)radius);
            for (EntityLiving e2 : entities) {
                e2.captureDrops = true;
                if (Items.field_151097_aZ.func_111207_a(itemstack, player, (EntityLivingBase)e2, hand)) {
                    ++count;
                }
                e2.captureDrops = false;
                for (EntityItem ent : e2.capturedDrops) {
                    ent.func_70107_b(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
                    ent.field_70181_x = 0.0;
                    ent.field_70159_w = 0.0;
                    ent.field_70179_y = 0.0;
                    ent.field_70170_p.func_72838_d((Entity)ent);
                }
            }
            if (count > 0) {
                return true;
            }
        }
        if (entity.func_70631_g_()) {
            return true;
        }
        RunicShearRecipe recipe = ModRecipes.getRunicShearRecipe(entity);
        if (recipe != null && (cap = (RunicShearsCapability)((Object)entity.getCapability(RunicShearsCapabilityProvider.RUNIC_SHEARS_CAPABILITY, null))) != null) {
            if (cap.canHarvest()) {
                cap.setCooldown(recipe.getCooldown());
                EntityItem ent = entity.func_70099_a(recipe.getDrop().func_77946_l(), 1.0f);
                ent.field_70181_x += (double)(rand.nextFloat() * 0.05f);
                ent.field_70159_w += (double)((rand.nextFloat() - rand.nextFloat()) * 0.1f);
                ent.field_70179_y += (double)((rand.nextFloat() - rand.nextFloat()) * 0.1f);
                if (!player.field_71075_bZ.field_75098_d) {
                    itemstack.func_77972_a(1, entity);
                }
                world.func_184133_a(player, entity.func_180425_c(), SoundEvents.field_187763_eJ, SoundCategory.BLOCKS, 1.0f, 1.0f);
                MessageRunicShearsFX packet = new MessageRunicShearsFX((Entity)entity);
                PacketHandler.sendToAllTracking((IMessage)packet, (Entity)entity);
                return true;
            }
            player.func_146105_b(new TextComponentTranslation("roots.runic_shears.cooldown", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.DARK_PURPLE)), true);
        }
        return false;
    }
}

