/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.item;

import epicsquid.mysticallib.item.ItemBase;
import epicsquid.roots.Roots;
import epicsquid.roots.api.Herb;
import epicsquid.roots.config.GeneralConfig;
import epicsquid.roots.gui.Keybinds;
import epicsquid.roots.handler.PouchHandler;
import epicsquid.roots.init.HerbRegistry;
import epicsquid.roots.integration.baubles.pouch.PouchEquipHandler;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemPouch
extends ItemBase {
    public ItemPouch(@Nonnull String name) {
        super(name);
        this.func_77625_d(1);
    }

    public boolean isApothecary() {
        return false;
    }

    public static boolean hasHerb(@Nonnull ItemStack pouch, Herb herb) {
        return ItemPouch.getHerbQuantity(pouch, herb) > 0.0;
    }

    public static double getHerbQuantity(@Nonnull ItemStack pouch, Herb herb) {
        PouchHandler pouchHandler = PouchHandler.getHandler(pouch);
        if (pouchHandler == null) {
            return 0.0;
        }
        double count = ItemPouch.getNbtQuantity(pouch, herb.getName());
        PouchHandler.PouchItemHandler handler = pouchHandler.getHerbs();
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack stack = handler.getStackInSlot(i);
            if (stack.func_190926_b() || !herb.equals((Object)HerbRegistry.getHerbByItem(stack.func_77973_b()))) continue;
            count += (double)stack.func_190916_E();
        }
        return count;
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, @Nonnull EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        boolean isBaublesLoaded = Loader.isModLoaded((String)"baubles");
        boolean open_gui = false;
        if (GeneralConfig.AutoEquipPouches) {
            if (player.func_70093_af()) {
                open_gui = true;
            }
            if (isBaublesLoaded && !world.field_72995_K && !PouchEquipHandler.tryEquipPouch(player, stack)) {
                open_gui = true;
            }
        } else {
            open_gui = true;
        }
        if (!world.field_72995_K && open_gui) {
            player.openGui((Object)Roots.getInstance(), 16, world, 0, 0, 0);
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    private static ItemStack createData(ItemStack stack, Herb herb, double quantity) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_74780_a(herb.getName(), quantity);
        return stack;
    }

    private static double getNbtQuantity(@Nonnull ItemStack stack, String plantName) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b(plantName)) {
            return stack.func_77978_p().func_74769_h(plantName);
        }
        return 0.0;
    }

    public static double useQuantity(@Nonnull ItemStack stack, Herb herb, double quantity) {
        double temp = quantity;
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b(herb.getName())) {
            if ((temp -= stack.func_77978_p().func_74769_h(herb.getName())) >= 0.0) {
                stack.func_77978_p().func_82580_o(herb.getName());
                if (temp > 0.0 && ItemPouch.addHerbToNbt(stack, herb)) {
                    temp = ItemPouch.useQuantity(stack, herb, temp);
                }
            } else {
                stack.func_77978_p().func_74780_a(herb.getName(), stack.func_77978_p().func_74769_h(herb.getName()) - quantity);
                temp = 0.0;
            }
        } else if (ItemPouch.addHerbToNbt(stack, herb)) {
            temp = ItemPouch.useQuantity(stack, herb, quantity);
        }
        return temp;
    }

    private static boolean addHerbToNbt(@Nonnull ItemStack pouch, Herb herb) {
        PouchHandler pouchHandler = PouchHandler.getHandler(pouch);
        if (pouchHandler == null) {
            return false;
        }
        PouchHandler.PouchItemHandler handler = pouchHandler.getHerbs();
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack stack = handler.getStackInSlot(i);
            if (stack.func_190926_b() || !HerbRegistry.containsHerbItem(stack.func_77973_b()) || !HerbRegistry.getHerbByItem(stack.func_77973_b()).equals((Object)herb) || handler.extractItem(i, 1, false).func_190926_b()) continue;
            ItemPouch.createData(pouch, herb, 1.0);
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (GeneralConfig.AutoEquipPouches && Loader.isModLoaded((String)"baubles")) {
            tooltip.add(TextFormatting.GREEN + I18n.func_135052_a((String)"roots.tooltip.pouch", (Object[])new Object[]{Keybinds.POUCH_KEYBIND.getDisplayName()}));
        } else {
            tooltip.add(TextFormatting.GREEN + I18n.func_135052_a((String)"roots.tooltip.pouch2", (Object[])new Object[]{Keybinds.POUCH_KEYBIND.getDisplayName()}));
        }
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }
}

