/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.integration.jei;

import epicsquid.roots.config.ElementalSoilConfig;
import epicsquid.roots.handler.SpellHandler;
import epicsquid.roots.init.ModBlocks;
import epicsquid.roots.init.ModItems;
import epicsquid.roots.init.ModRecipes;
import epicsquid.roots.integration.jei.FeyCrafterTransfer;
import epicsquid.roots.integration.jei.carving.BarkRecipeCategory;
import epicsquid.roots.integration.jei.carving.BarkRecipeWrapper;
import epicsquid.roots.integration.jei.carving.RunicCarvingCategory;
import epicsquid.roots.integration.jei.carving.RunicCarvingWrapper;
import epicsquid.roots.integration.jei.fey.FeyCategory;
import epicsquid.roots.integration.jei.fey.FeyWrapper;
import epicsquid.roots.integration.jei.mortar.MortarCategory;
import epicsquid.roots.integration.jei.mortar.MortarWrapper;
import epicsquid.roots.integration.jei.ritual.RitualCategory;
import epicsquid.roots.integration.jei.ritual.RitualCraftingCategory;
import epicsquid.roots.integration.jei.ritual.RitualCraftingWrapper;
import epicsquid.roots.integration.jei.ritual.RitualWrapper;
import epicsquid.roots.integration.jei.shears.RunicShearsCategory;
import epicsquid.roots.integration.jei.shears.RunicShearsWrapper;
import epicsquid.roots.integration.jei.spell.SpellCostCategory;
import epicsquid.roots.integration.jei.spell.SpellCostWrapper;
import epicsquid.roots.integration.jei.spell.SpellModifierCategory;
import epicsquid.roots.integration.jei.spell.SpellModifierWrapper;
import epicsquid.roots.recipe.BarkRecipe;
import epicsquid.roots.recipe.FeyCraftingRecipe;
import epicsquid.roots.recipe.MortarRecipe;
import epicsquid.roots.recipe.PyreCraftingRecipe;
import epicsquid.roots.recipe.RunicCarvingRecipe;
import epicsquid.roots.recipe.RunicShearRecipe;
import epicsquid.roots.recipe.TransmutationRecipe;
import epicsquid.roots.ritual.RitualBase;
import epicsquid.roots.ritual.RitualRegistry;
import epicsquid.roots.spell.SpellBase;
import epicsquid.roots.spell.SpellRegistry;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.ISubtypeRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategoryRegistration;
import mezz.jei.api.recipe.transfer.IRecipeTransferInfo;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextComponentTranslation;

@JEIPlugin
public class JEIRootsPlugin
implements IModPlugin {
    public static final String RUNIC_SHEARS = "roots.runic_shears";
    public static final String RUNIC_SHEARS_ENTITY = "roots.runic_shears_entity";
    public static final String BARK_CARVING = "roots.bark_carving";
    public static final String RUNIC_CARVING = "roots.runic_carving";
    public static final String RITUAL_CRAFTING = "roots.ritual_crafting";
    public static final String MORTAR_AND_PESTLE = "roots.mortar_and_pestle";
    public static final String RITUAL = "roots.ritual";
    public static final String FEY_CRAFTING = "roots.fey_crafting";
    public static final String SPELL_COSTS = "roots.spell_costs";
    public static final String SPELL_MODIFIERS = "roots.spell_modifiers";

    public void registerCategories(IRecipeCategoryRegistration registry) {
        IGuiHelper helper = registry.getJeiHelpers().getGuiHelper();
        registry.addRecipeCategories(new IRecipeCategory[]{new RunicShearsCategory(helper), new RunicCarvingCategory(helper), new RitualCraftingCategory(helper), new MortarCategory(helper), new RitualCategory(helper), new FeyCategory(helper), new SpellCostCategory(helper), new SpellModifierCategory(helper), new BarkRecipeCategory(helper)});
    }

    public void register(IModRegistry registry) {
        registry.handleRecipes(RunicShearRecipe.class, RunicShearsWrapper::new, RUNIC_SHEARS);
        registry.handleRecipes(RunicCarvingRecipe.class, RunicCarvingWrapper::new, RUNIC_CARVING);
        registry.handleRecipes(PyreCraftingRecipe.class, RitualCraftingWrapper::new, RITUAL_CRAFTING);
        registry.handleRecipes(MortarRecipe.class, MortarWrapper::new, MORTAR_AND_PESTLE);
        registry.handleRecipes(SpellBase.class, MortarWrapper::new, MORTAR_AND_PESTLE);
        registry.handleRecipes(RitualBase.class, RitualWrapper::new, RITUAL);
        registry.handleRecipes(FeyCraftingRecipe.class, FeyWrapper::new, FEY_CRAFTING);
        registry.handleRecipes(SpellBase.class, SpellCostWrapper::new, SPELL_COSTS);
        registry.handleRecipes(SpellBase.class, SpellModifierWrapper::new, SPELL_MODIFIERS);
        registry.handleRecipes(BarkRecipe.class, BarkRecipeWrapper::new, BARK_CARVING);
        Collection<SpellBase> spells = SpellRegistry.spellRegistry.values();
        Map<String, RunicShearRecipe> runicShearRecipes = ModRecipes.getRunicShearRecipes();
        List runicShearBlockRecipes = runicShearRecipes.values().stream().filter(RunicShearRecipe::isBlockRecipe).collect(Collectors.toList());
        List runicShearEntityRecipes = runicShearRecipes.values().stream().filter(RunicShearRecipe::isEntityRecipe).collect(Collectors.toList());
        registry.addRecipes(runicShearBlockRecipes, RUNIC_SHEARS);
        registry.addRecipes(ModRecipes.getRunicCarvingRecipes(), RUNIC_CARVING);
        registry.addRecipes(ModRecipes.getPyreCraftingRecipes().values(), RITUAL_CRAFTING);
        registry.addRecipes(ModRecipes.getMortarRecipes(), MORTAR_AND_PESTLE);
        registry.addRecipes(spells, MORTAR_AND_PESTLE);
        registry.addRecipes(spells, SPELL_COSTS);
        registry.addRecipes(RitualRegistry.ritualRegistry.values(), RITUAL);
        registry.addRecipes(ModRecipes.getFeyCraftingRecipes().values(), FEY_CRAFTING);
        registry.addRecipes((Collection)spells.stream().filter(SpellBase::hasModules).collect(Collectors.toList()), SPELL_MODIFIERS);
        registry.addRecipes(ModRecipes.getBarkRecipes(), BARK_CARVING);
        registry.addRecipeCatalyst((Object)new ItemStack(ModItems.runic_shears), new String[]{RUNIC_SHEARS});
        registry.addRecipeCatalyst((Object)new ItemStack(ModItems.wood_knife), new String[]{RUNIC_CARVING});
        registry.addRecipeCatalyst((Object)new ItemStack(ModItems.stone_knife), new String[]{RUNIC_CARVING});
        registry.addRecipeCatalyst((Object)new ItemStack(ModItems.iron_knife), new String[]{RUNIC_CARVING});
        registry.addRecipeCatalyst((Object)new ItemStack(ModItems.gold_knife), new String[]{RUNIC_CARVING});
        registry.addRecipeCatalyst((Object)new ItemStack(ModItems.diamond_knife), new String[]{RUNIC_CARVING});
        registry.addRecipeCatalyst((Object)new ItemStack(ModItems.wood_knife), new String[]{BARK_CARVING});
        registry.addRecipeCatalyst((Object)new ItemStack(ModItems.stone_knife), new String[]{BARK_CARVING});
        registry.addRecipeCatalyst((Object)new ItemStack(ModItems.iron_knife), new String[]{BARK_CARVING});
        registry.addRecipeCatalyst((Object)new ItemStack(ModItems.gold_knife), new String[]{BARK_CARVING});
        registry.addRecipeCatalyst((Object)new ItemStack(ModItems.diamond_knife), new String[]{BARK_CARVING});
        registry.addRecipeCatalyst((Object)new ItemStack(epicsquid.mysticalworld.init.ModItems.copper_knife), new String[]{RUNIC_CARVING});
        registry.addRecipeCatalyst((Object)new ItemStack(epicsquid.mysticalworld.init.ModItems.silver_knife), new String[]{RUNIC_CARVING});
        registry.addRecipeCatalyst((Object)new ItemStack(epicsquid.mysticalworld.init.ModItems.amethyst_knife), new String[]{RUNIC_CARVING});
        registry.addRecipeCatalyst((Object)new ItemStack(epicsquid.mysticalworld.init.ModItems.copper_knife), new String[]{BARK_CARVING});
        registry.addRecipeCatalyst((Object)new ItemStack(epicsquid.mysticalworld.init.ModItems.silver_knife), new String[]{BARK_CARVING});
        registry.addRecipeCatalyst((Object)new ItemStack(epicsquid.mysticalworld.init.ModItems.amethyst_knife), new String[]{BARK_CARVING});
        registry.addRecipeCatalyst((Object)new ItemStack(ModBlocks.bonfire), new String[]{RITUAL_CRAFTING});
        registry.addRecipeCatalyst((Object)new ItemStack(ModBlocks.mortar), new String[]{MORTAR_AND_PESTLE});
        registry.addRecipeCatalyst((Object)new ItemStack(ModItems.pestle), new String[]{MORTAR_AND_PESTLE});
        registry.addRecipeCatalyst((Object)new ItemStack(ModBlocks.bonfire), new String[]{RITUAL});
        registry.addRecipeCatalyst((Object)new ItemStack(ModBlocks.fey_crafter), new String[]{FEY_CRAFTING});
        registry.addRecipeCatalyst((Object)new ItemStack(ModItems.staff), new String[]{SPELL_COSTS});
        registry.addRecipeCatalyst((Object)new ItemStack(ModBlocks.imbuer), new String[]{SPELL_MODIFIERS});
        registry.addIngredientInfo((Object)new ItemStack(ModItems.terra_moss), VanillaTypes.ITEM, new String[]{I18n.func_135052_a((String)"jei.roots.terra_moss.desc", (Object[])new Object[0])});
        registry.addIngredientInfo((Object)new ItemStack(ModItems.terra_spores), VanillaTypes.ITEM, new String[]{I18n.func_135052_a((String)"jei.roots.terra_spores.desc", (Object[])new Object[0])});
        registry.addIngredientInfo((Object)new ItemStack(ModItems.wildroot), VanillaTypes.ITEM, new String[]{I18n.func_135052_a((String)"jei.roots.wildroot.desc", (Object[])new Object[0])});
        for (TransmutationRecipe recipe : ModRecipes.getTransmutationRecipes()) {
            Block endBlock;
            ItemStack drop;
            IBlockState endState = recipe.getEndState();
            ItemStack endStack = recipe.getEndStack();
            if (endStack != null && !endStack.func_190926_b()) {
                registry.addIngredientInfo((Object)endStack, VanillaTypes.ITEM, new String[]{I18n.func_135052_a((String)recipe.getKey(), (Object[])new Object[0])});
                continue;
            }
            if (endState == null || (drop = new ItemStack(Item.func_150898_a((Block)(endBlock = endState.func_177230_c())), 1, endBlock.func_180651_a(endState))) == null || drop.func_190926_b()) continue;
            registry.addIngredientInfo((Object)drop, VanillaTypes.ITEM, new String[]{I18n.func_135052_a((String)recipe.getKey(), (Object[])new Object[0])});
        }
        registry.addIngredientInfo((Object)new ItemStack(ModItems.fey_leather), VanillaTypes.ITEM, new String[]{I18n.func_135052_a((String)"jei.roots.fey_leather.source.desc", (Object[])new Object[0])});
        registry.addIngredientInfo((Object)new ItemStack(ModBlocks.wildwood_log), VanillaTypes.ITEM, new String[]{I18n.func_135052_a((String)"jei.roots.wildwood.desc", (Object[])new Object[0])});
        registry.addIngredientInfo((Object)new ItemStack(ModBlocks.wildwood_sapling), VanillaTypes.ITEM, new String[]{I18n.func_135052_a((String)"jei.roots.wildwood_sapling.desc", (Object[])new Object[0])});
        registry.addIngredientInfo((Object)new ItemStack(ModBlocks.wildwood_leaves), VanillaTypes.ITEM, new String[]{I18n.func_135052_a((String)"jei.roots.wildwood_leaves.desc", (Object[])new Object[0])});
        String airSoilLocalized = new TextComponentTranslation("jei.roots.elemental_soil_air.desc", new Object[0]).func_150254_d();
        airSoilLocalized = airSoilLocalized.replace("@LEVEL", Integer.valueOf(ElementalSoilConfig.AirSoilMinY).toString());
        String earthSoilLocalized = new TextComponentTranslation("jei.roots.elemental_soil_earth.desc", new Object[0]).func_150254_d();
        earthSoilLocalized = earthSoilLocalized.replace("@LEVEL", Integer.valueOf(ElementalSoilConfig.EarthSoilMaxY).toString());
        registry.addIngredientInfo((Object)new ItemStack(ModBlocks.elemental_soil_fire), VanillaTypes.ITEM, new String[]{I18n.func_135052_a((String)"jei.roots.elemental_soil_fire.desc", (Object[])new Object[0])});
        registry.addIngredientInfo((Object)new ItemStack(ModBlocks.elemental_soil_water), VanillaTypes.ITEM, new String[]{I18n.func_135052_a((String)"jei.roots.elemental_soil_water.desc", (Object[])new Object[0])});
        registry.addIngredientInfo((Object)new ItemStack(ModBlocks.elemental_soil_air), VanillaTypes.ITEM, new String[]{airSoilLocalized});
        registry.addIngredientInfo((Object)new ItemStack(ModBlocks.elemental_soil_earth), VanillaTypes.ITEM, new String[]{earthSoilLocalized});
        registry.getRecipeTransferRegistry().addRecipeTransferHandler((IRecipeTransferInfo)new FeyCrafterTransfer());
    }

    public void registerItemSubtypes(ISubtypeRegistry subtypeRegistry) {
        ISubtypeRegistry.ISubtypeInterpreter spellInterpreter = itemStack -> {
            Item stackItem = itemStack.func_77973_b();
            if (stackItem != ModItems.spell_dust) {
                return "";
            }
            SpellBase spell = SpellHandler.fromStack(itemStack).getSelectedSpell();
            if (spell != null) {
                return spell.getName();
            }
            return "";
        };
        subtypeRegistry.registerSubtypeInterpreter(ModItems.spell_dust, spellInterpreter);
    }
}

