/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.init;

import com.google.common.collect.Lists;
import epicsquid.mysticallib.event.RegisterModRecipesEvent;
import epicsquid.mysticallib.util.Util;
import epicsquid.mysticalworld.entity.EntityBeetle;
import epicsquid.mysticalworld.entity.EntityDeer;
import epicsquid.mysticalworld.entity.EntityFox;
import epicsquid.mysticalworld.entity.EntityFrog;
import epicsquid.mysticalworld.materials.Metal;
import epicsquid.roots.api.Herb;
import epicsquid.roots.init.ModBlocks;
import epicsquid.roots.init.ModItems;
import epicsquid.roots.recipe.AnimalHarvestRecipe;
import epicsquid.roots.recipe.ApothecaryPouchRecipe;
import epicsquid.roots.recipe.BarkRecipe;
import epicsquid.roots.recipe.FeyCraftingRecipe;
import epicsquid.roots.recipe.FlowerRecipe;
import epicsquid.roots.recipe.MortarRecipe;
import epicsquid.roots.recipe.PacifistEntry;
import epicsquid.roots.recipe.PyreCraftingRecipe;
import epicsquid.roots.recipe.RunicCarvingRecipe;
import epicsquid.roots.recipe.RunicShearRecipe;
import epicsquid.roots.recipe.RunicShearRecipes;
import epicsquid.roots.recipe.TransmutationRecipe;
import epicsquid.roots.recipe.ingredient.GoldOrSilverIngotIngredient;
import epicsquid.roots.spell.SpellBase;
import epicsquid.roots.spell.SpellRegistry;
import epicsquid.roots.util.ItemUtil;
import epicsquid.roots.util.StateUtil;
import epicsquid.roots.util.types.WorldPosStatePredicate;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockOldLeaf;
import net.minecraft.block.BlockOldLog;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.BlockSand;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityBat;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityDonkey;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.EntityLlama;
import net.minecraft.entity.passive.EntityMooshroom;
import net.minecraft.entity.passive.EntityMule;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.passive.EntityParrot;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntityRabbit;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntitySquid;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreIngredient;

public class ModRecipes {
    private static Map<ResourceLocation, AnimalHarvestRecipe> harvestRecipes = new HashMap<ResourceLocation, AnimalHarvestRecipe>();
    private static ObjectOpenHashSet<Class<? extends Entity>> harvestClasses = null;
    private static Map<ResourceLocation, TransmutationRecipe> transmutationRecipes = new HashMap<ResourceLocation, TransmutationRecipe>();
    private static List<MortarRecipe> mortarRecipes = new ArrayList<MortarRecipe>();
    private static Map<String, PyreCraftingRecipe> pyreCraftingRecipes = new HashMap<String, PyreCraftingRecipe>();
    private static Map<ResourceLocation, FeyCraftingRecipe> feyCraftingRecipes = new HashMap<ResourceLocation, FeyCraftingRecipe>();
    private static Map<String, RunicShearRecipe> runicShearRecipes = new HashMap<String, RunicShearRecipe>();
    private static Map<Class<? extends Entity>, RunicShearRecipe> runicShearEntityRecipes = new HashMap<Class<? extends Entity>, RunicShearRecipe>();
    private static List<RunicCarvingRecipe> runicCarvingRecipes = new ArrayList<RunicCarvingRecipe>();
    private static Map<ResourceLocation, PacifistEntry> pacifistEntities = new HashMap<ResourceLocation, PacifistEntry>();
    private static Map<Class<? extends Entity>, PacifistEntry> pacifistClasses = new HashMap<Class<? extends Entity>, PacifistEntry>();
    private static Map<ResourceLocation, BarkRecipe> barkRecipes = new HashMap<ResourceLocation, BarkRecipe>();
    private static Map<ResourceLocation, FlowerRecipe> flowerRecipes = new HashMap<ResourceLocation, FlowerRecipe>();

    public static PacifistEntry addPacifistEntry(String name, Class<? extends Entity> clazz) {
        PacifistEntry entry = new PacifistEntry(clazz, name);
        pacifistEntities.put(entry.getRegistryName(), entry);
        pacifistClasses.put(clazz, entry);
        return entry;
    }

    public static PacifistEntry getPacifistEntry(String name) {
        return ModRecipes.getPacifistEntry(new ResourceLocation("roots", name));
    }

    public static PacifistEntry getPacifistEntry(ResourceLocation name) {
        return pacifistEntities.get(name);
    }

    public static PacifistEntry getPacifistEntry(Entity entity) {
        return pacifistClasses.get(entity.getClass());
    }

    public static void removePacifistEntry(String name) {
        ModRecipes.removePacifistEntry(new ResourceLocation("roots", name));
    }

    public static void removePacifistEntry(ResourceLocation name) {
        PacifistEntry entry = ModRecipes.getPacifistEntry(name);
        if (entry != null) {
            pacifistEntities.remove(name);
            pacifistClasses.remove(entry.getEntityClass());
        }
    }

    public static void initPacifistEntities() {
        ModRecipes.addPacifistEntry("bat", EntityBat.class);
        ModRecipes.addPacifistEntry("chicken", EntityChicken.class);
        ModRecipes.addPacifistEntry("cow", EntityCow.class);
        ModRecipes.addPacifistEntry("donkey", EntityDonkey.class);
        ModRecipes.addPacifistEntry("horse", EntityHorse.class);
        ModRecipes.addPacifistEntry("llama", EntityLlama.class);
        ModRecipes.addPacifistEntry("mooshroom", EntityMooshroom.class);
        ModRecipes.addPacifistEntry("mule", EntityMule.class);
        ModRecipes.addPacifistEntry("ocelot", EntityOcelot.class);
        ModRecipes.addPacifistEntry("parrot", EntityParrot.class);
        ModRecipes.addPacifistEntry("pig", EntityPig.class);
        ModRecipes.addPacifistEntry("rabbit", EntityRabbit.class);
        ModRecipes.addPacifistEntry("sheep", EntitySheep.class);
        ModRecipes.addPacifistEntry("squid", EntitySquid.class);
        ModRecipes.addPacifistEntry("villager", EntityVillager.class).setCheckTarget(true);
        ModRecipes.addPacifistEntry("wolf", EntityWolf.class);
        ModRecipes.addPacifistEntry("beetle", EntityBeetle.class);
        ModRecipes.addPacifistEntry("deer", EntityDeer.class);
        ModRecipes.addPacifistEntry("fox", EntityFox.class);
        ModRecipes.addPacifistEntry("frog", EntityFrog.class);
    }

    public static void addFlowerRecipe(String name, IBlockState state) {
        ResourceLocation rl = new ResourceLocation("roots", name);
        FlowerRecipe recipe = new FlowerRecipe(rl, state);
        flowerRecipes.put(rl, recipe);
    }

    public static void addFlowerRecipe(String name, Block block, int meta) {
        ResourceLocation rl = new ResourceLocation("roots", name);
        FlowerRecipe recipe = new FlowerRecipe(rl, meta, block);
        flowerRecipes.put(rl, recipe);
    }

    public static void removeFlowerRecipe(ResourceLocation name) {
        flowerRecipes.remove(name);
    }

    @Nullable
    public static FlowerRecipe getRandomFlowerRecipe() {
        if (flowerRecipes.isEmpty()) {
            return null;
        }
        return (FlowerRecipe)Lists.newArrayList(flowerRecipes.values()).get(Util.rand.nextInt(Math.max(1, flowerRecipes.size())));
    }

    public static void initFlowerRecipes() {
        ModRecipes.addFlowerRecipe("dandelion", Blocks.field_150327_N.func_176203_a(BlockFlower.EnumFlowerType.DANDELION.func_176968_b()));
        ModRecipes.addFlowerRecipe("poppy", Blocks.field_150328_O.func_176203_a(BlockFlower.EnumFlowerType.POPPY.func_176968_b()));
        ModRecipes.addFlowerRecipe("blue_orchid", Blocks.field_150328_O.func_176203_a(BlockFlower.EnumFlowerType.BLUE_ORCHID.func_176968_b()));
        ModRecipes.addFlowerRecipe("allium", Blocks.field_150328_O.func_176203_a(BlockFlower.EnumFlowerType.ALLIUM.func_176968_b()));
        ModRecipes.addFlowerRecipe("houstonia", Blocks.field_150328_O.func_176203_a(BlockFlower.EnumFlowerType.HOUSTONIA.func_176968_b()));
        ModRecipes.addFlowerRecipe("red_tulip", Blocks.field_150328_O.func_176203_a(BlockFlower.EnumFlowerType.RED_TULIP.func_176968_b()));
        ModRecipes.addFlowerRecipe("orange_tulip", Blocks.field_150328_O.func_176203_a(BlockFlower.EnumFlowerType.ORANGE_TULIP.func_176968_b()));
        ModRecipes.addFlowerRecipe("white_tulip", Blocks.field_150328_O.func_176203_a(BlockFlower.EnumFlowerType.WHITE_TULIP.func_176968_b()));
        ModRecipes.addFlowerRecipe("pink_tulip", Blocks.field_150328_O.func_176203_a(BlockFlower.EnumFlowerType.PINK_TULIP.func_176968_b()));
        ModRecipes.addFlowerRecipe("oxeye_daisy", Blocks.field_150328_O.func_176203_a(BlockFlower.EnumFlowerType.OXEYE_DAISY.func_176968_b()));
    }

    public static void addVanillaBarkRecipe(String name, BlockPlanks.EnumType type, Item item) {
        barkRecipes.put(new ResourceLocation("roots", name), new BarkRecipe(type, item));
    }

    public static void initVanillaBarkRecipes() {
        ModRecipes.addVanillaBarkRecipe("oak", BlockPlanks.EnumType.OAK, ModItems.bark_oak);
        ModRecipes.addVanillaBarkRecipe("spruce", BlockPlanks.EnumType.SPRUCE, ModItems.bark_spruce);
        ModRecipes.addVanillaBarkRecipe("birch", BlockPlanks.EnumType.BIRCH, ModItems.bark_birch);
        ModRecipes.addVanillaBarkRecipe("jungle", BlockPlanks.EnumType.JUNGLE, ModItems.bark_jungle);
        ModRecipes.addVanillaBarkRecipe("acacia", BlockPlanks.EnumType.ACACIA, ModItems.bark_acacia);
        ModRecipes.addVanillaBarkRecipe("dark_oak", BlockPlanks.EnumType.DARK_OAK, ModItems.bark_dark_oak);
    }

    public static void initModdedBarkRecipes() {
        ModRecipes.addModdedBarkRecipe("wildwood", ModBlocks.wildwood_log, ModItems.bark_wildwood);
    }

    public static void addModdedBarkRecipe(String name, Block block, Item item) {
        barkRecipes.put(new ResourceLocation("roots", name), new BarkRecipe(block, item));
    }

    @Nullable
    public static BarkRecipe getModdedBarkRecipe(Block block) {
        for (BarkRecipe recipe : barkRecipes.values()) {
            if (recipe.getBlock() != block) continue;
            return recipe;
        }
        return null;
    }

    @Nullable
    public static BarkRecipe getVanillaBarkRecipe(BlockPlanks.EnumType type) {
        for (BarkRecipe recipe : barkRecipes.values()) {
            if (recipe.getType() != type) continue;
            return recipe;
        }
        return null;
    }

    public static Collection<BarkRecipe> getBarkRecipes() {
        return barkRecipes.values();
    }

    public static void addTransmutationRecipe(String name, Block start, IBlockState endState, WorldPosStatePredicate condition) {
        ResourceLocation n = new ResourceLocation("roots", name);
        TransmutationRecipe recipe = new TransmutationRecipe(n, start, endState, condition);
        transmutationRecipes.put(n, recipe);
    }

    public static void addTransmutationRecipe(String name, IBlockState start, IBlockState endState) {
        ModRecipes.addTransmutationRecipe(name, start, endState, null);
    }

    public static void addTransmutationRecipe(String name, IBlockState start, IBlockState endState, WorldPosStatePredicate condition) {
        ResourceLocation n = new ResourceLocation("roots", name);
        TransmutationRecipe recipe = new TransmutationRecipe(n, start, endState, condition);
        transmutationRecipes.put(n, recipe);
    }

    public static void addTransmutationRecipe(String name, IBlockState start, ItemStack endState) {
        ModRecipes.addTransmutationRecipe(name, start, endState, null);
    }

    public static void addTransmutationRecipe(String name, IBlockState start, ItemStack endState, WorldPosStatePredicate condition) {
        ResourceLocation n = new ResourceLocation("roots", name);
        TransmutationRecipe recipe = new TransmutationRecipe(n, start, endState, condition);
        transmutationRecipes.put(n, recipe);
    }

    public static void addTransmutationRecipe(String name, Block start, ItemStack endState) {
        ModRecipes.addTransmutationRecipe(name, start, endState, null);
    }

    public static void addTransmutationRecipe(String name, Block start, ItemStack endState, WorldPosStatePredicate condition) {
        ResourceLocation n = new ResourceLocation("roots", name);
        TransmutationRecipe recipe = new TransmutationRecipe(n, start, endState, condition);
        transmutationRecipes.put(n, recipe);
    }

    public static void addTransmutationRecipe(String name, Block start, IBlockState endState) {
        ModRecipes.addTransmutationRecipe(name, start, endState, null);
    }

    public static void addTransmutationRecipe(String name, Block start, Block endState) {
        ModRecipes.addTransmutationRecipe(name, start, endState.func_176223_P(), null);
    }

    public static void removeTransmutationRecipe(String name) {
        ModRecipes.removeTransmutationRecipe(new ResourceLocation("roots", name));
    }

    public static void removeTransmutationRecipe(ResourceLocation name) {
        transmutationRecipes.remove(name);
    }

    public static TransmutationRecipe getTransmutationRecipe(String name) {
        return ModRecipes.getTransmutationRecipe(new ResourceLocation("roots", name));
    }

    public static TransmutationRecipe getTransmutationRecipe(ResourceLocation name) {
        return transmutationRecipes.getOrDefault(name, null);
    }

    public static List<TransmutationRecipe> getTransmutationRecipes() {
        return new ArrayList<TransmutationRecipe>(transmutationRecipes.values());
    }

    public static List<TransmutationRecipe> getTransmutationRecipes(IBlockState startState) {
        ArrayList<TransmutationRecipe> result = new ArrayList<TransmutationRecipe>();
        for (TransmutationRecipe recipe : transmutationRecipes.values()) {
            if (!recipe.matches(startState)) continue;
            result.add(recipe);
        }
        return result;
    }

    public static List<TransmutationRecipe> getTransmutationRecipes(Block startState) {
        return ModRecipes.getTransmutationRecipes(startState.func_176223_P());
    }

    public static void initTransmutationRecipes() {
        ModRecipes.addTransmutationRecipe("deadbush_cocoa", (Block)Blocks.field_150330_I, new ItemStack(Items.field_151100_aR, 3, 3));
        ModRecipes.addTransmutationRecipe("birch_jungle", Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockOldLog.field_176301_b, (Comparable)BlockPlanks.EnumType.BIRCH), Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockOldLog.field_176301_b, (Comparable)BlockPlanks.EnumType.JUNGLE));
        ModRecipes.addTransmutationRecipe("birch_jungle_leaves", Blocks.field_150362_t.func_176223_P().func_177226_a((IProperty)BlockOldLeaf.field_176239_P, (Comparable)BlockPlanks.EnumType.BIRCH), Blocks.field_150362_t.func_176223_P().func_177226_a((IProperty)BlockOldLeaf.field_176239_P, (Comparable)BlockPlanks.EnumType.JUNGLE));
        ModRecipes.addTransmutationRecipe("pumpkin_melon", Blocks.field_150423_aK, Blocks.field_150440_ba.func_176223_P(), (World t, BlockPos u, IBlockState v) -> {
            Block b = t.func_180495_p(u.func_177977_b()).func_177230_c();
            return b == Blocks.field_150355_j || b == Blocks.field_150358_i;
        });
        ModRecipes.addTransmutationRecipe("pumpkin_cactus", Blocks.field_150423_aK, Blocks.field_150434_aF.func_176223_P(), (World t, BlockPos u, IBlockState v) -> t.func_180495_p(u.func_177977_b()).func_177230_c() instanceof BlockSand);
        StateUtil.ignoreState((Block)Blocks.field_150362_t, BlockLeaves.field_176236_b);
        StateUtil.ignoreState((Block)Blocks.field_150362_t, BlockLeaves.field_176237_a);
    }

    public static void addAnimalHarvestRecipe(Entity entity) {
        ModRecipes.addAnimalHarvestRecipe(EntityList.func_75621_b((Entity)entity), entity);
    }

    public static void addAnimalHarvestRecipe(String name, Entity entity) {
        ModRecipes.addAnimalHarvestRecipe(name, entity.getClass());
    }

    public static void addAnimalHarvestRecipe(String name, Class<? extends Entity> clazz) {
        ResourceLocation n = new ResourceLocation("roots", name);
        if (harvestRecipes.containsKey(n)) {
            System.out.println("Animal Harvest recipe name is already registered: " + n.toString());
            return;
        }
        AnimalHarvestRecipe recipe = new AnimalHarvestRecipe(n, clazz);
        harvestRecipes.put(n, recipe);
        harvestClasses = null;
    }

    public static void removeAnimalHarvestRecipe(ResourceLocation location) {
        harvestClasses = null;
        harvestRecipes.remove(location);
    }

    public static void removeAnimalHarvestRecipe(Class<? extends Entity> clz) {
        harvestClasses = null;
        ResourceLocation toRemove = null;
        for (Map.Entry<ResourceLocation, AnimalHarvestRecipe> entry : harvestRecipes.entrySet()) {
            AnimalHarvestRecipe recipe = entry.getValue();
            if (!recipe.getHarvestClass().equals(clz)) continue;
            toRemove = entry.getKey();
        }
        if (toRemove != null) {
            harvestRecipes.remove(toRemove);
        }
    }

    public static void removeAnimalHarvestRecipe(Entity entity) {
        ResourceLocation n = new ResourceLocation("roots", entity.func_70005_c_());
        if (harvestRecipes.containsKey(n)) {
            harvestRecipes.remove(n);
            harvestClasses = null;
        } else {
            n = null;
            for (Map.Entry<ResourceLocation, AnimalHarvestRecipe> entry : harvestRecipes.entrySet()) {
                if (!entry.getValue().matches(entity)) continue;
                n = entry.getKey();
                break;
            }
            if (n != null) {
                harvestRecipes.remove(n);
                harvestClasses = null;
            }
        }
    }

    public static void getAnimalHarvestRecipe(ResourceLocation location) {
        harvestRecipes.getOrDefault(location, null);
    }

    public static AnimalHarvestRecipe getAnimalHarvestRecipe(Entity entity) {
        ResourceLocation n = new ResourceLocation("roots", entity.func_70005_c_());
        if (harvestRecipes.containsKey(n)) {
            return harvestRecipes.get(n);
        }
        for (AnimalHarvestRecipe recipe : harvestRecipes.values()) {
            if (!recipe.matches(entity)) continue;
            return recipe;
        }
        return null;
    }

    public static ObjectOpenHashSet<Class<? extends Entity>> getAnimalHarvestClasses() {
        if (harvestClasses == null || harvestClasses.size() != harvestRecipes.size()) {
            harvestClasses = new ObjectOpenHashSet();
            for (AnimalHarvestRecipe recipe : harvestRecipes.values()) {
                harvestClasses.add(recipe.getHarvestClass());
            }
        }
        return harvestClasses;
    }

    public static void initAnimalHarvestRecipes() {
        ModRecipes.addAnimalHarvestRecipe("bat", EntityBat.class);
        ModRecipes.addAnimalHarvestRecipe("chicken", EntityChicken.class);
        ModRecipes.addAnimalHarvestRecipe("cow", EntityCow.class);
        ModRecipes.addAnimalHarvestRecipe("donkey", EntityDonkey.class);
        ModRecipes.addAnimalHarvestRecipe("horse", EntityHorse.class);
        ModRecipes.addAnimalHarvestRecipe("llama", EntityLlama.class);
        ModRecipes.addAnimalHarvestRecipe("mooshroom", EntityMooshroom.class);
        ModRecipes.addAnimalHarvestRecipe("mule", EntityMule.class);
        ModRecipes.addAnimalHarvestRecipe("ocelot", EntityOcelot.class);
        ModRecipes.addAnimalHarvestRecipe("parrot", EntityParrot.class);
        ModRecipes.addAnimalHarvestRecipe("pig", EntityPig.class);
        ModRecipes.addAnimalHarvestRecipe("rabbit", EntityRabbit.class);
        ModRecipes.addAnimalHarvestRecipe("sheep", EntitySheep.class);
        ModRecipes.addAnimalHarvestRecipe("squid", EntitySquid.class);
        ModRecipes.addAnimalHarvestRecipe("wolf", EntityWolf.class);
        ModRecipes.addAnimalHarvestRecipe("beetle", EntityBeetle.class);
        ModRecipes.addAnimalHarvestRecipe("deer", EntityDeer.class);
        ModRecipes.addAnimalHarvestRecipe("fox", EntityFox.class);
        ModRecipes.addAnimalHarvestRecipe("frog", EntityFrog.class);
    }

    public static void addRunicCarvingRecipe(RunicCarvingRecipe recipe) {
        for (RunicCarvingRecipe runicCarvingRecipe : runicCarvingRecipes) {
            if (!runicCarvingRecipe.matches(recipe)) continue;
            System.out.println("Recipe is already registered with carving block - " + recipe.getCarvingBlock() + ", rune block - " + recipe.getRuneBlock() + ", herb - " + recipe.getHerb().getItem());
            return;
        }
        runicCarvingRecipes.add(recipe);
    }

    public static RunicCarvingRecipe getRunicCarvingRecipe(IBlockState carvingBlock, Herb herb) {
        if (carvingBlock != null && herb != null) {
            for (RunicCarvingRecipe recipe : runicCarvingRecipes) {
                if (!recipe.getHerb().equals((Object)herb) || !recipe.getCarvingBlock().equals(carvingBlock)) continue;
                return recipe;
            }
        }
        return null;
    }

    public static RunicCarvingRecipe getRunicCarvingRecipe(String name) {
        if (name != null) {
            for (RunicCarvingRecipe recipe : runicCarvingRecipes) {
                if (!recipe.getName().equals(name)) continue;
                return recipe;
            }
        }
        return null;
    }

    public static void addRunicShearRecipe(RunicShearRecipe recipe) {
        for (RunicShearRecipe runicShearRecipe : runicShearRecipes.values()) {
            if (recipe.isBlockRecipe() && recipe.getBlock() == runicShearRecipe.getBlock()) {
                System.out.println("Recipe is already registered with block - " + recipe.getBlock().func_149739_a());
                return;
            }
            if (!recipe.isEntityRecipe() || recipe.getClazz() != runicShearRecipe.getClazz()) continue;
            System.out.println("Recipe is already registered with entity - " + recipe.getClazz().getName());
            return;
        }
        if (recipe.isEntityRecipe()) {
            runicShearEntityRecipes.put(recipe.getClazz(), recipe);
        } else {
            runicShearRecipes.put(recipe.getName(), recipe);
        }
    }

    public static RunicShearRecipe getRunicShearRecipe(Block block) {
        for (RunicShearRecipe recipe : runicShearRecipes.values()) {
            if (!recipe.isBlockRecipe() || recipe.getBlock() != block) continue;
            return recipe;
        }
        return null;
    }

    public static RunicShearRecipe getRunicShearRecipe(EntityLivingBase entity) {
        return runicShearEntityRecipes.get(entity.getClass());
    }

    public static RunicShearRecipe getRunicShearRecipe(String name) {
        for (RunicShearRecipe recipe : runicShearRecipes.values()) {
            if (!recipe.getName().equals(name)) continue;
            return recipe;
        }
        return null;
    }

    public static RunicShearRecipe getRunicShearRecipe(ItemStack stack) {
        for (RunicShearRecipe recipe : runicShearRecipes.values()) {
            if (!ItemStack.func_77989_b((ItemStack)recipe.getDrop(), (ItemStack)stack)) continue;
            return recipe;
        }
        return null;
    }

    public static RunicShearRecipe getRunicShearEntityRecipe(ItemStack stack) {
        for (RunicShearRecipe recipe : runicShearEntityRecipes.values()) {
            if (!ItemStack.func_77989_b((ItemStack)recipe.getDrop(), (ItemStack)stack)) continue;
            return recipe;
        }
        return null;
    }

    public static Set<Class<? extends Entity>> getRunicShearEntities() {
        return runicShearEntityRecipes.keySet();
    }

    public static void addMortarRecipe(MortarRecipe recipe) {
        mortarRecipes.add(recipe);
    }

    public static MortarRecipe getMortarRecipe(List<ItemStack> items) {
        for (MortarRecipe mortarRecipe : mortarRecipes) {
            if (!mortarRecipe.matches(items)) continue;
            return mortarRecipe;
        }
        return null;
    }

    public static void removeMortarRecipes(ItemStack output) {
        mortarRecipes.removeIf(recipe -> ItemUtil.equalWithoutSize(recipe.getResult(), output));
    }

    public static MortarRecipe getMortarRecipe(ItemStack output) {
        for (MortarRecipe mortarRecipe : mortarRecipes) {
            if (!mortarRecipe.getResult().func_77969_a(output)) continue;
            return mortarRecipe;
        }
        return null;
    }

    public static MortarRecipe getMortarRecipe(String name, int meta) {
        ResourceLocation item = new ResourceLocation(name);
        for (MortarRecipe mortarRecipe : mortarRecipes) {
            ItemStack output = mortarRecipe.getResult();
            if (!output.func_77973_b().getRegistryName().equals((Object)item) || output.func_77960_j() != meta) continue;
            return mortarRecipe;
        }
        return null;
    }

    private static void addMortarRecipe(ItemStack output, Ingredient input, float red1, float green1, float blue1, float red2, float green2, float blue2) {
        mortarRecipes.addAll(ModRecipes.getMortarRecipeList(output, input, red1, green1, blue1, red2, green2, blue2));
    }

    public static List<MortarRecipe> getMortarRecipeList(ItemStack output, Ingredient input) {
        return ModRecipes.getMortarRecipeList(output, input, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public static List<MortarRecipe> getMortarRecipeList(ItemStack output, Ingredient input, float red1, float green1, float blue1, float red2, float green2, float blue2) {
        ArrayList<MortarRecipe> result = new ArrayList<MortarRecipe>();
        ArrayList<Ingredient> ingredients = new ArrayList<Ingredient>();
        int count = output.func_190916_E();
        for (int i = 0; i < 5; ++i) {
            ingredients.add(input);
            ItemStack copy = output.func_77946_l();
            copy.func_190920_e((i + 1) * count);
            MortarRecipe recipe = new MortarRecipe(copy, ingredients.toArray(new Ingredient[0]), red1, green1, blue1, red2, green2, blue2);
            result.add(recipe);
        }
        return result;
    }

    public static SpellBase getSpellRecipe(String name) {
        return SpellRegistry.getSpell(name);
    }

    public static SpellBase getSpellRecipe(List<ItemStack> items) {
        for (SpellBase spell : SpellRegistry.spellRegistry.values()) {
            if (!spell.matchesIngredients(items)) continue;
            return spell;
        }
        return null;
    }

    public static PyreCraftingRecipe getCraftingRecipe(List<ItemStack> items) {
        items.removeIf(ItemStack::func_190926_b);
        for (Map.Entry<String, PyreCraftingRecipe> pyreCraftingRecipe : pyreCraftingRecipes.entrySet()) {
            if (!pyreCraftingRecipe.getValue().matches(items)) continue;
            return pyreCraftingRecipe.getValue();
        }
        return null;
    }

    public static void addFeyCraftingRecipe(ResourceLocation name, FeyCraftingRecipe recipe) {
        assert (!feyCraftingRecipes.containsKey(name));
        feyCraftingRecipes.put(name, recipe);
    }

    public static void addPyreCraftingRecipe(ResourceLocation name, PyreCraftingRecipe recipe) {
        assert (!pyreCraftingRecipes.containsKey(name.func_110623_a()));
        pyreCraftingRecipes.put(name.func_110623_a(), recipe);
    }

    public static Map<ResourceLocation, FeyCraftingRecipe> getFeyCraftingRecipes() {
        return feyCraftingRecipes;
    }

    @Nullable
    public static FeyCraftingRecipe getFeyCraftingRecipe(List<ItemStack> items) {
        for (FeyCraftingRecipe recipe : feyCraftingRecipes.values()) {
            if (!recipe.matches(items)) continue;
            return recipe;
        }
        return null;
    }

    public static FeyCraftingRecipe getFeyCraftingRecipe(String name) {
        return ModRecipes.getFeyCraftingRecipe(new ResourceLocation("roots", name));
    }

    @Nullable
    public static FeyCraftingRecipe getFeyCraftingRecipe(ResourceLocation name) {
        return feyCraftingRecipes.get(name);
    }

    public static PyreCraftingRecipe getCraftingRecipe(String recipeName) {
        return pyreCraftingRecipes.get(recipeName);
    }

    public static void removePyreCraftingRecipe(ResourceLocation name) {
        pyreCraftingRecipes.remove(name.func_110623_a());
    }

    public static void removePyreCraftingRecipe(ItemStack output) {
        pyreCraftingRecipes.entrySet().removeIf(recipe -> ItemUtil.equalWithoutSize(((PyreCraftingRecipe)recipe.getValue()).getResult(), output));
    }

    public static void removeFeyCraftingRecipe(ResourceLocation name) {
        feyCraftingRecipes.remove(name);
    }

    private static void addCraftingRecipe(String recipeName, PyreCraftingRecipe pyreCraftingRecipe) {
        for (Map.Entry<String, PyreCraftingRecipe> pyreCraftingRecipeEntry : pyreCraftingRecipes.entrySet()) {
            if (!pyreCraftingRecipeEntry.getValue().matches(pyreCraftingRecipe.getRecipe())) continue;
            System.out.println("A Crafting Recipe is already registered");
            return;
        }
        pyreCraftingRecipes.put(recipeName, pyreCraftingRecipe.setName(recipeName));
    }

    private static void addCraftingRecipe(String recipeName, FeyCraftingRecipe recipe) {
        ResourceLocation recipeId = new ResourceLocation("roots", recipeName);
        if (feyCraftingRecipes.containsKey(recipeId)) {
            System.out.println("GroveCraftingRecipe already registered with name " + recipeName);
            return;
        }
        feyCraftingRecipes.put(recipeId, recipe.setName(recipeName));
    }

    public static List<RunicCarvingRecipe> getRunicCarvingRecipes() {
        return runicCarvingRecipes;
    }

    public static Map<String, RunicShearRecipe> getRunicShearRecipes() {
        return runicShearRecipes;
    }

    public static Map<Class<? extends Entity>, RunicShearRecipe> getRunicShearEntityRecipes() {
        return runicShearEntityRecipes;
    }

    public static Map<String, PyreCraftingRecipe> getPyreCraftingRecipes() {
        return pyreCraftingRecipes;
    }

    public static Map<ResourceLocation, AnimalHarvestRecipe> getHarvestRecipes() {
        return harvestRecipes;
    }

    public static List<MortarRecipe> getMortarRecipes() {
        return mortarRecipes;
    }

    public static void initMortarRecipes() {
        ModRecipes.addMortarRecipe(new ItemStack(Items.field_151100_aR, 1, 12), Ingredient.func_193367_a((Item)epicsquid.mysticalworld.init.ModItems.carapace), 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f);
        ModRecipes.addMortarRecipe(new ItemStack(ModItems.flour), Ingredient.func_193367_a((Item)Items.field_151015_O), 1.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f);
        ModRecipes.addMortarRecipe(new ItemStack(ModItems.flour), Ingredient.func_193367_a((Item)Items.field_151174_bG), 1.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f);
        ModRecipes.addMortarRecipe(new ItemStack(Items.field_151100_aR, 4, 15), Ingredient.func_193367_a((Item)Items.field_151103_aS), 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        ModRecipes.addMortarRecipe(new ItemStack(Items.field_151102_aT, 2), (Ingredient)new OreIngredient("sugarcane"), 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        for (Metal metal : Metal.values()) {
            Item metalDust;
            if (!metal.isEnabled() || (metalDust = metal.getDust()) == null) continue;
            ModRecipes.addMortarRecipe(new ItemStack(metalDust), (Ingredient)new OreIngredient("ingot" + metal.getOredictNameSuffix()), 0.32156864f, 0.36078432f, 0.44705883f, 0.627451f, 0.654902f, 0.7176471f);
        }
        ModRecipes.addMortarRecipe(new ItemStack(epicsquid.mysticalworld.init.ModItems.gold_dust), (Ingredient)new OreIngredient("ingotGold"), 0.32156864f, 0.36078432f, 0.44705883f, 0.627451f, 0.654902f, 0.7176471f);
        ModRecipes.addMortarRecipe(new ItemStack(epicsquid.mysticalworld.init.ModItems.iron_dust), (Ingredient)new OreIngredient("ingotIron"), 0.32156864f, 0.36078432f, 0.44705883f, 0.627451f, 0.654902f, 0.7176471f);
        ModRecipes.addMortarRecipe(new ItemStack(ModItems.petals), (Ingredient)new OreIngredient("allFlowers"), 1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f);
        ModRecipes.addMortarRecipe(new ItemStack(ModItems.runic_dust), (Ingredient)new OreIngredient("runestone"), 0.0f, 0.0f, 1.0f, 0.23529412f, 0.0f, 1.0f);
    }

    public static void initRecipes(@Nonnull RegisterModRecipesEvent event) {
        ModRecipes.initDrops();
        ModRecipes.initMortarRecipes();
        ModRecipes.initAnimalHarvestRecipes();
        ModRecipes.initTransmutationRecipes();
        ModRecipes.initPacifistEntities();
        ModRecipes.initVanillaBarkRecipes();
        ModRecipes.initModdedBarkRecipes();
        ModRecipes.initFlowerRecipes();
        GameRegistry.addSmelting((Item)ModItems.flour, (ItemStack)new ItemStack(Items.field_151025_P), (float)0.125f);
        GameRegistry.addSmelting((Item)epicsquid.mysticalworld.init.ModItems.iron_dust, (ItemStack)new ItemStack(Items.field_151042_j), (float)0.125f);
        GameRegistry.addSmelting((Item)epicsquid.mysticalworld.init.ModItems.gold_dust, (ItemStack)new ItemStack(Items.field_151043_k), (float)0.125f);
        GameRegistry.addSmelting((Item)ModItems.seeds, (ItemStack)new ItemStack(ModItems.cooked_seeds), (float)0.05f);
        GameRegistry.addSmelting((Item)ModItems.pereskia_bulb, (ItemStack)new ItemStack(ModItems.cooked_pereskia), (float)0.125f);
        ModRecipes.initCraftingRecipes();
        RunicShearRecipes.initRecipes();
    }

    private static void initCraftingRecipes() {
        ModRecipes.addCraftingRecipe("infernal_bulb", new PyreCraftingRecipe(new ItemStack(ModItems.infernal_bulb, 3), 1).addIngredients(new ItemStack(Items.field_151075_bm), new ItemStack(ItemBlock.func_150898_a((Block)Blocks.field_189877_df)), new ItemStack(Items.field_151072_bj), new ItemStack(ModItems.wildroot), new ItemStack(Items.field_151016_H)));
        ModRecipes.addCraftingRecipe("dewgonia", new PyreCraftingRecipe(new ItemStack(ModItems.dewgonia, 3), 1).addIngredients(new ItemStack(Item.func_150898_a((Block)Blocks.field_150329_H), 1, 1), new ItemStack(Items.field_151102_aT), new ItemStack(Items.field_151100_aR, 1, 4), new ItemStack(ModItems.terra_moss), new ItemStack(Item.func_150898_a((Block)Blocks.field_150392_bi))));
        ModRecipes.addCraftingRecipe("cloud_berry", new PyreCraftingRecipe(new ItemStack(ModItems.cloud_berry, 3), 1).addIngredients(new OreIngredient("treeLeaves"), new ItemStack(Item.func_150898_a((Block)Blocks.field_150329_H), 1, 1), new OreIngredient("blockWool"), new ItemStack(ModItems.terra_moss), new ItemStack(ModItems.terra_moss)));
        ModRecipes.addCraftingRecipe("stalicripe", new PyreCraftingRecipe(new ItemStack(ModItems.stalicripe, 3), 1).addIngredients(new ItemStack(Items.field_151145_ak), new OreIngredient("stone"), new OreIngredient("ingotIron"), new ItemStack(ModItems.wildroot), new OreIngredient("dustRedstone")));
        ModRecipes.addCraftingRecipe("moonglow_leaf", new PyreCraftingRecipe(new ItemStack(ModItems.moonglow_leaf, 3), 1).addIngredients(new OreIngredient("treeLeaves"), new OreIngredient("blockGlass"), new OreIngredient("gemQuartz"), new ItemStack(ModItems.bark_birch), new ItemStack(ModItems.bark_birch)));
        ModRecipes.addCraftingRecipe("pereskia", new PyreCraftingRecipe(new ItemStack(ModItems.pereskia, 3), 1).addIngredients(new ItemStack(ModItems.wildroot), new ItemStack(Items.field_151060_bw), new OreIngredient("dustRedstone"), new ItemStack(Items.field_185164_cV), new ItemStack(Items.field_151120_aE)));
        ModRecipes.addCraftingRecipe("baffle_cap", new PyreCraftingRecipe(new ItemStack(Item.func_150898_a((Block)ModBlocks.baffle_cap_mushroom), 3), 1).addIngredients(new ItemStack(ModItems.terra_moss), new ItemStack(Items.field_151071_bq), new ItemStack(Items.field_151014_N), new ItemStack((Block)Blocks.field_150337_Q), new ItemStack((Block)Blocks.field_150338_P)));
        ModRecipes.addCraftingRecipe("seeds", new PyreCraftingRecipe(new ItemStack(ModItems.cooked_seeds, 5), 1).addIngredients(new ItemStack(ModItems.seeds), new ItemStack(ModItems.seeds), new ItemStack(ModItems.seeds), new ItemStack(ModItems.seeds), new ItemStack(ModItems.seeds)).setBurnTime(20));
        ModRecipes.addCraftingRecipe("unending_bowl", new FeyCraftingRecipe(new ItemStack(ItemBlock.func_150898_a((Block)ModBlocks.unending_bowl)), 2).addIngredients(new ItemStack(Items.field_151131_as), new ItemStack(ItemBlock.func_150898_a((Block)ModBlocks.mortar)), new ItemStack(ModItems.dewgonia), new ItemStack(ModItems.terra_moss), new ItemStack(ModItems.dewgonia)));
        ModRecipes.addCraftingRecipe("elemental_soil", new FeyCraftingRecipe(new ItemStack(ModBlocks.elemental_soil), 1).addIngredients(new ItemStack(Blocks.field_150346_d), new ItemStack(ModItems.terra_moss), new ItemStack(ModItems.wildroot), new ItemStack(Blocks.field_150351_n), new ItemStack(Items.field_151100_aR, 1, 15)));
        ModRecipes.addCraftingRecipe("living_pickaxe", new FeyCraftingRecipe(new ItemStack(ModItems.living_pickaxe), 1).addIngredients(new Object[]{new GoldOrSilverIngotIngredient(), new ItemStack(Items.field_151039_o), new ItemStack(ModItems.wildroot), new ItemStack(ModItems.bark_oak), new ItemStack(ModItems.bark_oak)}));
        ModRecipes.addCraftingRecipe("living_axe", new FeyCraftingRecipe(new ItemStack(ModItems.living_axe), 1).addIngredients(new Object[]{new GoldOrSilverIngotIngredient(), new ItemStack(Items.field_151053_p), new ItemStack(ModItems.wildroot), new ItemStack(ModItems.bark_oak), new ItemStack(ModItems.bark_oak)}));
        ModRecipes.addCraftingRecipe("living_shovel", new FeyCraftingRecipe(new ItemStack(ModItems.living_shovel), 1).addIngredients(new Object[]{new GoldOrSilverIngotIngredient(), new ItemStack(Items.field_151038_n), new ItemStack(ModItems.wildroot), new ItemStack(ModItems.bark_oak), new ItemStack(ModItems.bark_oak)}));
        ModRecipes.addCraftingRecipe("living_hoe", new FeyCraftingRecipe(new ItemStack(ModItems.living_hoe), 1).addIngredients(new Object[]{new GoldOrSilverIngotIngredient(), new ItemStack(Items.field_151017_I), new ItemStack(ModItems.wildroot), new ItemStack(ModItems.bark_oak), new ItemStack(ModItems.bark_oak)}));
        ModRecipes.addCraftingRecipe("living_sword", new FeyCraftingRecipe(new ItemStack(ModItems.living_sword), 1).addIngredients(new Object[]{new GoldOrSilverIngotIngredient(), new ItemStack(Items.field_151041_m), new ItemStack(ModItems.wildroot), new ItemStack(ModItems.bark_oak), new ItemStack(ModItems.bark_oak)}));
        ModRecipes.addCraftingRecipe("living_arrow", new FeyCraftingRecipe(new ItemStack(ModItems.living_arrow, 6), 1).addIngredients(new OreIngredient("treeLeaves"), new OreIngredient("treeLeaves"), new OreIngredient("rootsBark"), new ItemStack(ModItems.wildroot), new ItemStack(Items.field_151145_ak)));
        ModRecipes.addCraftingRecipe("wildwood_quiver", new FeyCraftingRecipe(new ItemStack(ModItems.wildwood_quiver), 2).addIngredients(new OreIngredient("chestWood"), new ItemStack(ModItems.bark_wildwood), new ItemStack(ModItems.bark_wildwood), new ItemStack(ModItems.terra_moss), new ItemStack(ModItems.spirit_herb)));
        ModRecipes.addCraftingRecipe("wildwood_bow", new FeyCraftingRecipe(new ItemStack(ModItems.wildwood_bow), 2).addIngredients(new ItemStack((Item)Items.field_151031_f), new ItemStack(ModItems.bark_wildwood), new ItemStack(ModItems.bark_wildwood), new ItemStack(ModItems.terra_moss), new ItemStack(ModItems.spirit_herb)));
        ModRecipes.addCraftingRecipe("runic_shears", new FeyCraftingRecipe(new ItemStack(ModItems.runic_shears), 1).addIngredients(new ItemStack((Item)Items.field_151097_aZ), new ItemStack(ModItems.pereskia), new ItemStack(ModItems.pereskia), new ItemStack(ModBlocks.runestone), new ItemStack(ModBlocks.runestone)));
        ModRecipes.addCraftingRecipe("runestone", new FeyCraftingRecipe(new ItemStack(Item.func_150898_a((Block)ModBlocks.runestone), 8), 1).addIngredients(new ItemStack(Items.field_151100_aR, 1, 4), new OreIngredient("stone"), new OreIngredient("stone"), new OreIngredient("stone"), new OreIngredient("stone")));
        ModRecipes.addCraftingRecipe("wildwood_helmet", new FeyCraftingRecipe(new ItemStack(ModItems.wildwood_helmet), 1).addIngredients(new ItemStack((Item)Items.field_151028_Y), new ItemStack(ModItems.bark_wildwood), new ItemStack(ModItems.bark_wildwood), new OreIngredient("plankWood"), new OreIngredient("gemDiamond")));
        ModRecipes.addCraftingRecipe("wildwood_chestplate", new FeyCraftingRecipe(new ItemStack(ModItems.wildwood_chestplate), 1).addIngredients(new ItemStack((Item)Items.field_151030_Z), new ItemStack(ModItems.bark_wildwood), new ItemStack(ModItems.bark_wildwood), new OreIngredient("plankWood"), new OreIngredient("gemDiamond")));
        ModRecipes.addCraftingRecipe("wildwood_leggings", new FeyCraftingRecipe(new ItemStack(ModItems.wildwood_leggings), 1).addIngredients(new ItemStack((Item)Items.field_151165_aa), new ItemStack(ModItems.bark_wildwood), new ItemStack(ModItems.bark_wildwood), new OreIngredient("plankWood"), new OreIngredient("gemDiamond")));
        ModRecipes.addCraftingRecipe("wildwood_boots", new FeyCraftingRecipe(new ItemStack(ModItems.wildwood_boots), 1).addIngredients(new ItemStack((Item)Items.field_151167_ab), new ItemStack(ModItems.bark_wildwood), new ItemStack(ModItems.bark_wildwood), new OreIngredient("plankWood"), new OreIngredient("gemDiamond")));
        ModRecipes.addCraftingRecipe("apothecary_pouch", new ApothecaryPouchRecipe(new ItemStack(ModItems.apothecary_pouch), 1).addIngredients(new ItemStack(Blocks.field_150477_bB), new ItemStack(ModItems.bark_wildwood), new ItemStack(ModItems.bark_wildwood), new ItemStack(ModItems.spirit_herb), new ItemStack(ModItems.component_pouch)));
        ModRecipes.addCraftingRecipe("sylvan_helmet", new FeyCraftingRecipe(new ItemStack(ModItems.sylvan_helmet), 1).addIngredients(new ItemStack(ModItems.fey_leather), new ItemStack(Blocks.field_150395_bd), new ItemStack(ModItems.bark_birch), new OreIngredient("gemAmethyst"), new ItemStack((Item)Items.field_151028_Y)));
        ModRecipes.addCraftingRecipe("sylvan_chestplate", new FeyCraftingRecipe(new ItemStack(ModItems.sylvan_chestplate), 1).addIngredients(new ItemStack(ModItems.fey_leather), new ItemStack(Blocks.field_150395_bd), new ItemStack(ModItems.bark_birch), new OreIngredient("gemAmethyst"), new ItemStack((Item)Items.field_151030_Z)));
        ModRecipes.addCraftingRecipe("sylvan_leggings", new FeyCraftingRecipe(new ItemStack(ModItems.sylvan_leggings), 1).addIngredients(new ItemStack(ModItems.fey_leather), new ItemStack(Blocks.field_150395_bd), new ItemStack(ModItems.bark_birch), new OreIngredient("gemAmethyst"), new ItemStack((Item)Items.field_151165_aa)));
        ModRecipes.addCraftingRecipe("sylvan_boots", new FeyCraftingRecipe(new ItemStack(ModItems.sylvan_boots), 1).addIngredients(new ItemStack(ModItems.fey_leather), new ItemStack(Blocks.field_150395_bd), new ItemStack(ModItems.bark_birch), new OreIngredient("gemAmethyst"), new ItemStack((Item)Items.field_151167_ab)));
    }

    public static void afterHerbRegisterInit() {
    }

    private static void initDrops() {
    }
}

