/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.init;

import epicsquid.roots.Roots;
import epicsquid.roots.api.Herb;
import epicsquid.roots.api.RegisterHerbEvent;
import epicsquid.roots.init.ModBlocks;
import epicsquid.roots.init.ModItems;
import epicsquid.roots.init.ModRecipes;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryBuilder;

@Mod.EventBusSubscriber(modid="roots")
public class HerbRegistry {
    private static final ResourceLocation NAME = new ResourceLocation("roots", "herb");
    public static IForgeRegistry<Herb> REGISTRY = null;

    public static void init() {
        MinecraftForge.EVENT_BUS.post((Event)new RegisterHerbEvent(NAME, REGISTRY));
    }

    @SubscribeEvent
    public static void registerRegistry(@Nonnull RegistryEvent.NewRegistry event) {
        REGISTRY = new RegistryBuilder().setName(NAME).setType(Herb.class).setIDRange(0, 0xFFFFFF).create();
    }

    @SubscribeEvent
    public static void registerHerbs(@Nonnull RegisterHerbEvent event) {
        event.register(ModItems.spirit_herb, "spirit_herb");
        event.register(Item.func_150898_a((Block)ModBlocks.baffle_cap_mushroom), "baffle_cap");
        event.register(ModItems.moonglow_leaf, "moonglow_leaf");
        event.register(ModItems.pereskia, "pereskia");
        event.register(ModItems.terra_moss, "terra_moss");
        event.register(ModItems.wildroot, "wildroot");
        event.register(ModItems.wildewheet, "wildewheet");
        event.register(ModItems.infernal_bulb, "infernal_bulb");
        event.register(ModItems.dewgonia, "dewgonia");
        event.register(ModItems.stalicripe, "stalicripe");
        event.register(ModItems.cloud_berry, "cloud_berry");
        ModRecipes.afterHerbRegisterInit();
    }

    @Nullable
    public static Herb getHerbByName(@Nonnull String name) {
        Collection herbs = REGISTRY.getValuesCollection();
        for (Herb herb : herbs) {
            if (!herb.getName().equals(name)) continue;
            return herb;
        }
        Roots.logger.warn("Herb \"" + name + "\" not found in HerbRegistry");
        return null;
    }

    @Nullable
    public static Herb getHerbByItem(@Nonnull Item item) {
        Collection herbs = REGISTRY.getValuesCollection();
        for (Herb herb : herbs) {
            if (herb.getItem() != item) continue;
            return herb;
        }
        return null;
    }

    public static boolean containsHerbItem(@Nonnull Item item) {
        return REGISTRY.getValuesCollection().stream().anyMatch(herb -> herb.getItem() == item);
    }
}

